/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.siddump;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SIDDumpConfiguration {
    private static final String SID_ID_PKG = "libsidutils/siddump/";
    private static final String FILE_NAME = "siddump.xml";
    private ArrayList<SIDDumpPlayer> fPlayers;

    public SIDDumpConfiguration() throws IOException, ParserConfigurationException, SAXException {
        this.configure();
    }

    public ArrayList<SIDDumpPlayer> getPlayers() {
        return this.fPlayers;
    }

    private void configure() throws ParserConfigurationException, SAXException, IOException {
        try (InputStream is = this.getInputStream();){
            DocumentBuilderFactory fac = DocumentBuilderFactory.newInstance();
            fac.setIgnoringElementContentWhitespace(true);
            fac.setIgnoringComments(true);
            DocumentBuilder builder = fac.newDocumentBuilder();
            this.parse(builder.parse(is));
        }
    }

    private InputStream getInputStream() throws FileNotFoundException {
        for (String s : new String[]{System.getProperty("user.dir"), System.getProperty("user.home")}) {
            File file = new File(s, FILE_NAME);
            if (!file.exists()) continue;
            System.out.println("Using SIDDump file: " + file.getAbsolutePath());
            return new FileInputStream(file);
        }
        System.out.println("Using internal SIDDump file: libsidutils/siddump/siddump.xml");
        return this.getClass().getClassLoader().getResourceAsStream("libsidutils/siddump/siddump.xml");
    }

    private void parse(Document siddump) {
        Element root = siddump.getDocumentElement();
        NodeList player = root.getElementsByTagName("PLAYER");
        this.fPlayers = new ArrayList();
        for (int i = 0; i < player.getLength(); ++i) {
            this.fPlayers.add(this.createPlayer((Element)player.item(i)));
        }
    }

    private SIDDumpPlayer createPlayer(Element playerElement) {
        NamedNodeMap atts = playerElement.getAttributes();
        Node name = atts.getNamedItem("name");
        if (name != null) {
            SIDDumpPlayer player = new SIDDumpPlayer(name.getNodeValue());
            NodeList regs = playerElement.getElementsByTagName("REGS");
            NodeList reg = ((Element)regs.item(0)).getElementsByTagName("REG");
            for (int i = 0; i < reg.getLength(); ++i) {
                if (reg.item(i).getFirstChild() == null) continue;
                player.add(reg.item(i).getFirstChild().getNodeValue());
            }
            return player;
        }
        throw new RuntimeException("Invalid SIDDump configuration!");
    }

    public static class SIDDumpPlayer {
        private final String name;
        private final Collection<SIDDumpReg> regs;

        public SIDDumpPlayer(String name) {
            this.name = name;
            this.regs = new ArrayList<SIDDumpReg>();
        }

        public String getName() {
            return this.name;
        }

        public Collection<SIDDumpReg> getRegs() {
            return this.regs;
        }

        public String toString() {
            return this.getName();
        }

        private void add(String reg) {
            this.regs.add(SIDDumpReg.valueOf(reg));
        }
    }

    public static enum SIDDumpReg {
        FREQ_LO_1(0),
        FREQ_HI_1(1),
        PULSE_LO_1(2),
        PULSE_HI_1(3),
        WAVEFORM_1(4),
        ATTACK_DECAY_1(5),
        SUSTAIN_RELEASE_1(6),
        FREQ_LO_2(7),
        FREQ_HI_2(8),
        PULSE_LO_2(9),
        PULSE_HI_2(10),
        WAVEFORM_2(11),
        ATTACK_DECAY_2(12),
        SUSTAIN_RELEASE_2(13),
        FREQ_LO_3(14),
        FREQ_HI_3(15),
        PULSE_LO_3(16),
        PULSE_HI_3(17),
        WAVEFORM_3(18),
        ATTACK_DECAY_3(19),
        SUSTAIN_RELEASE_3(20),
        FILTERFREQ_LO(21),
        FILTERFREQ_HI(22),
        FILTERCTRL(23),
        VOL(24);

        private byte register;

        private SIDDumpReg(int register) {
            this.register = (byte)register;
        }

        public byte getRegister() {
            return this.register;
        }
    }
}

