/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.fasterxml.jackson.annotation.JsonProperty;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import libsidutils.IOUtils;
import server.restful.common.ContentTypeAndFileExtensions;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import server.restful.common.converter.WebResourceConverter;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.UsageParameter;
import ui.entities.collection.HVSCEntry;
import ui.entities.config.FavoritesSection;

@WebServlet(name="FavoritesServlet", displayName="FavoritesServlet", urlPatterns={"/jsidplay2service/JSIDPlay2REST/favorites"}, description="Get contents of a favorites tab")
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"user", "admin"}))
public class FavoritesServlet
extends JSIDPlay2Servlet {
    public static final String BUILT_IN_FAVORITES_PATH = "/favorites/jsidplay2-%d.json";

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block11: {
            try {
                FavoritesServletParameters servletParameters = new FavoritesServletParameters();
                ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
                if (servletParameters.getHelp().booleanValue() || parser.hasException()) {
                    parser.usage();
                    return;
                }
                Integer favoritesNumber = servletParameters.getFavoritesNumber();
                if (favoritesNumber == null) {
                    List favorites = this.getFavoritesByNumber(0).stream().map(fav -> ((FavoritesWrapper)fav).filename).collect(Collectors.toList());
                    this.setOutput(ContentTypeAndFileExtensions.MIME_TYPE_JSON, response, favorites);
                    break block11;
                }
                if (favoritesNumber < this.configuration.getFavorites().size()) {
                    List<FavoritesWrapper> favorites = this.getFavoritesByNumber(favoritesNumber);
                    this.setOutput(ContentTypeAndFileExtensions.MIME_TYPE_JSON, response, favorites);
                    break block11;
                }
                String resource = String.format(BUILT_IN_FAVORITES_PATH, favoritesNumber - this.configuration.getFavorites().size());
                try (InputStream is = new WebResourceConverter("<ServletPath>").convert(resource);){
                    this.setOutput(ContentTypeAndFileExtensions.MIME_TYPE_JSON, response, is);
                }
            }
            catch (Throwable t) {
                response.setStatus(500);
                ServletUtil.error(this.getServletContext(), t, new Thread[0]);
                this.setOutput(response, t);
            }
        }
    }

    private List<FavoritesWrapper> getFavoritesByNumber(Integer favoritesNumber) {
        return this.configuration.getFavorites().stream().filter(favorites -> this.configuration.getFavorites().indexOf(favorites) == favoritesNumber.intValue()).findFirst().map(FavoritesSection::getFavorites).orElseGet(Collections::emptyList).stream().map(this::getFavorite).collect(Collectors.toList());
    }

    private FavoritesWrapper getFavorite(HVSCEntry entry) {
        if (IOUtils.getFiles(entry.getPath(), this.configuration.getSidplay2Section().getHvsc(), null).size() > 0) {
            return new FavoritesWrapper("/C64Music" + entry.getPath());
        }
        if (IOUtils.getFiles(entry.getPath(), this.configuration.getSidplay2Section().getCgsc(), null).size() > 0) {
            return new FavoritesWrapper("/CGSC" + entry.getPath());
        }
        return null;
    }

    @Parameters(resourceBundle="server.restful.servlets.FavoritesServletParameters")
    public static class FavoritesServletParameters
    extends UsageParameter {
        private Integer favoritesNumber = null;

        public Integer getFavoritesNumber() {
            return this.favoritesNumber;
        }

        @Parameter(names={"--favoritesNumber"}, descriptionKey="FAVORITES_NUMBER", order=-2147483647)
        public void setFavoritesNumber(Integer favoritesNumber) {
            this.favoritesNumber = favoritesNumber;
        }
    }

    private static class FavoritesWrapper {
        @JsonProperty
        private String filename;

        private FavoritesWrapper(String filename) {
            this.filename = filename;
        }
    }
}

