/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets.whatssid;

import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import libsidutils.fingerprinting.rest.beans.HashBeans;
import server.restful.JSIDPlay2Server;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import ui.entities.whatssid.service.WhatsSidService;

@WebServlet(name="InsertHashesServlet", displayName="displayName", urlPatterns={"/jsidplay2service/JSIDPlay2REST/insert-hashes"}, description="WhatsSID tune recognition. Insert hashes")
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"admin"}))
public class InsertHashesServlet
extends JSIDPlay2Servlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPut(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            HashBeans hashes = this.getInput(request, HashBeans.class);
            WhatsSidService whatsSidService = new WhatsSidService(JSIDPlay2Server.getEntityManager());
            whatsSidService.insertHashes(hashes);
        }
        catch (Throwable t) {
            response.setStatus(500);
            ServletUtil.error(this.getServletContext(), t, new Thread[0]);
            this.setOutput(response, t);
        }
        finally {
            JSIDPlay2Server.freeEntityManager();
        }
    }
}

