/*
 * Decompiled with CFR 0.152.
 */
package ui.entities.collection.service;

import java.util.ArrayList;
import java.util.function.Function;
import javax.persistence.EntityManager;
import libsidutils.stil.STIL;
import ui.entities.collection.HVSCEntry;
import ui.entities.collection.StilEntry;

public class STILService {
    private EntityManager em;

    public STILService(EntityManager em) {
        this.em = em;
    }

    public void add(Function<String, STIL.STILEntry> stilFnct, HVSCEntry hvscEntry) {
        STIL.STILEntry stilEntry = stilFnct.apply(hvscEntry.getPath());
        if (stilEntry != null) {
            this.addSTILInfo(hvscEntry, stilEntry.getInfos());
            for (STIL.TuneEntry entry : stilEntry.getSubTunes()) {
                this.addSTILInfo(hvscEntry, entry.infos);
            }
        }
    }

    private void addSTILInfo(HVSCEntry hvscEntry, ArrayList<STIL.Info> infos) {
        for (STIL.Info info : infos) {
            StilEntry stil = new StilEntry(info);
            stil.setHvscEntry(hvscEntry);
            try {
                this.em.persist((Object)stil);
            }
            catch (Throwable e) {
                System.err.println("Tune: " + hvscEntry.getPath());
                System.err.println(e.getMessage());
            }
            hvscEntry.getStil().add(stil);
        }
    }

    public void clear() {
        this.em.createQuery("DELETE from StilEntry").executeUpdate();
    }
}

