/*
 * Decompiled with CFR 0.152.
 */
package ui.entities.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Access;
import javax.persistence.AccessType;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import sidplay.ini.converter.BeanToStringConverter;
import ui.common.properties.LazyListField;
import ui.common.properties.ObservableLazyListField;
import ui.common.properties.ShadowField;
import ui.entities.collection.HVSCEntry;
import ui.entities.collection.HVSCEntry_;
import ui.entities.config.FavoriteColumn;

@Entity
@Access(value=AccessType.PROPERTY)
public class FavoritesSection {
    public static final List<HVSCEntry> DEFAULT_FAVORITES = Collections.emptyList();
    public static List<FavoriteColumn> DEFAULT_COLUMNS;
    private Integer id;
    private ShadowField<StringProperty, String> name = new ShadowField<StringProperty, Object>(SimpleStringProperty::new, null);
    private ShadowField<DoubleProperty, Number> width = new ShadowField<DoubleProperty, Integer>(number -> new SimpleDoubleProperty(number.doubleValue()), 0);
    private ShadowField<IntegerProperty, Number> selectedRowFrom = new ShadowField<IntegerProperty, Integer>(number -> new SimpleIntegerProperty(number.intValue()), -1);
    private ShadowField<IntegerProperty, Number> selectedRowTo = new ShadowField<IntegerProperty, Integer>(number -> new SimpleIntegerProperty(number.intValue()), -1);
    private LazyListField<FavoriteColumn> columns = new LazyListField();
    private ObservableLazyListField<HVSCEntry> favorites = new ObservableLazyListField();

    @Id
    @GeneratedValue(strategy=GenerationType.AUTO)
    @XmlTransient
    @JsonIgnore
    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getName() {
        return this.name.get();
    }

    public void setName(String name) {
        this.name.set(name);
    }

    public final StringProperty nameProperty() {
        return this.name.property();
    }

    public Double getWidth() {
        return this.width.get().doubleValue();
    }

    public void setWidth(Double width) {
        this.width.set(width);
    }

    public final DoubleProperty widthProperty() {
        return this.width.property();
    }

    public Integer getSelectedRowFrom() {
        return this.selectedRowFrom.get().intValue();
    }

    public void setSelectedRowFrom(Integer selectedRowFrom) {
        this.selectedRowFrom.set(selectedRowFrom);
    }

    public final IntegerProperty selectedRowFromProperty() {
        return this.selectedRowFrom.property();
    }

    public Integer getSelectedRowTo() {
        return this.selectedRowTo.get().intValue();
    }

    public void setSelectedRowTo(Integer selectedRowTo) {
        this.selectedRowTo.set(selectedRowTo);
    }

    public final IntegerProperty selectedRowToProperty() {
        return this.selectedRowTo.property();
    }

    @OneToMany(cascade={CascadeType.ALL})
    public List<FavoriteColumn> getColumns() {
        if (DEFAULT_COLUMNS == null) {
            DEFAULT_COLUMNS = Arrays.asList(new FavoriteColumn(HVSCEntry_.title), new FavoriteColumn(HVSCEntry_.author), new FavoriteColumn(HVSCEntry_.released));
        }
        return this.columns.get(() -> DEFAULT_COLUMNS.stream().map(FavoriteColumn::new).collect(Collectors.toList()));
    }

    public void setColumns(List<FavoriteColumn> columns) {
        this.columns.set(columns);
    }

    @OneToMany(cascade={CascadeType.ALL})
    @XmlElement(name="favorite")
    public List<HVSCEntry> getFavorites() {
        return this.favorites.get(() -> new ArrayList<HVSCEntry>(DEFAULT_FAVORITES));
    }

    public void setFavorites(List<HVSCEntry> favorites) {
        this.favorites.set(favorites);
    }

    public final String toString() {
        return BeanToStringConverter.toString(this);
    }
}

