/*
 * Decompiled with CFR 0.152.
 */
package ui.entities.whatssid.service;

import java.util.Arrays;
import java.util.Collection;
import javax.persistence.EntityManager;
import javax.persistence.Parameter;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.ParameterExpression;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import libsidutils.fingerprinting.rest.FingerPrintingDataSource;
import libsidutils.fingerprinting.rest.beans.HashBean;
import libsidutils.fingerprinting.rest.beans.HashBeans;
import libsidutils.fingerprinting.rest.beans.IdBean;
import libsidutils.fingerprinting.rest.beans.IntArrayBean;
import libsidutils.fingerprinting.rest.beans.MusicInfoBean;
import libsidutils.fingerprinting.rest.beans.SongNoBean;
import server.restful.common.IServletSystemProperties;
import ui.entities.whatssid.HashTable;
import ui.entities.whatssid.HashTable_;
import ui.entities.whatssid.MusicInfo;
import ui.entities.whatssid.MusicInfo_;

public class WhatsSidService
implements FingerPrintingDataSource {
    private EntityManager em;

    public WhatsSidService(EntityManager em) {
        this.em = em;
    }

    @Override
    public IdBean insertTune(MusicInfoBean musicInfoBean) {
        try {
            if (this.em.isOpen()) {
                this.em.getTransaction().begin();
                MusicInfo musicInfo = new MusicInfo();
                musicInfo.setSongNo(musicInfoBean.getSongNo());
                musicInfo.setTitle(musicInfoBean.getTitle());
                musicInfo.setArtist(musicInfoBean.getArtist());
                musicInfo.setAlbum(musicInfoBean.getAlbum());
                musicInfo.setFileDir(musicInfoBean.getFileDir());
                musicInfo.setInfoDir(musicInfoBean.getInfoDir());
                musicInfo.setAudioLength(musicInfoBean.getAudioLength());
                this.em.persist((Object)musicInfo);
                this.em.getTransaction().commit();
                return new IdBean(musicInfo.getIdMusicInfo());
            }
        }
        catch (Exception e) {
            if (this.em.getTransaction().isActive()) {
                this.em.getTransaction().rollback();
            }
            throw e;
        }
        return null;
    }

    @Override
    public void insertHashes(HashBeans hashes) {
        if (hashes.getHashes() == null || hashes.getHashes().isEmpty()) {
            return;
        }
        try {
            if (this.em.isOpen()) {
                this.em.getTransaction().begin();
                for (HashBean hashBean : hashes.getHashes()) {
                    HashTable hashTable = new HashTable();
                    hashTable.setHash(hashBean.getHash());
                    hashTable.setId(hashBean.getId());
                    hashTable.setTime(hashBean.getTime());
                    this.em.persist((Object)hashTable);
                }
                this.em.getTransaction().commit();
            }
        }
        catch (Exception e) {
            if (this.em.getTransaction().isActive()) {
                this.em.getTransaction().rollback();
            }
            throw e;
        }
    }

    @Override
    public MusicInfoBean findTune(SongNoBean songNoBean) {
        try {
            if (this.em.isOpen()) {
                this.em.getTransaction().begin();
                CriteriaBuilder cb = this.em.getCriteriaBuilder();
                CriteriaQuery query = cb.createQuery(MusicInfo.class);
                Root root = query.from(MusicInfo.class);
                query.select((Selection)root).where((Expression)cb.equal((Expression)root.get(MusicInfo_.idMusicInfo), (Object)songNoBean.getSongNo()));
                MusicInfoBean result = ((MusicInfo)this.em.createQuery(query).getSingleResult()).toBean();
                this.em.getTransaction().commit();
                return result;
            }
        }
        catch (Exception e) {
            if (this.em.getTransaction().isActive()) {
                this.em.getTransaction().rollback();
            }
            throw e;
        }
        return null;
    }

    @Override
    public HashBeans findHashes(IntArrayBean intArrayBean) {
        HashBeans result = new HashBeans();
        if (intArrayBean.getHash() == null || intArrayBean.getHash().length == 0) {
            return result;
        }
        try {
            if (this.em.isOpen()) {
                this.em.getTransaction().begin();
                CriteriaBuilder cb = this.em.getCriteriaBuilder();
                CriteriaQuery query = cb.createQuery(HashTable.class);
                Root root = query.from(HashTable.class);
                ParameterExpression parameter = cb.parameter(Collection.class);
                query.select((Selection)root).where((Expression)root.get(HashTable_.hash).in(new Expression[]{parameter}));
                this.em.createQuery(query).setParameter((Parameter)parameter, Arrays.asList(intArrayBean.getHash())).setHint("org.hibernate.readOnly", (Object)true).setHint("javax.persistence.query.timeout", (Object)IServletSystemProperties.WhatsSIDServlet.QUERY_TIMEOUT).getResultList().stream().map(HashTable::toBean).forEach(result.getHashes()::add);
                this.em.getTransaction().commit();
                return result;
            }
        }
        catch (Exception e) {
            if (this.em.getTransaction().isActive()) {
                this.em.getTransaction().rollback();
            }
            throw e;
        }
        return null;
    }

    @Override
    public boolean tuneExists(MusicInfoBean musicInfoBean) {
        try {
            if (this.em.isOpen()) {
                this.em.getTransaction().begin();
                CriteriaBuilder cb = this.em.getCriteriaBuilder();
                CriteriaQuery query = cb.createQuery(Long.class);
                Root root = query.from(MusicInfo.class);
                Predicate songNoPredicate = cb.equal((Expression)root.get(MusicInfo_.songNo), (Object)musicInfoBean.getSongNo());
                Predicate titlePredicate = cb.equal((Expression)root.get(MusicInfo_.title), (Object)musicInfoBean.getTitle());
                Predicate artistPredicate = cb.equal((Expression)root.get(MusicInfo_.artist), (Object)musicInfoBean.getArtist());
                Predicate albumPredicate = cb.equal((Expression)root.get(MusicInfo_.album), (Object)musicInfoBean.getAlbum());
                Predicate fileDirPredicate = cb.equal((Expression)root.get(MusicInfo_.fileDir), (Object)musicInfoBean.getFileDir());
                Predicate infoDirPredicate = cb.equal((Expression)root.get(MusicInfo_.infoDir), (Object)musicInfoBean.getInfoDir());
                query.select((Selection)cb.count((Expression)root)).where((Expression)cb.and(new Predicate[]{songNoPredicate, titlePredicate, artistPredicate, albumPredicate, fileDirPredicate, infoDirPredicate}));
                boolean result = (Long)this.em.createQuery(query).getSingleResult() > 0L;
                this.em.getTransaction().commit();
                return result;
            }
        }
        catch (Exception e) {
            if (this.em.getTransaction().isActive()) {
                this.em.getTransaction().rollback();
            }
            throw e;
        }
        return false;
    }

    public void deleteAll() {
        try {
            if (this.em.isOpen()) {
                this.em.getTransaction().begin();
                CriteriaBuilder cb = this.em.getCriteriaBuilder();
                CriteriaDelete criteriaDeleteMusicInfo = cb.createCriteriaDelete(MusicInfo.class);
                criteriaDeleteMusicInfo.from(MusicInfo.class);
                this.em.createQuery(criteriaDeleteMusicInfo).executeUpdate();
                CriteriaDelete criteriaDeleteHashTable = cb.createCriteriaDelete(HashTable.class);
                criteriaDeleteHashTable.from(HashTable.class);
                this.em.createQuery(criteriaDeleteHashTable).executeUpdate();
                this.em.getTransaction().commit();
            }
        }
        catch (Exception e) {
            if (this.em.getTransaction().isActive()) {
                this.em.getTransaction().rollback();
            }
            throw e;
        }
    }

    public void close() {
        if (this.em.isOpen()) {
            this.em.close();
        }
    }
}

