/*
 * Decompiled with CFR 0.152.
 */
package ui.musiccollection;

import java.beans.PropertyChangeListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.concurrent.Task;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Control;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.TitledPane;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCode;
import javafx.stage.DirectoryChooser;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import javafx.util.StringConverter;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.PersistenceException;
import jsidplay2.Photos;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidplay.sidtune.SidTuneInfo;
import libsidutils.IOUtils;
import libsidutils.psid64.Psid64;
import libsidutils.siddatabase.SidDatabase;
import libsidutils.stil.STIL;
import net.java.truevfs.access.TFile;
import net.java.truevfs.access.TVFS;
import net.java.truevfs.kernel.spec.FsSyncException;
import sidplay.Player;
import sidplay.audio.Audio;
import ui.common.C64VBox;
import ui.common.C64Window;
import ui.common.TypeTextField;
import ui.common.UIPart;
import ui.common.converter.EnumToStringConverter;
import ui.common.download.DownloadThread;
import ui.common.download.MultiDownload;
import ui.common.download.ProgressListener;
import ui.common.filefilter.TuneFileFilter;
import ui.common.util.DesktopUtil;
import ui.entities.DatabaseType;
import ui.entities.PersistenceProperties;
import ui.entities.collection.HVSCEntry;
import ui.entities.collection.service.VersionService;
import ui.entities.config.AudioSection;
import ui.entities.config.Configuration;
import ui.entities.config.FavoritesSection;
import ui.entities.config.SidPlay2Section;
import ui.musiccollection.FileTreeCell;
import ui.musiccollection.MusicCollectionCellFactory;
import ui.musiccollection.MusicCollectionTreeItem;
import ui.musiccollection.MusicCollectionType;
import ui.musiccollection.SearchCriteria;
import ui.musiccollection.SearchCriteriaToString;
import ui.musiccollection.SearchResult;
import ui.musiccollection.SearchScope;
import ui.musiccollection.TuneInfo;
import ui.musiccollection.search.SearchInIndexThread;
import ui.musiccollection.search.SearchIndexCreator;
import ui.musiccollection.search.SearchIndexerThread;
import ui.musiccollection.search.SearchThread;
import ui.stilview.STILView;

public class MusicCollection
extends C64VBox
implements UIPart {
    @FXML
    private CheckBox autoConfiguration;
    @FXML
    private TableView<TuneInfo> tuneInfoTable;
    @FXML
    private TableColumn<TuneInfo, String> nameColumn;
    @FXML
    private TableColumn<TuneInfo, String> valueColumn;
    @FXML
    private TitledPane photographPane;
    @FXML
    private ImageView photograph;
    @FXML
    private TreeView<File> fileBrowser;
    @FXML
    private ComboBox<SearchCriteria<?, ?>> searchCriteria;
    @FXML
    private ComboBox<SearchScope> searchScope;
    @FXML
    private ComboBox<SearchResult> searchResult;
    @FXML
    private Button startSearch;
    @FXML
    private Button stopSearch;
    @FXML
    private Button resetSearch;
    @FXML
    private Button createSearchIndex;
    @FXML
    private TextField collectionDir;
    @FXML
    private TypeTextField stringTextField;
    @FXML
    private TypeTextField integerTextField;
    @FXML
    private TypeTextField longTextField;
    @FXML
    private TypeTextField shortTextField;
    @FXML
    private TypeTextField localDateTextField;
    @FXML
    private ComboBox<Enum<?>> combo;
    @FXML
    private ContextMenu contextMenu;
    @FXML
    private MenuItem showStil;
    @FXML
    private MenuItem convertToPSID64;
    @FXML
    private MenuItem soasc6581R2;
    @FXML
    private MenuItem soasc6581R3;
    @FXML
    private MenuItem soasc6581R4;
    @FXML
    private MenuItem soasc8580R5;
    @FXML
    private Menu addToFavoritesMenu;
    private final FileFilter tuneFilter = new TuneFileFilter();
    private ObjectProperty<MusicCollectionType> type;
    private ObservableList<TuneInfo> tuneInfos;
    private ObservableList<Enum<?>> comboItems;
    private ObjectProperty<List<TreeItem<File>>> currentlyPlayedTreeItemsProperty;
    private EntityManager em;
    private VersionService versionService;
    private SearchThread searchThread;
    private Object savedState;
    private Object searchForValue;
    private Object recentlySearchedForValue;
    private SearchCriteria<?, ?> recentlySearchedCriteria;
    private boolean searchOptionsChanged;
    private String hvscName;
    private int selectedSong;
    private FavoritesSection favoritesToAddSearchResult;
    private PropertyChangeListener tuneMatcherListener;
    private ChangeListener<? super TreeItem<File>> tuneInfoListener;
    private EventHandler<WindowEvent> contextMenuEvent;

    public MusicCollection() {
    }

    public MusicCollection(C64Window window, Player player) {
        super(window, player);
    }

    public MusicCollectionType getType() {
        return (MusicCollectionType)((Object)this.type.get());
    }

    public void setType(MusicCollectionType type) {
        this.type.set((Object)type);
    }

    @Override
    @FXML
    protected void initialize() {
        this.tuneMatcherListener = event -> Platform.runLater(() -> this.showCurrentTune(this.fileBrowser.getRoot() != null ? (File)this.fileBrowser.getRoot().getValue() : null));
        this.tuneInfoListener = (observable, oldValue, newValue) -> {
            if (newValue != null && ((File)newValue.getValue()).isFile()) {
                File tuneFile = (File)newValue.getValue();
                try {
                    SidTune sidTune = SidTune.load(tuneFile);
                    if (this.getType() == MusicCollectionType.HVSC) {
                        this.enableSOASC(sidTune.getInfo(), tuneFile);
                        this.showPhoto(sidTune.getInfo(), tuneFile);
                    }
                    this.showTuneInfos(tuneFile, sidTune);
                }
                catch (IOException | SidTuneError e) {
                    this.openErrorDialog(String.format(this.util.getBundle().getString("ERR_IO_ERROR"), e.getMessage()), this.getType());
                }
            }
        };
        this.contextMenuEvent = event -> {
            TreeItem selectedItem = (TreeItem)this.fileBrowser.getSelectionModel().getSelectedItem();
            this.showStil.setDisable(selectedItem == null || !((MusicCollectionTreeItem)selectedItem).hasSTIL());
            this.convertToPSID64.setDisable(selectedItem == null);
            SidPlay2Section sidplay2Section = this.util.getConfig().getSidplay2Section();
            List<FavoritesSection> favorites = this.util.getConfig().getFavorites();
            this.addToFavoritesMenu.getItems().clear();
            for (FavoritesSection section : favorites) {
                MenuItem item = new MenuItem(section.getName());
                item.setOnAction(event2 -> this.addFavorites(sidplay2Section, section, Collections.singletonList((File)selectedItem.getValue())));
                this.addToFavoritesMenu.getItems().add((Object)item);
            }
            this.addToFavoritesMenu.setDisable(this.addToFavoritesMenu.getItems().isEmpty());
        };
        this.util.getPlayer().stateProperty().addListener(this.tuneMatcherListener);
        this.tuneInfos = FXCollections.observableArrayList();
        SortedList sortedList = new SortedList(this.tuneInfos);
        sortedList.comparatorProperty().bind((ObservableValue)this.tuneInfoTable.comparatorProperty());
        this.tuneInfoTable.setItems((ObservableList)sortedList);
        this.tuneInfoTable.setPrefHeight(Double.MAX_VALUE);
        this.photographPane.setPrefHeight(Double.MAX_VALUE);
        this.nameColumn.prefWidthProperty().bind((ObservableValue)this.tuneInfoTable.widthProperty().multiply(0.4));
        this.valueColumn.prefWidthProperty().bind((ObservableValue)this.tuneInfoTable.widthProperty().multiply(0.6));
        this.searchScope.setConverter(new EnumToStringConverter(this.util.getBundle()));
        this.searchScope.setItems(FXCollections.observableArrayList((Object[])SearchScope.values()));
        this.searchScope.getSelectionModel().select((Object)SearchScope.FORWARD);
        this.searchResult.setConverter(new EnumToStringConverter(this.util.getBundle()));
        this.searchResult.setItems(FXCollections.observableArrayList((Object[])SearchResult.values()));
        this.searchResult.getSelectionModel().select((Object)SearchResult.SHOW_NEXT_MATCH);
        this.searchCriteria.setConverter((StringConverter)new SearchCriteriaToString(this.util.getBundle()));
        this.searchCriteria.setItems(FXCollections.observableArrayList(SearchCriteria.getSearchableAttributes()));
        this.searchCriteria.getSelectionModel().select(0);
        this.comboItems = FXCollections.observableArrayList();
        this.combo.setItems(this.comboItems);
        this.currentlyPlayedTreeItemsProperty = new SimpleObjectProperty(Collections.emptyList());
        this.contextMenu.setOnShown(this.contextMenuEvent);
        this.fileBrowser.setCellFactory(treeView -> new FileTreeCell());
        this.fileBrowser.getSelectionModel().selectedItemProperty().addListener(this.tuneInfoListener);
        this.fileBrowser.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                this.playSelected();
            }
        });
        this.fileBrowser.setOnMousePressed(event -> {
            if (event.isPrimaryButtonDown() && event.getClickCount() > 1) {
                this.playSelected();
            }
        });
        this.type = new SimpleObjectProperty();
        this.type.addListener((observable, oldValue, newValue) -> Platform.runLater(() -> {
            File initialRoot;
            switch (this.getType()) {
                case HVSC: {
                    initialRoot = this.util.getConfig().getSidplay2Section().getHvsc();
                    break;
                }
                case CGSC: {
                    initialRoot = this.util.getConfig().getSidplay2Section().getCgsc();
                    break;
                }
                default: {
                    throw new RuntimeException("Illegal music collection type: " + this.type);
                }
            }
            if (initialRoot != null) {
                this.setRoot(initialRoot);
            }
        }));
    }

    private void showCurrentTune(File initialRoot) {
        if (this.util.getPlayer().getTune() != SidTune.RESET && initialRoot != null) {
            SidTune tune = this.util.getPlayer().getTune();
            String collectionName = this.util.getPlayer().getSidDatabaseInfo(db -> db.getPath(tune), "");
            this.showNextHit((File)new TFile(initialRoot, collectionName));
        }
    }

    @Override
    public void doClose() {
        this.util.getPlayer().stateProperty().removeListener(this.tuneMatcherListener);
        this.closeDatabase();
    }

    private void closeDatabase() {
        if (this.fileBrowser.getRoot() != null && this.fileBrowser.getRoot().getValue() instanceof TFile) {
            TFile tf = (TFile)this.fileBrowser.getRoot().getValue();
            try {
                TVFS.umount((TFile)tf);
            }
            catch (FsSyncException e) {
                e.printStackTrace();
            }
        }
        if (this.em != null && this.em.isOpen()) {
            this.em.getEntityManagerFactory().close();
        }
    }

    @FXML
    private void showSTIL() {
        MusicCollectionTreeItem selectedItem = (MusicCollectionTreeItem)((Object)this.fileBrowser.getSelectionModel().getSelectedItem());
        if (selectedItem != null && selectedItem.hasSTIL()) {
            STILView stilInfo = new STILView(this.util.getPlayer());
            stilInfo.setEntry(selectedItem.getStilEntry());
            stilInfo.open();
        }
    }

    @FXML
    private void convertToPSID64() {
        SidPlay2Section sidPlay2Section = this.util.getConfig().getSidplay2Section();
        TreeItem selectedItem = (TreeItem)this.fileBrowser.getSelectionModel().getSelectedItem();
        DirectoryChooser fileDialog = new DirectoryChooser();
        fileDialog.setInitialDirectory(sidPlay2Section.getLastDirectory());
        File directory = fileDialog.showDialog(this.fileBrowser.getScene().getWindow());
        if (directory != null) {
            this.util.getConfig().getSidplay2Section().setLastDirectory(directory);
            Psid64 c = new Psid64();
            c.setTmpDir(this.util.getConfig().getSidplay2Section().getTmpDir());
            c.setVerbose(true);
            try {
                c.convertFiles(this.util.getPlayer(), new File[]{(File)selectedItem.getValue()}, directory, sidPlay2Section.getHvsc());
            }
            catch (IOException | SidTuneError e) {
                this.openErrorDialog(String.format(this.util.getBundle().getString("ERR_IO_ERROR"), e.getMessage()), this.getType());
            }
        }
    }

    @FXML
    private void startDownload6581R2() {
        String url = this.util.getConfig().getOnlineSection().getSoasc6581R2();
        this.downloadStart(url, 49);
    }

    @FXML
    private void startDownload6581R3() {
        String url = this.util.getConfig().getOnlineSection().getSoasc6581R3();
        this.downloadStart(url, 49);
    }

    @FXML
    private void startDownload6581R4() {
        String url = this.util.getConfig().getOnlineSection().getSoasc6581R4();
        this.downloadStart(url, 49);
    }

    @FXML
    private void startDownload8580R5() {
        String url = this.util.getConfig().getOnlineSection().getSoasc8580R5();
        this.downloadStart(url, 49);
    }

    @FXML
    private void doAutoConfiguration() {
        String urlSearchIndexProperties;
        String urlSearchIndex;
        String url;
        switch (this.getType()) {
            case HVSC: {
                url = this.util.getConfig().getOnlineSection().getHvscUrl();
                urlSearchIndex = this.util.getConfig().getOnlineSection().getHvscSearchIndexUrl();
                urlSearchIndexProperties = this.util.getConfig().getOnlineSection().getHvscSearchIndexPropertiesUrl();
                break;
            }
            case CGSC: {
                url = this.util.getConfig().getOnlineSection().getCgscUrl();
                urlSearchIndex = this.util.getConfig().getOnlineSection().getCgscSearchIndexUrl();
                urlSearchIndexProperties = this.util.getConfig().getOnlineSection().getCgscSearchIndexPropertiesUrl();
                break;
            }
            default: {
                throw new RuntimeException("Illegal music collection type: " + this.type);
            }
        }
        if (this.autoConfiguration.isSelected()) {
            this.autoConfiguration.setDisable(true);
            this.closeDatabase();
            MultiDownload multiDownload = new MultiDownload(this.util, this.fileBrowser.getScene(), downloadedFile -> Platform.runLater(() -> {
                this.autoConfiguration.setDisable(false);
                if (downloadedFile != null) {
                    this.setRoot((File)downloadedFile);
                }
            }));
            multiDownload.download(Arrays.asList(urlSearchIndex, urlSearchIndexProperties, url));
        }
    }

    @FXML
    private void searchCategory() {
        if (this.searchCriteria.getSelectionModel().getSelectedItem() != this.recentlySearchedCriteria) {
            this.searchOptionsChanged = true;
            this.recentlySearchedCriteria = (SearchCriteria)this.searchCriteria.getSelectionModel().getSelectedItem();
        }
        this.setSearchEditorVisible();
    }

    @FXML
    private void doStartSearch() {
        this.startSearch(false);
    }

    @FXML
    private void doStopSearch() {
        if (this.searchThread != null && this.searchThread.isAlive()) {
            this.searchThread.setAborted(true);
        }
    }

    @FXML
    private void doResetSearch() {
        this.savedState = null;
    }

    @FXML
    private void doCreateSearchIndex() {
        String msg = String.format(this.util.getBundle().getString("RECREATE_DATABASE"), ((MusicCollectionType)((Object)this.type.get())).toString());
        Alert alert = new Alert(Alert.AlertType.CONFIRMATION, msg, new ButtonType[0]);
        alert.setTitle(this.util.getBundle().getString("CREATE_SEARCH_DATABASE"));
        Optional result = alert.showAndWait();
        if (result.isPresent() && result.get() == ButtonType.OK) {
            this.startSearch(true);
        }
    }

    @FXML
    private void doBrowse() {
        DirectoryChooser fileDialog = new DirectoryChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectory());
        File directory = fileDialog.showDialog(this.autoConfiguration.getScene().getWindow());
        if (directory != null) {
            this.util.getConfig().getSidplay2Section().setLastDirectory(directory);
            this.setRoot(directory);
        }
    }

    @FXML
    private void gotoURL() {
        DesktopUtil.browse(((MusicCollectionType)((Object)this.type.get())).getUrl());
    }

    @FXML
    private void doSetValue() {
        this.setSearchValue();
        if (!Objects.equals(this.searchForValue, this.recentlySearchedForValue)) {
            this.searchOptionsChanged = true;
            this.recentlySearchedForValue = this.searchForValue;
        }
        this.startSearch(false);
    }

    private void setSearchEditorVisible() {
        for (Node node : Arrays.asList(new Control[]{this.stringTextField, this.integerTextField, this.localDateTextField, this.longTextField, this.shortTextField, this.combo})) {
            node.setVisible(false);
        }
        SearchCriteria selectedItem = (SearchCriteria)this.searchCriteria.getSelectionModel().getSelectedItem();
        Class clazz = selectedItem.getAttribute().getJavaType();
        if (clazz == Long.class) {
            this.longTextField.setVisible(true);
        } else if (clazz == Integer.class) {
            this.integerTextField.setVisible(true);
        } else if (clazz == LocalDateTime.class) {
            this.localDateTextField.setVisible(true);
        } else if (clazz == Short.class) {
            this.shortTextField.setVisible(true);
        } else if (clazz == String.class) {
            this.stringTextField.setVisible(true);
        } else if (Enum.class.isAssignableFrom(clazz)) {
            this.comboItems.clear();
            Class en = clazz;
            for (Enum val : (Enum[])en.getEnumConstants()) {
                this.comboItems.add((Object)val);
            }
            this.combo.setVisible(true);
            this.combo.getSelectionModel().select(0);
        }
    }

    private void setSearchValue() {
        SearchCriteria selectedItem = (SearchCriteria)this.searchCriteria.getSelectionModel().getSelectedItem();
        Class type = selectedItem.getAttribute().getJavaType();
        if (type == Integer.class) {
            this.searchForValue = this.integerTextField.getValue();
        } else if (type == Long.class) {
            this.searchForValue = this.longTextField.getValue();
        } else if (type == Short.class) {
            this.searchForValue = this.shortTextField.getValue();
        } else if (type == String.class) {
            this.searchForValue = this.stringTextField.getValue();
        } else if (Enum.class.isAssignableFrom(type)) {
            this.searchForValue = this.combo.getSelectionModel().getSelectedItem();
        } else if (type == LocalDateTime.class) {
            this.searchForValue = this.localDateTextField.getValue();
        }
    }

    private void setRoot(final File rootFile) {
        Task<Void> task = new Task<Void>(){

            public Void call() throws Exception {
                try {
                    SidPlay2Section sidPlay2Section = MusicCollection.this.util.getConfig().getSidplay2Section();
                    TFile theRootFile = new TFile(rootFile);
                    if (MusicCollection.this.getType() == MusicCollectionType.HVSC) {
                        MusicCollection.this.util.getPlayer().setSidDatabase(new SidDatabase((File)theRootFile));
                        MusicCollection.this.util.getPlayer().setSTIL(new STIL((File)theRootFile));
                        sidPlay2Section.setHvsc((File)theRootFile);
                        MusicCollection.this.setViewRoot(sidPlay2Section.getHvsc());
                    } else if (MusicCollection.this.getType() == MusicCollectionType.CGSC) {
                        sidPlay2Section.setCgsc((File)theRootFile);
                        MusicCollection.this.setViewRoot(sidPlay2Section.getCgsc());
                    }
                    MusicCollection.this.closeDatabase();
                    File dbFilename = new File(theRootFile.getParentFile(), ((MusicCollectionType)((Object)MusicCollection.this.type.get())).toString());
                    PersistenceProperties pp = new PersistenceProperties(DatabaseType.HSQL_FILE, "", "", dbFilename.getAbsolutePath());
                    EntityManagerFactory emFactory = Persistence.createEntityManagerFactory((String)((MusicCollectionType)((Object)MusicCollection.this.type.get())).getDataSource(), (Map)pp);
                    MusicCollection.this.em = emFactory.createEntityManager();
                    MusicCollection.this.versionService = new VersionService(MusicCollection.this.em);
                    Platform.runLater(() -> this.lambda$call$0((File)theRootFile));
                }
                catch (FileNotFoundException e) {
                    MusicCollection.this.openErrorDialog(String.format(MusicCollection.this.util.getBundle().getString("ERR_FILE_NOT_FOUND"), e.getMessage()), MusicCollection.this.getType());
                }
                catch (IOException | IllegalAccessException | IllegalStateException | NoSuchFieldException | PersistenceException e) {
                    StringWriter sw = new StringWriter();
                    e.printStackTrace(new PrintWriter(sw));
                    MusicCollection.this.openErrorDialog(sw.toString(), MusicCollection.this.getType());
                }
                return null;
            }

            private /* synthetic */ void lambda$call$0(File theRootFile) {
                MusicCollection.this.showCurrentTune(theRootFile);
            }
        };
        new Thread((Runnable)task).start();
    }

    private void openErrorDialog(String msg, MusicCollectionType type) {
        msg = String.format(this.util.getBundle().getString("ERR_CANNOT_CONFIGURE"), new Object[]{type}) + msg;
        Alert alert = new Alert(Alert.AlertType.ERROR, msg, new ButtonType[0]);
        alert.setTitle(this.util.getBundle().getString("ALERT_TITLE"));
        alert.showAndWait();
    }

    private void setViewRoot(File theRootFile) {
        Platform.runLater(() -> {
            MusicCollectionCellFactory cellFactory = new MusicCollectionCellFactory();
            cellFactory.setCurrentlyPlayedTreeItems(this.currentlyPlayedTreeItemsProperty);
            this.fileBrowser.setRoot((TreeItem)new MusicCollectionTreeItem(this.util.getPlayer(), theRootFile));
            this.fileBrowser.setCellFactory((Callback)cellFactory);
            this.collectionDir.setText(theRootFile.getAbsolutePath());
            this.doResetSearch();
        });
    }

    private void startSearch(boolean forceRecreate) {
        if (this.searchThread != null && this.searchThread.isAlive()) {
            return;
        }
        if (!new File(this.collectionDir.getText()).exists()) {
            return;
        }
        if (!forceRecreate && !this.versionService.isExpectedVersion()) {
            forceRecreate = true;
        }
        if (forceRecreate) {
            if (!this.em.isOpen()) {
                this.openErrorDialog(String.format(this.util.getBundle().getString("ERR_DATABASE"), new Object[0]), this.getType());
                return;
            }
            SearchIndexCreator searchIndexCreator = new SearchIndexCreator((File)this.fileBrowser.getRoot().getValue(), this.util.getPlayer(), this.em);
            Consumer<Void> searchStart = x -> {
                Platform.runLater(() -> {
                    this.disableSearch();
                    this.util.progressProperty(this.fileBrowser.getScene()).set(-1.0);
                });
                searchIndexCreator.getSearchStart().accept((Void)x);
            };
            Consumer<File> searchHit = searchIndexCreator.getSearchHit();
            Consumer<Boolean> searchStop = cancelled -> {
                Platform.runLater(() -> {
                    this.enableSearch();
                    this.util.progressProperty(this.fileBrowser.getScene()).set(0.0);
                });
                searchIndexCreator.getSearchStop().accept((Boolean)cancelled);
            };
            this.searchThread = new SearchIndexerThread((File)this.fileBrowser.getRoot().getValue(), searchStart, searchHit, searchStop);
            this.searchThread.start();
        } else {
            Consumer<Boolean> searchStop;
            Consumer<File> searchHit;
            Consumer<Void> searchStart;
            SidPlay2Section sidplay2Section = this.util.getConfig().getSidplay2Section();
            switch ((SearchResult)((Object)this.searchResult.getSelectionModel().getSelectedItem())) {
                case ADD_TO_A_NEW_PLAYLIST: {
                    searchStart = file -> Platform.runLater(() -> {
                        this.disableSearch();
                        this.createNewFavoritesTab();
                    });
                    searchHit = file -> {
                        while (this.favoritesToAddSearchResult == null) {
                            try {
                                Thread.sleep(1000L);
                            }
                            catch (InterruptedException e) {
                                e.printStackTrace();
                            }
                        }
                        this.addFavorite(sidplay2Section, this.favoritesToAddSearchResult, (File)file);
                    };
                    searchStop = cancelled -> Platform.runLater(() -> this.enableSearch());
                    break;
                }
                default: {
                    searchStart = x -> Platform.runLater(() -> this.disableSearch());
                    searchHit = file -> {
                        if (file.isFile()) {
                            this.searchThread.setAborted(true);
                            Platform.runLater(() -> {
                                this.enableSearch();
                                this.showNextHit((File)file);
                            });
                        }
                    };
                    searchStop = cancelled -> Platform.runLater(() -> this.enableSearch());
                }
            }
            this.setSearchValue();
            SearchInIndexThread t = new SearchInIndexThread(this.em, this.searchScope.getSelectionModel().getSelectedItem() == SearchScope.FORWARD, searchStart, searchHit, searchStop){

                @Override
                public List<File> getFiles(String filePath) {
                    return IOUtils.getFiles(filePath, (File)MusicCollection.this.fileBrowser.getRoot().getValue(), MusicCollection.this.tuneFilter);
                }
            };
            t.setField(((SearchCriteria)this.searchCriteria.getSelectionModel().getSelectedItem()).getAttribute());
            t.setFieldValue(this.searchForValue);
            t.setCaseSensitive(false);
            if (this.searchOptionsChanged) {
                this.doResetSearch();
                this.searchOptionsChanged = false;
            }
            this.searchThread = t;
            this.searchThread.setSearchState(this.savedState);
            this.searchThread.start();
        }
    }

    private void disableSearch() {
        this.startSearch.setDisable(true);
        this.stopSearch.setDisable(false);
        this.resetSearch.setDisable(true);
        this.createSearchIndex.setDisable(true);
    }

    private void enableSearch() {
        this.savedState = this.searchThread.getSearchState();
        this.startSearch.setDisable(false);
        this.stopSearch.setDisable(true);
        this.resetSearch.setDisable(false);
        this.createSearchIndex.setDisable(false);
    }

    private void showNextHit(File matchFile) {
        if (!matchFile.isFile()) {
            return;
        }
        TreeItem rootItem = this.fileBrowser.getRoot();
        if (rootItem == null || matchFile.getName().toLowerCase(Locale.ENGLISH).endsWith(".mp3")) {
            return;
        }
        ArrayList<TreeItem> pathSegs = new ArrayList<TreeItem>();
        pathSegs.add(rootItem);
        File rootFile = (File)rootItem.getValue();
        String filePath = matchFile.getPath();
        TreeItem curItem = rootItem;
        block0: for (File file : IOUtils.getFiles(filePath, rootFile, this.tuneFilter)) {
            for (TreeItem childItem : curItem.getChildren()) {
                if (!file.equals(childItem.getValue())) continue;
                curItem = childItem;
                pathSegs.add(curItem);
                childItem.setExpanded(true);
                continue block0;
            }
        }
        if (pathSegs.size() > 0) {
            this.currentlyPlayedTreeItemsProperty.set(pathSegs);
            TreeItem selectedItem = (TreeItem)this.fileBrowser.getSelectionModel().getSelectedItem();
            TreeItem treeItem = (TreeItem)pathSegs.get(pathSegs.size() - 1);
            if (selectedItem == null || !((File)treeItem.getValue()).equals(selectedItem.getValue())) {
                this.fileBrowser.getSelectionModel().select((Object)treeItem);
                this.fileBrowser.scrollTo(this.fileBrowser.getRow(treeItem));
            }
        }
    }

    private void createNewFavoritesTab() {
        FavoritesSection newFavorites = new FavoritesSection();
        newFavorites.setName(this.util.getBundle().getString("NEW_TAB"));
        this.favoritesToAddSearchResult = newFavorites;
        this.util.getConfig().getFavorites().add(newFavorites);
    }

    private void downloadStart(final String url, final int hvscVersion) {
        String realUrl = MessageFormat.format(url, hvscVersion, this.hvscName, this.selectedSong).trim();
        System.out.println("Download URL: <" + realUrl + ">");
        try {
            new DownloadThread(this.util.getConfig(), new ProgressListener(this.util, this.fileBrowser.getScene()){

                @Override
                public void downloaded(File downloadedFile) {
                    if ((downloadedFile == null || downloadedFile.length() < 1000L) && hvscVersion < 100) {
                        if (downloadedFile != null) {
                            downloadedFile.delete();
                        }
                        MusicCollection.this.downloadStart(url, hvscVersion + 1);
                    } else if (downloadedFile != null) {
                        downloadedFile.deleteOnExit();
                        Platform.runLater(() -> {
                            Configuration config = this.util.getConfig();
                            SidPlay2Section sidplay2Section = config.getSidplay2Section();
                            AudioSection audioSection = config.getAudioSection();
                            audioSection.setMp3(downloadedFile);
                            audioSection.setPlayOriginal(true);
                            audioSection.setAudio(Audio.COMPARE_MP3);
                            MusicCollection.this.playTune(IOUtils.getFile(MusicCollection.this.hvscName + ".sid", sidplay2Section.getHvsc(), null));
                        });
                    }
                }
            }, new URI(realUrl).toURL(), false).start();
        }
        catch (MalformedURLException | URISyntaxException e) {
            e.printStackTrace();
        }
    }

    private void enableSOASC(SidTuneInfo tuneInfo, File tuneFile) {
        this.soasc6581R2.setDisable(true);
        this.soasc6581R3.setDisable(true);
        this.soasc6581R4.setDisable(true);
        this.soasc8580R5.setDisable(true);
        File hvscFile = this.util.getConfig().getSidplay2Section().getHvsc();
        this.hvscName = IOUtils.getCollectionName(hvscFile, tuneFile);
        if (this.hvscName != null) {
            this.hvscName = this.hvscName.replace(".sid", "");
            this.selectedSong = tuneInfo.getSelectedSong();
            this.soasc6581R2.setDisable(false);
            this.soasc6581R3.setDisable(false);
            this.soasc6581R4.setDisable(false);
            this.soasc8580R5.setDisable(false);
        }
    }

    private void showPhoto(SidTuneInfo info, File tuneFile) {
        File hvscRoot = (File)this.fileBrowser.getRoot().getValue();
        String collectionName = null;
        if (tuneFile.getParentFile() != null) {
            collectionName = IOUtils.getCollectionName(hvscRoot, tuneFile.getParentFile());
        }
        String author = null;
        if (info.getInfoString().size() > 1) {
            Iterator<String> iterator = info.getInfoString().iterator();
            iterator.next();
            author = iterator.next();
        }
        this.photograph.setImage(new Image((InputStream)new ByteArrayInputStream(Photos.getPhoto((String)collectionName, author))));
    }

    private void showTuneInfos(File tuneFile, SidTune tune) {
        String collectionName = IOUtils.getCollectionName((File)this.fileBrowser.getRoot().getValue(), tuneFile);
        HVSCEntry entry = new HVSCEntry(() -> this.util.getPlayer().getSidDatabaseInfo(db -> db.getTuneLength(tune), 0.0), tuneFile.getName(), collectionName, tuneFile.length(), tuneFile.lastModified(), tune, tune.identify().stream().collect(Collectors.joining(",")));
        this.tuneInfos.setAll((Collection)SearchCriteria.getAttributeValues(entry, field -> this.searchCriteria.getConverter().toString(field)).stream().map(info -> new TuneInfo((String)info.getKey(), (String)info.getValue())).collect(Collectors.toList()));
    }

    private void addFavorites(SidPlay2Section sidplay2Section, FavoritesSection section, List<File> files) {
        for (File file : files) {
            File[] listFiles = file.listFiles();
            if (file.isDirectory() && listFiles != null) {
                this.addFavorites(sidplay2Section, section, Arrays.asList(listFiles));
                continue;
            }
            if (!file.isFile() || !this.tuneFilter.accept(file)) continue;
            this.addFavorite(sidplay2Section, section, file);
        }
    }

    private void addFavorite(SidPlay2Section sidPlay2Section, FavoritesSection section, File file) {
        try {
            SidTune tune = SidTune.load(file);
            String collectionName = this.getType() == MusicCollectionType.HVSC ? IOUtils.getCollectionName(sidPlay2Section.getHvsc(), file) : IOUtils.getCollectionName(sidPlay2Section.getCgsc(), file);
            HVSCEntry entry = new HVSCEntry(() -> this.util.getPlayer().getSidDatabaseInfo(db -> db.getTuneLength(tune), 0.0), file.getName(), collectionName, file.length(), file.lastModified(), tune, tune.identify().stream().collect(Collectors.joining(",")));
            section.getFavorites().add(entry);
        }
        catch (IOException | SidTuneError e) {
            this.openErrorDialog(String.format(this.util.getBundle().getString("ERR_IO_ERROR"), e.getMessage()), this.getType());
        }
    }

    private void playSelected() {
        TreeItem selectedItem = (TreeItem)this.fileBrowser.getSelectionModel().getSelectedItem();
        if (selectedItem != null && !selectedItem.equals(this.fileBrowser.getRoot()) && ((File)selectedItem.getValue()).isFile()) {
            this.playTune((File)selectedItem.getValue());
        }
    }

    private void playTune(File file) {
        this.util.setPlayingTab((Node)this, this.currentlyPlayedTreeItemsProperty);
        try {
            this.util.getPlayer().play(SidTune.load(file));
        }
        catch (IOException | SidTuneError e) {
            this.openErrorDialog(String.format(this.util.getBundle().getString("ERR_IO_ERROR"), e.getMessage()), this.getType());
        }
    }
}

