/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.comp.ibm437;

import global.namespace.service.wight.annotation.ServiceImplementation;
import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import javax.annotation.concurrent.Immutable;
import net.java.truevfs.comp.ibm437.Ibm437Charset;

@ServiceImplementation(value={CharsetProvider.class})
@Immutable
public final class Ibm437CharsetProvider
extends CharsetProvider {
    private static final Map<String, Charset> CHARSETS;

    private static String lowerCase(String s) {
        return s.toLowerCase(Locale.ROOT);
    }

    @Override
    public Iterator<Charset> charsets() {
        return CHARSETS.values().iterator();
    }

    @Override
    public Charset charsetForName(String charset) {
        return CHARSETS.get(Ibm437CharsetProvider.lowerCase(charset));
    }

    static {
        HashMap<String, Charset> charsets = new HashMap<String, Charset>();
        for (Charset charset : new Charset[]{new Ibm437Charset()}) {
            charsets.put(Ibm437CharsetProvider.lowerCase(charset.name()), charset);
            for (String alias : charset.aliases()) {
                charsets.put(Ibm437CharsetProvider.lowerCase(alias), charset);
            }
        }
        CHARSETS = Collections.unmodifiableMap(charsets);
    }
}

