/*
 * Decompiled with CFR 0.152.
 */
package kickass.common.diagnostics;

import java.util.ArrayList;
import java.util.List;
import kickass.common.diagnostics.DiagnosticType;
import kickass.common.diagnostics.IDiagnostic;

public class DiagnosticManager {
    private boolean expectDiagnostics = false;
    private List<IDiagnostic> errors = new ArrayList<IDiagnostic>();
    private List<IDiagnostic> expectedErrors;
    private List<IDiagnostic> warnings = new ArrayList<IDiagnostic>();
    private List<IDiagnostic> expectedWarnings;

    public boolean hasErrors() {
        return !this.errors.isEmpty();
    }

    public boolean hasWarnings() {
        return !this.warnings.isEmpty();
    }

    public void add(IDiagnostic iDiagnostic) {
        if (iDiagnostic.getType() == DiagnosticType.error) {
            (this.expectDiagnostics ? this.expectedErrors : this.errors).add(iDiagnostic);
        } else {
            (this.expectDiagnostics ? this.expectedWarnings : this.warnings).add(iDiagnostic);
        }
    }

    public List<IDiagnostic> getErrors() {
        return this.errors;
    }

    public List<IDiagnostic> getExpectedErrors() {
        return this.expectedErrors;
    }

    public List<IDiagnostic> getWarnings() {
        return this.warnings;
    }

    public List<IDiagnostic> getExpectedWarnings() {
        return this.expectedWarnings;
    }

    public void startExpectDiagnosticMode() {
        this.expectedErrors = new ArrayList<IDiagnostic>();
        this.expectedWarnings = new ArrayList<IDiagnostic>();
        this.expectDiagnostics = true;
    }

    public void endExpectDiagnosticMode() {
        this.expectDiagnostics = false;
    }
}

