/*
 * Decompiled with CFR 0.152.
 */
package kickass.parsing.preprocessor.directives;

import kickass.common.diagnostics.AsmError;
import kickass.parsing.baselang.TokenType;
import kickass.parsing.baselang.tokens.IToken;
import kickass.parsing.baselang.tokenstreams.TokenStreamList;
import kickass.parsing.preprocessor.PreProcessor;
import kickass.parsing.preprocessor.directives.IPreProcessorDirective;
import kickass.parsing.preprocessor.directives.PpdUtil;
import kickass.state.EvaluationState;

public class PpdDefine
implements IPreProcessorDirective {
    private PreProcessor preprocessor;

    public PpdDefine(PreProcessor preProcessor) {
        this.preprocessor = preProcessor;
    }

    @Override
    public void executeDirective(IToken iToken, TokenStreamList tokenStreamList) {
        EvaluationState evaluationState = this.preprocessor.getState();
        if (!PpdUtil.ensureNoOfArguments(iToken, 1, tokenStreamList, evaluationState)) {
            return;
        }
        boolean bl = evaluationState.preprocessorMgr.isInPassiveState();
        if (bl) {
            return;
        }
        IToken iToken2 = tokenStreamList.get(0);
        if (iToken2.getType() != TokenType.Id) {
            evaluationState.diagnosticMgr.add(new AsmError("symbolname must be an identifer", iToken2.getSourceRange()));
            return;
        }
        String string = (String)iToken2.getValue();
        evaluationState.preprocessorMgr.getDefinedSymbols().add(string);
    }
}

