/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.Directive;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class ErrorDirective
extends Directive {
    private ExprNode msgExpr;

    public ErrorDirective(ExprNode exprNode, SourceRange sourceRange) {
        super(sourceRange);
        this.msgExpr = exprNode;
        this.range = sourceRange;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.msgExpr.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        Value value = this.msgExpr.evaluate(evaluationState);
        String string = !value.isInvalid() ? value.getString(this.range) : "Invalid error message value! (You might use a yet inresolved label)";
        throw new AsmErrorException(string, this.range);
    }
}

