/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import java.util.List;
import kickass.common.diagnostics.AsmError;
import kickass.common.exceptions.AsmErrorException;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.ILabelConnectorNode;
import kickass.pass.asmnode.ILabelNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.EmptyOutput;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.valueholder.VariableValueHolder;
import kickass.pass.values.LabelValue;
import kickass.pass.values.LohiFillValue;
import kickass.pass.values.NumberValue;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;
import kickass.state.scope.SymbolScope;
import kickass.state.scope.symboltable.ISymbolPageIdx;
import kickass.state.scope.symboltable.SymbolStatus;
import kickass.state.segments.SegmentMemoryBlock;

public class LohiFillDirective
extends AsmDirective
implements ILabelConnectorNode {
    private List<ExprNode> arguments;
    private String labelId;
    private ExprNode sizeExpr;
    private ExprNode valueExpr;
    private SymbolScope innerScope;
    private ISymbolPageIdx iSymbolPageIdx;
    private ISymbolPageIdx labelPageIdx;
    private SegmentMemoryBlock.Entry memEntry;

    public LohiFillDirective(List<ExprNode> list, SourceRange sourceRange) {
        super(sourceRange);
        this.arguments = list;
    }

    private LohiFillDirective(LohiFillDirective lohiFillDirective) {
        super(lohiFillDirective.range);
        this.labelId = lohiFillDirective.labelId;
        this.arguments = lohiFillDirective.arguments;
        this.sizeExpr = lohiFillDirective.sizeExpr;
        this.valueExpr = lohiFillDirective.valueExpr;
        this.innerScope = lohiFillDirective.innerScope;
        this.iSymbolPageIdx = lohiFillDirective.iSymbolPageIdx;
        this.labelPageIdx = lohiFillDirective.labelPageIdx;
    }

    @Override
    public AsmNode copy() {
        return new LohiFillDirective(this);
    }

    @Override
    public boolean connectToLabel(ILabelNode iLabelNode) {
        this.labelId = iLabelNode.getName();
        return true;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        if (this.arguments.size() != 2) {
            evaluationState.diagnosticMgr.add(new AsmError("Invalid number of arguments", this.range));
            return EmptyOutput.instance;
        }
        this.sizeExpr = this.arguments.get(0);
        this.innerScope = new SymbolScope(evaluationState.scopeMgr.getCurrentScope(), null);
        this.iSymbolPageIdx = this.innerScope.define("i", VariableValueHolder.initializer);
        this.valueExpr = this.arguments.get(1);
        if (this.labelId != null) {
            this.labelPageIdx = evaluationState.scopeMgr.resolveSymbol(this.labelId);
            this.labelPageIdx.replaceInitializer(LabelValue.getInitializer(evaluationState, () -> new LohiFillValue()));
        }
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.sizeExpr.executePrepass(evaluationState);
        evaluationState.scopeMgr.setCurrentScope(this.innerScope);
        this.iSymbolPageIdx.setStatus(SymbolStatus.defined);
        this.valueExpr.executePrepass(evaluationState);
        evaluationState.scopeMgr.setCurrentScope(this.innerScope.getParent());
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        int n;
        Object object;
        Value value;
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        if (evaluationState.getPassNo() == 1) {
            this.memEntry = evaluationState.segmentMgr.getCurrentSegment().getCurrentMemoryBlock().createNewEntry();
        }
        if ((value = this.sizeExpr.evaluate(evaluationState)).isInvalid()) {
            throw new AsmErrorException("You must be able to determine the size argument en first pass", this.range);
        }
        int n2 = value.getInt(this.range);
        if (n2 < 0) {
            throw new AsmErrorException("The size of a fill directive can't be negative. Size=" + n2, this.range);
        }
        this.memEntry.setNoOfBytes(2 * n2);
        if (this.labelPageIdx != null) {
            LabelValue labelValue = (LabelValue)this.labelPageIdx.getValueHolder().getWithoutSideeffect();
            object = (LohiFillValue)labelValue.getConnectedValue();
            ((LohiFillValue)object).label = labelValue;
            ((LohiFillValue)object).size = n2;
        }
        boolean bl = false;
        object = this.iSymbolPageIdx.getValueHolder();
        byte[] byArray = new byte[2 * n2];
        for (n = 0; n < n2; ++n) {
            object.setWithoutSideEffect(new NumberValue(n));
            Value value2 = this.valueExpr.evaluate(evaluationState);
            if (value2.isInvalid()) {
                bl = true;
                continue;
            }
            int n3 = value2.getInt(this.range);
            byArray[n] = (byte)(n3 & 0xFF);
            byArray[n + n2] = (byte)(n3 >> 8 & 0xFF);
        }
        evaluationState.segmentMgr.increaseMemoryPosition(n2 * 2);
        if (!bl) {
            this.memEntry.fillEntry(byArray, this.range);
        }
        n = bl || evaluationState.sideeffectMgr.getErrorOrInvalidSideEffectsDuringFunctionEvaluation() ? 1 : 0;
        return n != 0 ? this : SideEffectOnlyOutput.create(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }
}

