/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.expressions.expr;

import kickass.common.exceptions.AsmErrorException;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.expressions.refexpr.IReferenceExpr;
import kickass.pass.expressions.refexpr.ReferenceOperation;
import kickass.pass.values.InvalidUnlockedSideEffectValue;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class DeReference
extends ExprNode {
    private IReferenceExpr referenceExpr;

    public DeReference(IReferenceExpr iReferenceExpr) {
        super(iReferenceExpr.getSourceRange());
        this.referenceExpr = iReferenceExpr;
    }

    @Override
    public void executePrepass(EvaluationState evaluationState) {
        this.referenceExpr.executePrepass(evaluationState, ReferenceOperation.read);
    }

    @Override
    public Value evaluate(EvaluationState evaluationState) {
        Value value = this.referenceExpr.getValueHolder(evaluationState).get(evaluationState, this.range);
        if (value.isInvalid()) {
            evaluationState.sideeffectMgr.setErrorDuringFunctionEvaluation(true);
            if (evaluationState.failOnInvalidValue()) {
                if (value instanceof InvalidUnlockedSideEffectValue) {
                    ((InvalidUnlockedSideEffectValue)value).throwException(this.range);
                }
                throw new AsmErrorException("Value can't be resolved", this.range);
            }
        }
        return value;
    }

    public String toString() {
        return "DeReference";
    }
}

