/*
 * Decompiled with CFR 0.152.
 */
package ui.assembly64;

import javafx.beans.property.ObjectProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.WeakChangeListener;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.Tooltip;
import javafx.util.Callback;
import ui.assembly64.SearchResult;

public class Assembly64RowFactory
implements Callback<TableView<SearchResult>, TableRow<SearchResult>> {
    private static final String CURRENTLY_PLAYED_FILE_ROW = "currentlyPlayedRow";
    private ObjectProperty<SearchResult> currentlyPlayedRowProperty;

    public ObjectProperty<SearchResult> getCurrentlyPlayedRowProperty() {
        return this.currentlyPlayedRowProperty;
    }

    public void setCurrentlyPlayedRowProperty(ObjectProperty<SearchResult> currentlyPlayedRowProperty) {
        this.currentlyPlayedRowProperty = currentlyPlayedRowProperty;
    }

    public TableRow<SearchResult> call(TableView<SearchResult> p) {
        return new MyTableRow();
    }

    private final class MyTableRow
    extends TableRow<SearchResult> {
        private ChangeListener<SearchResult> listener = (observable, oldValue, newValue) -> this.setCellStyle();

        public MyTableRow() {
            Assembly64RowFactory.this.currentlyPlayedRowProperty.addListener((ChangeListener)new WeakChangeListener(this.listener));
        }

        public void updateItem(SearchResult item, boolean empty) {
            super.updateItem((Object)item, empty);
            this.setTooltip(item != null ? new Tooltip(((SearchResult)this.getItem()).getName()) : null);
            this.setCellStyle();
        }

        private void setCellStyle() {
            this.getStyleClass().remove((Object)Assembly64RowFactory.CURRENTLY_PLAYED_FILE_ROW);
            if (!this.isEmpty() && Assembly64RowFactory.this.currentlyPlayedRowProperty.get() != null && ((SearchResult)this.getItem()).getId().equals(((SearchResult)Assembly64RowFactory.this.currentlyPlayedRowProperty.get()).getId())) {
                this.getStyleClass().add((Object)Assembly64RowFactory.CURRENTLY_PLAYED_FILE_ROW);
            }
        }
    }
}

