/*
 * Decompiled with CFR 0.152.
 */
package net.java.truecommons.shed;

import javax.annotation.Nullable;
import javax.annotation.concurrent.NotThreadSafe;
import net.java.truecommons.shed.Paths;

@NotThreadSafe
public class PathSplitter {
    private final char separatorChar;
    private final int fixum;
    @Nullable
    private String parentPath;
    private String memberName;

    public PathSplitter(char separatorChar, boolean keepTrailingSeparator) {
        this.separatorChar = separatorChar;
        this.fixum = keepTrailingSeparator ? 1 : 0;
    }

    public PathSplitter split(String path) {
        int memberEnd;
        int prefixLen = Paths.prefixLength(path, this.separatorChar, false);
        if (prefixLen > (memberEnd = path.length() - 1)) {
            this.parentPath = null;
            this.memberName = "";
            return this;
        }
        memberEnd = PathSplitter.lastIndexNot(path, this.separatorChar, memberEnd);
        int memberInd = path.lastIndexOf(this.separatorChar, memberEnd) + 1;
        if (prefixLen >= ++memberEnd) {
            this.parentPath = null;
            this.memberName = "";
        } else if (prefixLen >= memberInd) {
            this.parentPath = 0 >= prefixLen ? null : path.substring(0, prefixLen);
            this.memberName = path.substring(prefixLen, memberEnd);
        } else {
            int parentEnd = PathSplitter.lastIndexNot(path, this.separatorChar, memberInd - 1) + 1;
            if (prefixLen >= parentEnd) {
                this.parentPath = path.substring(0, prefixLen);
                this.memberName = path.substring(memberInd, memberEnd);
            } else {
                this.parentPath = path.substring(0, parentEnd + this.fixum);
                this.memberName = path.substring(memberInd, memberEnd);
            }
        }
        return this;
    }

    private static int lastIndexNot(String path, char separatorChar, int last) {
        while (separatorChar == path.charAt(last) && --last >= 0) {
        }
        return last;
    }

    @Nullable
    public String getParentPath() {
        return this.parentPath;
    }

    public String getMemberName() {
        return this.memberName;
    }
}

