/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.c1541;

import java.util.Arrays;
import libsidplay.components.c1541.DOSErrorCodes;

public final class GCR {
    public static final int MAX_GCR_TRACKS = 70;
    public static final int NUM_MAX_BYTES_TRACK = 7928;
    public static final int SECTOR_SIZE = 260;
    private static final int GCR_SECTOR_SIZE_DATA_ONLY = 325;
    public static final byte BLOCK_HEADER_START = 8;
    public static final byte DATA_HEADER_START = 7;
    private static final byte[] TO_GCR = new byte[]{10, 11, 18, 19, 14, 15, 22, 23, 9, 25, 26, 27, 13, 29, 30, 21};
    private static final byte[] FROM_GCR = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 8, 0, 1, 0, 12, 4, 5, 0, 0, 2, 3, 0, 15, 6, 7, 0, 9, 10, 11, 0, 13, 14, 0};
    private byte[] data = new byte[554960];
    private int dataPos;
    private int gcrHeadOffset;
    private boolean isDiskAttached = false;

    protected byte[] getTrackData(int trackPos, int trackSize) {
        byte[] trackBytes = new byte[trackSize];
        System.arraycopy(this.data, trackPos, trackBytes, 0, trackSize);
        return trackBytes;
    }

    protected void setTrackData(int trackPos, int trackSize, byte byt) {
        Arrays.fill(this.data, trackPos, trackPos + trackSize, byt);
    }

    protected void setTrackData(byte[] trackBytes, int trackPos, int trackSize) {
        System.arraycopy(trackBytes, 0, this.data, trackPos, trackSize);
    }

    protected void attach() {
        this.isDiskAttached = true;
    }

    protected void detach() {
        Arrays.fill(this.data, (byte)0);
        this.isDiskAttached = false;
    }

    protected void reset() {
        this.dataPos = 0;
        this.gcrHeadOffset = 0;
    }

    protected void convertSectorToGCR(byte[] sectorBytes, int off, int track, int sector, byte diskID1, byte diskID2, DOSErrorCodes errorCode) {
        byte[] buf = new byte[4];
        Arrays.fill(this.data, off, off + 5, (byte)-1);
        off += 5;
        byte headerId1 = (byte)(errorCode == DOSErrorCodes.CBMDOS_IPE_DISK_ID_MISMATCH ? diskID1 ^ 0xFF : diskID1);
        buf[0] = (byte)(errorCode == DOSErrorCodes.CBMDOS_IPE_READ_ERROR_BNF ? 255 : 8);
        buf[1] = (byte)(sector ^ track ^ diskID2 ^ headerId1);
        buf[2] = (byte)sector;
        buf[3] = (byte)track;
        if (errorCode == DOSErrorCodes.CBMDOS_IPE_READ_ERROR_BCHK) {
            buf[1] = (byte)(buf[1] ^ 0xFF);
        }
        this.convert4BytesToGCR(buf, 0, this.data, off);
        buf[0] = diskID2;
        buf[1] = headerId1;
        buf[2] = 15;
        buf[3] = 15;
        this.convert4BytesToGCR(buf, 0, this.data, off += 5);
        off += 5;
        Arrays.fill(this.data, off += 10, off + 5, (byte)-1);
        off += 5;
        sectorBytes[0] = (byte)(errorCode == DOSErrorCodes.CBMDOS_IPE_READ_ERROR_DATA ? 255 : 7);
        int chksum = sectorBytes[1];
        for (int i = 2; i < 257; ++i) {
            chksum ^= sectorBytes[i];
        }
        sectorBytes[257] = (byte)(errorCode == DOSErrorCodes.CBMDOS_IPE_READ_ERROR_CHK ? chksum ^ 0xFF : chksum);
        sectorBytes[259] = 0;
        sectorBytes[258] = 0;
        int sectorBytesPos = 0;
        for (int i = 0; i < 65; ++i) {
            this.convert4BytesToGCR(sectorBytes, sectorBytesPos, this.data, off);
            sectorBytesPos += 4;
            off += 5;
        }
    }

    private void convert4BytesToGCR(byte[] source, int srcPos, byte[] dest, int dstPos) {
        int idx = 0;
        int i = 2;
        while (i < 10) {
            idx <<= 5;
            idx |= TO_GCR[(source[srcPos] & 0xFF) >> 4];
            idx <<= 5;
            dest[dstPos] = (byte)((idx |= TO_GCR[source[srcPos] & 0xF]) >> i);
            i += 2;
            ++srcPos;
            ++dstPos;
        }
        dest[dstPos] = (byte)idx;
    }

    protected void convertGCRToSector(byte[] dest, int dstPos, int trackSize) {
        byte[] header = new byte[5];
        int bufferPos = 0;
        int trackEnd = this.dataPos + trackSize;
        for (int i = 0; i < 65; ++i) {
            for (int j = 0; j < header.length; ++j) {
                header[j] = this.data[dstPos++];
                if (dstPos < trackEnd) continue;
                dstPos = this.dataPos;
            }
            this.convertGCRTo4Bytes(header, dest, bufferPos);
            bufferPos += 4;
        }
    }

    protected int findSectorHeader(int track, int sector, int trackSize) {
        int offset = this.dataPos;
        byte[] headerAsGCR = new byte[5];
        byte[] header = new byte[4];
        boolean wrapOver = false;
        int syncCount = 0;
        int trackEnd = this.dataPos + trackSize;
        while (offset < trackEnd && !wrapOver) {
            while (this.data[offset] != -1) {
                if (++offset < trackEnd) continue;
                return -1;
            }
            while (this.data[offset] == -1) {
                if (++offset == trackEnd) {
                    offset = this.dataPos;
                    wrapOver = true;
                }
                if (++syncCount < trackSize) continue;
                return -1;
            }
            for (int i = 0; i < 5; ++i) {
                headerAsGCR[i] = this.data[offset++];
                if (offset < trackEnd) continue;
                offset = this.dataPos;
                wrapOver = true;
            }
            this.convertGCRTo4Bytes(headerAsGCR, header, 0);
            if (header[0] != 8 || header[2] != sector || header[3] != track) continue;
            return offset;
        }
        return -1;
    }

    protected int findSectorData(int sectorHeaderPos, int trackSize) {
        int trackEnd = this.dataPos + trackSize;
        int header = 0;
        int sectorDataPos = sectorHeaderPos;
        while (this.data[sectorDataPos] != -1) {
            if (++sectorDataPos >= trackEnd) {
                sectorDataPos = this.dataPos;
            }
            if (++header < 500) continue;
            return -1;
        }
        while (this.data[sectorDataPos] == -1) {
            if (++sectorDataPos != trackEnd) continue;
            sectorDataPos = this.dataPos;
        }
        return sectorDataPos;
    }

    private void convertGCRTo4Bytes(byte[] source, byte[] dest, int destPos) {
        int idx = source[0] & 0xFF;
        idx <<= 13;
        int sourcePos = 0;
        int off = destPos;
        for (int i = 5; i < 13; i += 2) {
            dest[off] = (byte)((FROM_GCR[(idx |= (source[++sourcePos] & 0xFF) << i) >> 16 & 0x1F] & 0xFF) << 4);
            int n = off++;
            dest[n] = (byte)(dest[n] | FROM_GCR[(idx <<= 5) >> 16 & 0x1F]);
            idx <<= 5;
        }
    }

    protected int readNextBit(int currentTrackSize) {
        if (!this.isDiskAttached) {
            return 0;
        }
        int byteOffset = this.gcrHeadOffset >> 3;
        int bitNumber = ~this.gcrHeadOffset & 7;
        this.gcrHeadOffset = (this.gcrHeadOffset + 1) % (currentTrackSize << 3);
        byte gcrData = this.data[this.dataPos + byteOffset];
        return gcrData >> bitNumber & 1;
    }

    protected void writeNextBit(boolean value, int currentTrackSize) {
        if (!this.isDiskAttached) {
            return;
        }
        int byteOffset = this.gcrHeadOffset >> 3;
        int bitNumber = ~this.gcrHeadOffset & 7;
        this.gcrHeadOffset = (this.gcrHeadOffset + 1) % (currentTrackSize << 3);
        byte gcrData = this.data[this.dataPos + byteOffset];
        this.data[this.dataPos + byteOffset] = value ? (byte)(gcrData | 1 << bitNumber) : (byte)(gcrData & ~(1 << bitNumber));
    }

    protected void setHalfTrack(int num, int oldTrackSize, int currentTrackSize) {
        this.dataPos = ((num >> 1) - 1) * 7928;
        this.gcrHeadOffset = this.gcrHeadOffset * oldTrackSize / currentTrackSize;
    }
}

