/*
 * Decompiled with CFR 0.152.
 */
package client.teavm.common.audio;

import client.teavm.common.IImportedApi;
import java.io.IOException;
import java.nio.ByteBuffer;
import javax.sound.sampled.LineUnavailableException;
import libsidplay.common.CPUClock;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.common.Mixer;
import libsidplay.common.SIDListener;
import libsidplay.components.mos656x.VIC;
import libsidplay.config.IAudioSection;
import sidplay.audio.AudioConfig;
import sidplay.audio.AudioDriver;
import sidplay.audio.VideoDriver;

public final class AudioDriverTeaVM
implements AudioDriver,
VideoDriver,
SIDListener {
    private static final short REGULAR_DELAY = 8192;
    private final IImportedApi importedApi;
    private final float[] lookupTable;
    private final Mixer mixer;
    private final boolean usb;
    private final int nthFrame;
    private EventScheduler context;
    private ByteBuffer sampleBuffer;
    private int n;
    private int fastForwardVICFrames;
    private long lastSIDWriteTime;

    public AudioDriverTeaVM(IImportedApi importedApi, float[] lookupTable, Mixer mixer, boolean usb, int nthFrame) {
        this.importedApi = importedApi;
        this.lookupTable = lookupTable;
        this.mixer = mixer;
        this.usb = usb;
        this.nthFrame = nthFrame;
    }

    @Override
    public void open(IAudioSection audioSection, String recordingFilename, CPUClock cpuClock, EventScheduler context) throws IOException, LineUnavailableException, InterruptedException {
        this.context = context;
        AudioConfig cfg = new AudioConfig(audioSection);
        this.sampleBuffer = this.importedApi.initSampleBuffer(cfg.getChunkFrames(), cfg.getChannels());
        if (this.usb) {
            context.schedule(Event.of("USB Regular Delay", event -> context.schedule((Event)event, this.eventuallyDelay(), Event.Phase.PHI2)), 0L, Event.Phase.PHI2);
        }
    }

    @Override
    public void write() throws InterruptedException {
        this.importedApi.processSamples(this.sampleBuffer, this.lookupTable);
    }

    @Override
    public void close() {
    }

    @Override
    public ByteBuffer buffer() {
        return this.sampleBuffer;
    }

    @Override
    public boolean isRecording() {
        return false;
    }

    @Override
    public void accept(VIC vic) {
        int fastForwardBitMask = this.mixer.getFastForwardBitMask();
        if ((this.fastForwardVICFrames++ & fastForwardBitMask) == fastForwardBitMask && ++this.n == this.nthFrame) {
            this.n = 0;
            this.importedApi.processPixels(vic.getPalEmulation().getPixels());
        }
    }

    @Override
    public void write(int addr, byte data) {
        long now = this.context.getTime(Event.Phase.PHI2);
        this.importedApi.processSidWrite(now, this.clocksSinceLastAccess(now), addr, data & 0xFF);
    }

    private int clocksSinceLastAccess(long now) {
        int diff = (int)(now - this.lastSIDWriteTime);
        this.lastSIDWriteTime = now;
        return diff >> this.mixer.getFastForwardBitMask();
    }

    private long eventuallyDelay() {
        long now = this.context.getTime(Event.Phase.PHI2);
        int diff = (int)(now - this.lastSIDWriteTime);
        if (diff > 8192) {
            this.lastSIDWriteTime += 8192L;
            this.importedApi.processSidWrite(now, (short)(8192 >> this.mixer.getFastForwardBitMask()), -1, 0);
        }
        return 8192L;
    }
}

