/*
 * Decompiled with CFR 0.152.
 */
package com.hardsid.usb.driver;

import com.hardsid.usb.driver.DevType;
import com.hardsid.usb.driver.SysMode;
import com.hardsid.usb.driver.WState;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.IntBuffer;
import java.util.function.Supplier;
import java.util.logging.Logger;
import org.usb4java.Device;
import org.usb4java.DeviceDescriptor;
import org.usb4java.DeviceHandle;
import org.usb4java.DeviceList;
import org.usb4java.LibUsb;

public class HardSIDUSB {
    private static final Logger LOGGER = Logger.getLogger(HardSIDUSB.class.getName());
    private static final byte USB_INTERFACE = 0;
    private static final long TIMEOUT = 2000L;
    private static final int USB_PACKAGE_SIZE = 512;
    private static final int WRITEBUFF_SIZE = 512;
    private static final int WRITEBUFF_SIZE_SYNC = 2048;
    private static final int MAX_DEVCOUNT = 4;
    private static final int READBUFF_SIZE = 64;
    private static final int HW_BUFFBEG = 8192;
    private static final int HW_BUFFSIZE = 8192;
    private static final int HW_FILLRATIO = 4096;
    private static final short VENDOR_ID = 25985;
    private static final short HS4U_PRODUCT_ID = -31360;
    private static final short HSUP_PRODUCT_ID = -31359;
    private static final short HSUNO_PRODUCT_ID = -31358;
    private DeviceHandle[] devhandles = new DeviceHandle[4];
    private DevType[] deviceTypes = new DevType[4];
    private ByteBuffer[] writeBuffer = new ByteBuffer[4];
    private byte[] lastaccsids = new byte[4];
    private boolean initialized;
    private boolean error;
    private boolean sync;
    private boolean buffChk;
    private int deviceCount;
    private int bufferSize;
    private int pkgCount;
    private int playCursor;
    private int circBuffCursor;
    private short sysMode;
    private long lastRelaySwitch;

    public HardSIDUSB() {
        for (int i = 0; i < this.deviceTypes.length; ++i) {
            this.deviceTypes[i] = DevType.UNKNOWN;
        }
        this.buffChk = true;
        this.bufferSize = 512;
        this.playCursor = 8192;
        this.circBuffCursor = 8192;
    }

    public boolean hardsid_usb_init(boolean syncmode, SysMode sysmode) {
        if (sysmode != SysMode.SIDPLAY) {
            throw new RuntimeException("Only SIDPLAY mode currently supported!");
        }
        if (!syncmode) {
            throw new RuntimeException("Only synchronous mode currently supported!");
        }
        boolean fnd = false;
        this.sync = syncmode;
        this.bufferSize = this.sync ? 2048 : 512;
        if (this.initialized) {
            this.hardsid_usb_close();
        }
        this.initialized = true;
        this.error = false;
        this.deviceCount = 0;
        this.addAllDevices();
        if (!this.error && this.deviceCount > 0) {
            this.sync = true;
            this.hardsid_usb_setmode(0, sysmode);
            this.sync = syncmode;
        }
        return fnd;
    }

    public void hardsid_usb_close() {
        try {
            if (this.initialized) {
                for (int d = 0; d < this.deviceCount; ++d) {
                    DeviceHandle deviceHandle = this.devhandles[d];
                    if (this.deviceTypes[d] == DevType.HSUP || this.deviceTypes[d] == DevType.HSUNO) {
                        while (this.hardsid_usb_delay(d, 5000) == WState.BUSY) {
                            Thread.sleep(0L);
                        }
                        while (this.hardsid_usb_write_direct(d, (byte)-16, (byte)6) == WState.BUSY) {
                            Thread.sleep(0L);
                        }
                        while (this.hardsid_usb_delay(d, 60000) == WState.BUSY) {
                            Thread.sleep(0L);
                        }
                        while (this.hardsid_usb_write_direct(d, (byte)-16, (byte)7) == WState.BUSY) {
                            Thread.sleep(0L);
                        }
                        while (this.hardsid_usb_flush(d) == WState.BUSY) {
                            Thread.sleep(0L);
                        }
                        this.lastaccsids[d] = -1;
                    }
                    this.checkforError(() -> LibUsb.releaseInterface(deviceHandle, 0) == 0, "USB Release interface");
                    LibUsb.close(this.devhandles[d]);
                }
                this.initialized = false;
            }
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.error = true;
        }
    }

    public int hardsid_usb_getdevcount() {
        if (!this.initialized || this.error) {
            return 0;
        }
        return this.deviceCount;
    }

    public int hardsid_usb_getsidcount(int deviceId) {
        if (!this.initialized || this.error) {
            return 0;
        }
        switch (this.deviceTypes[deviceId]) {
            case HS4U: {
                return 4;
            }
            case HSUP: {
                return 2;
            }
            case HSUNO: {
                return 1;
            }
        }
        return 0;
    }

    private boolean addAllDevices() {
        this.openAllDevices();
        if (this.deviceCount == 0) {
            LOGGER.info("No devices");
            this.error = true;
            return false;
        }
        return true;
    }

    private void openAllDevices() {
        if (this.checkforError(() -> LibUsb.init(null) == 0, "USB Init")) {
            return;
        }
        DeviceList devices = new DeviceList();
        if (this.checkforError(() -> LibUsb.getDeviceList(null, devices) != 0, "USB Get device list")) {
            return;
        }
        for (Device device : devices) {
            DeviceDescriptor descriptor;
            if (this.checkforError(() -> HardSIDUSB.lambda$openAllDevices$3(device, descriptor = new DeviceDescriptor()), "USB Get device descriptor")) {
                return;
            }
            DevType devType = this.getDevType(descriptor);
            if (devType == DevType.UNKNOWN) continue;
            DeviceHandle handle = new DeviceHandle();
            if (this.checkforError(() -> LibUsb.open(device, handle) == 0, "USB Open")) {
                return;
            }
            if (this.checkforError(() -> LibUsb.claimInterface(handle, 0) == 0, "USB Claim interface")) {
                return;
            }
            IntBuffer config = IntBuffer.allocate(1);
            if (this.checkforError(() -> LibUsb.getConfiguration(handle, config) == 0, "USB Get configuration")) {
                return;
            }
            if (config.get() == 0 && this.checkforError(() -> LibUsb.setConfiguration(handle, 1) == 0, "USB Set configuration")) {
                return;
            }
            if (LibUsb.hasCapability(257) && this.checkforError(() -> LibUsb.kernelDriverActive(handle, 0) == 0, "USB Kernel driver active") && this.checkforError(() -> LibUsb.detachKernelDriver(handle, 0) == 0, "USB Detach kernel driver")) {
                return;
            }
            this.devhandles[this.deviceCount] = handle;
            this.deviceTypes[this.deviceCount] = devType;
            this.lastaccsids[this.deviceCount] = -1;
            this.writeBuffer[this.deviceCount] = ByteBuffer.allocate(this.bufferSize).order(ByteOrder.LITTLE_ENDIAN);
            ++this.deviceCount;
            break;
        }
        LibUsb.freeDeviceList(devices, true);
    }

    private boolean checkforError(Supplier<Boolean> rcCheck, String info) {
        if (rcCheck.get().booleanValue()) {
            LOGGER.info(info + " OK");
        } else {
            LOGGER.severe(info + " FAILED");
            this.error = true;
        }
        return this.error;
    }

    private DevType getDevType(DeviceDescriptor descriptor) {
        if (descriptor.idVendor() == 25985) {
            switch (descriptor.idProduct()) {
                default: {
                    return DevType.HS4U;
                }
                case -31358: {
                    return DevType.HSUNO;
                }
                case -31359: 
            }
            return DevType.HSUP;
        }
        return DevType.UNKNOWN;
    }

    private WState hardsid_usb_readstate(int deviceId) {
        IntBuffer transfered;
        if (!this.initialized || this.error || !this.sync) {
            return WState.ERROR;
        }
        ByteBuffer buffer = ByteBuffer.allocateDirect(64).order(ByteOrder.LITTLE_ENDIAN);
        int result = LibUsb.bulkTransfer(this.devhandles[deviceId], (byte)-127, buffer, transfered = IntBuffer.allocate(1), 2000L);
        if (result != 0 || transfered.get() != 64) {
            this.error = true;
            return WState.ERROR;
        }
        this.pkgCount = buffer.getShort(24) & 0xFFFF;
        this.playCursor = buffer.getShort(26) & 0xFFFF;
        this.circBuffCursor = buffer.getShort(28) & 0xFFFF;
        this.sysMode = buffer.getShort(30);
        return WState.OK;
    }

    private WState hardsid_usb_sync(int deviceId) {
        if (!this.initialized || this.error || !this.sync) {
            return WState.ERROR;
        }
        if (this.hardsid_usb_readstate(deviceId) != WState.OK) {
            this.error = true;
            return WState.ERROR;
        }
        int freespace = this.playCursor < this.circBuffCursor ? this.playCursor + 8192 - this.circBuffCursor : (this.playCursor > this.circBuffCursor ? this.playCursor - this.circBuffCursor : 8192);
        if (freespace < 4096) {
            return WState.BUSY;
        }
        return WState.OK;
    }

    private WState hardsid_usb_write_internal(int deviceId) {
        if (!this.initialized || this.error || this.writeBuffer[deviceId].position() == 0) {
            return WState.ERROR;
        }
        int pkgstowrite = (this.writeBuffer[deviceId].position() - 1) / 512 + 1;
        int writesize = pkgstowrite * 512;
        ((Buffer)this.writeBuffer[deviceId]).clear();
        if (this.sync) {
            ByteBuffer buffer = ByteBuffer.allocateDirect(writesize).order(ByteOrder.LITTLE_ENDIAN);
            buffer.put(this.writeBuffer[deviceId].array(), 0, writesize);
            IntBuffer transfered = IntBuffer.allocate(1);
            int result = LibUsb.bulkTransfer(this.devhandles[deviceId], (byte)2, buffer, transfered, 2000L);
            if (result != 0 || transfered.get() != writesize) {
                throw new RuntimeException("Sent error!");
            }
        }
        return WState.OK;
    }

    private WState hardsid_usb_write_direct(int deviceId, byte reg, byte data) {
        WState ws;
        if (!this.initialized || this.error) {
            return WState.ERROR;
        }
        if (this.sync && this.writeBuffer[deviceId].position() == this.bufferSize - 2 && (ws = this.hardsid_usb_sync(deviceId)) != WState.OK) {
            return ws;
        }
        this.writeBuffer[deviceId].putShort((short)((reg & 0xFF) << 8 | data & 0xFF));
        if (this.writeBuffer[deviceId].position() == this.bufferSize) {
            return this.hardsid_usb_write_internal(deviceId);
        }
        return WState.OK;
    }

    public WState hardsid_usb_write(int deviceId, byte reg, byte data) {
        try {
            switch (this.deviceTypes[deviceId]) {
                case HS4U: {
                    return this.hardsid_usb_write_direct(deviceId, reg, data);
                }
                case HSUP: {
                    if ((reg & 0xC0) != 0) {
                        return WState.ERROR;
                    }
                    if (this.lastaccsids[deviceId] != (reg & 0x20)) {
                        this.lastaccsids[deviceId] = (byte)(reg & 0x20);
                        byte newsidmask = (reg & 0x20) != 0 ? (byte)-64 : -96;
                        while (this.lastRelaySwitch > 0L && System.currentTimeMillis() - this.lastRelaySwitch < 250L) {
                            Thread.sleep(0L);
                        }
                        this.lastRelaySwitch = System.currentTimeMillis();
                        while (this.hardsid_usb_delay(deviceId, 4) == WState.BUSY) {
                            Thread.sleep(0L);
                        }
                        while (this.hardsid_usb_write_direct(deviceId, (byte)-16, (byte)6) == WState.BUSY) {
                            Thread.sleep(0L);
                        }
                        while (this.hardsid_usb_delay(deviceId, 60000) == WState.BUSY) {
                            Thread.sleep(0L);
                        }
                        while (this.hardsid_usb_write_direct(deviceId, (byte)-16, (byte)7) == WState.BUSY) {
                            Thread.sleep(0L);
                        }
                        while (this.hardsid_usb_delay(deviceId, 30000) == WState.BUSY) {
                            Thread.sleep(0L);
                        }
                        while (this.hardsid_usb_write_direct(deviceId, newsidmask, (byte)0) == WState.BUSY) {
                            Thread.sleep(0L);
                        }
                        while (this.hardsid_usb_delay(deviceId, 30000) == WState.BUSY) {
                            Thread.sleep(0L);
                        }
                        while (this.hardsid_usb_write_direct(deviceId, (byte)-128, (byte)0) == WState.BUSY) {
                            Thread.sleep(0L);
                        }
                        while (this.hardsid_usb_delay(deviceId, 30000) == WState.BUSY) {
                            Thread.sleep(0L);
                        }
                        while (this.hardsid_usb_write_direct(deviceId, (byte)-16, (byte)4) == WState.BUSY) {
                            Thread.sleep(0L);
                        }
                        while (this.hardsid_usb_delay(deviceId, 60000) == WState.BUSY) {
                            Thread.sleep(0L);
                        }
                        while (this.hardsid_usb_write_direct(deviceId, (byte)-16, (byte)2) == WState.BUSY) {
                            Thread.sleep(0L);
                        }
                        while (this.hardsid_usb_delay(deviceId, 10) == WState.BUSY) {
                            Thread.sleep(0L);
                        }
                        while (this.hardsid_usb_flush(deviceId) == WState.BUSY) {
                            Thread.sleep(0L);
                        }
                        return this.hardsid_usb_write_direct(deviceId, (byte)(reg & 0x1F | 0x80), data);
                    }
                    return this.hardsid_usb_write_direct(deviceId, (byte)(reg & 0x1F | 0x80), data);
                }
                case HSUNO: {
                    if (this.lastaccsids[deviceId] == 255) {
                        this.lastaccsids[deviceId] = 1;
                        while (this.hardsid_usb_delay(deviceId, 4) == WState.BUSY) {
                            Thread.sleep(0L);
                        }
                        while (this.hardsid_usb_delay(deviceId, 5000) == WState.BUSY) {
                            Thread.sleep(0L);
                        }
                        while (this.hardsid_usb_write_direct(deviceId, (byte)-16, (byte)4) == WState.BUSY) {
                            Thread.sleep(0L);
                        }
                        while (this.hardsid_usb_delay(deviceId, 60000) == WState.BUSY) {
                            Thread.sleep(0L);
                        }
                        while (this.hardsid_usb_write_direct(deviceId, (byte)-16, (byte)2) == WState.BUSY) {
                            Thread.sleep(0L);
                        }
                        while (this.hardsid_usb_delay(deviceId, 10) == WState.BUSY) {
                            Thread.sleep(0L);
                        }
                        while (this.hardsid_usb_flush(deviceId) == WState.BUSY) {
                            Thread.sleep(0L);
                        }
                        return this.hardsid_usb_write_direct(deviceId, (byte)(reg & 0x1F | 0x80), data);
                    }
                    return this.hardsid_usb_write_direct(deviceId, (byte)(reg & 0x1F | 0x80), data);
                }
            }
            return WState.ERROR;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            this.error = true;
            return WState.ERROR;
        }
    }

    public WState hardsid_usb_delay(int deviceId, int cycles) {
        if (!this.initialized || this.error) {
            return WState.ERROR;
        }
        if (cycles != 0) {
            WState ws;
            if (cycles < 256) {
                return this.hardsid_usb_write_direct(deviceId, (byte)-18, (byte)(cycles & 0xFF));
            }
            if ((cycles & 0xFF) == 0) {
                return this.hardsid_usb_write_direct(deviceId, (byte)-17, (byte)(cycles >> 8));
            }
            if (this.sync && this.writeBuffer[deviceId].position() == this.bufferSize - 2) {
                WState ws2 = this.hardsid_usb_write_direct(deviceId, (byte)-1, (byte)-1);
                if (ws2 != WState.OK) {
                    return ws2;
                }
            } else if (this.sync && this.writeBuffer[deviceId].position() == this.bufferSize - 4 && (ws = this.hardsid_usb_sync(deviceId)) != WState.OK) {
                return ws;
            }
            this.hardsid_usb_write_direct(deviceId, (byte)-17, (byte)(cycles >> 8));
            this.hardsid_usb_write_direct(deviceId, (byte)-18, (byte)(cycles & 0xFF));
        }
        return WState.OK;
    }

    public WState hardsid_usb_flush(int deviceId) {
        if (!this.initialized || this.error) {
            return WState.ERROR;
        }
        if (this.writeBuffer[deviceId].position() > 0) {
            WState ws;
            if (this.sync && this.buffChk && (ws = this.hardsid_usb_sync(deviceId)) != WState.OK) {
                return ws;
            }
            if (this.writeBuffer[deviceId].position() % this.bufferSize > 0) {
                this.writeBuffer[deviceId].putShort((short)-1);
            }
            this.hardsid_usb_write_internal(deviceId);
        }
        return WState.OK;
    }

    public void hardsid_usb_abortplay(int deviceId) {
        ((Buffer)this.writeBuffer[deviceId]).clear();
        if (this.hardsid_usb_readstate(deviceId) != WState.OK) {
            this.error = true;
            return;
        }
        if (this.pkgCount == 0) {
            return;
        }
        this.hardsid_usb_write_direct(deviceId, (byte)-1, (byte)-1);
        this.hardsid_usb_write_direct(deviceId, (byte)-1, (byte)-1);
        this.hardsid_usb_write_internal(deviceId);
        do {
            if (this.hardsid_usb_readstate(deviceId) == WState.OK) continue;
            this.error = true;
            break;
        } while (this.pkgCount != 0);
    }

    public WState hardsid_usb_setmode(int deviceId, SysMode newsysmode) {
        if (newsysmode != SysMode.SIDPLAY) {
            throw new RuntimeException("Only SIDPLAY mode currently supported!");
        }
        if (newsysmode == SysMode.VST) {
            this.error = true;
            return WState.ERROR;
        }
        if (this.hardsid_usb_readstate(deviceId) != WState.OK) {
            this.error = true;
            return WState.ERROR;
        }
        if ((this.sysMode & 0xF) == newsysmode.getSysMode()) {
            return WState.OK;
        }
        this.hardsid_usb_abortplay(deviceId);
        this.hardsid_usb_write_direct(deviceId, (byte)-1, (byte)-1);
        this.hardsid_usb_write_direct(deviceId, (byte)0, (byte)newsysmode.getSysMode());
        this.hardsid_usb_write_internal(deviceId);
        do {
            if (this.hardsid_usb_readstate(deviceId) == WState.OK) continue;
            this.error = true;
            break;
        } while (this.sysMode != (newsysmode.getSysMode() | 0x80));
        if (this.error) {
            return WState.ERROR;
        }
        return WState.OK;
    }

    private static /* synthetic */ Boolean lambda$openAllDevices$3(Device device, DeviceDescriptor descriptor) {
        return LibUsb.getDeviceDescriptor(device, descriptor) == 0;
    }
}

