/*
 * Decompiled with CFR 0.152.
 */
package kickass.pass.asmnode.directives;

import kickass.common.exceptions.AsmErrorException;
import kickass.nonasm.c64.CharToPetsciiConverter;
import kickass.parsing.sourcelocation.SourceRange;
import kickass.pass.asmnode.AsmNode;
import kickass.pass.asmnode.directives.AsmDirective;
import kickass.pass.asmnode.output.SideEffectOnlyOutput;
import kickass.pass.expressions.expr.ExprNode;
import kickass.pass.sideeffect.SESetEncoding;
import kickass.pass.values.Value;
import kickass.state.EvaluationState;

public class EncodingDirective
extends AsmDirective {
    private ExprNode argExpr;

    public EncodingDirective(ExprNode exprNode, SourceRange sourceRange) {
        super(sourceRange);
        this.argExpr = exprNode;
    }

    @Override
    public AsmNode copy() {
        return this;
    }

    @Override
    public AsmNode executeMetaRegistrations(EvaluationState evaluationState) {
        return this;
    }

    @Override
    public AsmNode executePrepass(EvaluationState evaluationState) {
        this.argExpr.executePrepass(evaluationState);
        return this;
    }

    @Override
    public AsmNode executePass(EvaluationState evaluationState) {
        evaluationState.sideeffectMgr.clearFunctionSideOutput();
        Value value = this.argExpr.evaluate(evaluationState);
        if (value.isInvalid()) {
            throw new AsmErrorException("Can't evaluate the encoding value in first parse", this.range);
        }
        String string = value.getString(this.range);
        boolean bl = CharToPetsciiConverter.setCurrentEncoding(string);
        if (!bl) {
            throw new AsmErrorException("Invalid encoding: " + string, this.range);
        }
        if (evaluationState.sideeffectMgr.getErrorOrInvalidSideEffectsDuringFunctionEvaluation()) {
            return this;
        }
        evaluationState.sideeffectMgr.addSideEffect(new SESetEncoding(string));
        return new SideEffectOnlyOutput(evaluationState.sideeffectMgr.getFunctionSideOutput());
    }
}

