/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec;

import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.java.truecommons.shed.Filter;
import net.java.truecommons.shed.Visitor;
import net.java.truevfs.kernel.spec.FsAbstractManager;
import net.java.truevfs.kernel.spec.FsArchiveDriver;
import net.java.truevfs.kernel.spec.FsArchiveEntry;
import net.java.truevfs.kernel.spec.FsCompositeDriver;
import net.java.truevfs.kernel.spec.FsController;
import net.java.truevfs.kernel.spec.FsDriver;
import net.java.truevfs.kernel.spec.FsManager;
import net.java.truevfs.kernel.spec.FsModel;
import net.java.truevfs.kernel.spec.FsMountPoint;

@ThreadSafe
public abstract class FsDecoratingManager
extends FsAbstractManager {
    protected final FsManager manager;

    protected FsDecoratingManager(FsManager manager) {
        this.manager = Objects.requireNonNull(manager);
    }

    @Override
    public FsModel newModel(FsDriver context, FsMountPoint mountPoint, FsModel parent) {
        assert (null != parent ? parent.getMountPoint().equals(mountPoint.getParent()) : null == mountPoint.getParent());
        return this.manager.newModel(context, mountPoint, parent);
    }

    @Override
    public FsController newController(FsArchiveDriver<? extends FsArchiveEntry> context, FsModel model, @Nullable FsController parent) {
        assert (null != parent ? parent.getModel().equals(model.getParent()) : null == model.getParent());
        return this.manager.newController(context, model, parent);
    }

    @Override
    public FsController controller(FsCompositeDriver driver, FsMountPoint mountPoint) {
        return this.manager.controller(driver, mountPoint);
    }

    @Override
    public <X extends Exception, V extends Visitor<? super FsController, X>> V accept(Filter<? super FsController> filter, V visitor) throws X {
        return this.manager.accept(filter, visitor);
    }

    public String toString() {
        return String.format("%s@%x[manager=%s]", this.getClass().getName(), this.hashCode(), this.manager);
    }
}

