/*
 * Decompiled with CFR 0.152.
 */
package com.sun.javafx.collections;

import com.sun.javafx.binding.ExpressionHelperBase;
import java.util.Arrays;
import javafx.beans.InvalidationListener;
import javafx.collections.ArrayChangeListener;
import javafx.collections.ObservableArray;

public abstract class ArrayListenerHelper<T extends ObservableArray<T>>
extends ExpressionHelperBase {
    protected final T observable;

    public static <T extends ObservableArray<T>> ArrayListenerHelper<T> addListener(ArrayListenerHelper<T> arrayListenerHelper, T t, InvalidationListener invalidationListener) {
        if (invalidationListener == null) {
            throw new NullPointerException();
        }
        return arrayListenerHelper == null ? new SingleInvalidation<T>(t, invalidationListener) : arrayListenerHelper.addListener(invalidationListener);
    }

    public static <T extends ObservableArray<T>> ArrayListenerHelper<T> removeListener(ArrayListenerHelper<T> arrayListenerHelper, InvalidationListener invalidationListener) {
        if (invalidationListener == null) {
            throw new NullPointerException();
        }
        return arrayListenerHelper == null ? null : arrayListenerHelper.removeListener(invalidationListener);
    }

    public static <T extends ObservableArray<T>> ArrayListenerHelper<T> addListener(ArrayListenerHelper<T> arrayListenerHelper, T t, ArrayChangeListener<T> arrayChangeListener) {
        if (arrayChangeListener == null) {
            throw new NullPointerException();
        }
        return arrayListenerHelper == null ? new SingleChange<T>(t, arrayChangeListener) : arrayListenerHelper.addListener(arrayChangeListener);
    }

    public static <T extends ObservableArray<T>> ArrayListenerHelper<T> removeListener(ArrayListenerHelper<T> arrayListenerHelper, ArrayChangeListener<T> arrayChangeListener) {
        if (arrayChangeListener == null) {
            throw new NullPointerException();
        }
        return arrayListenerHelper == null ? null : arrayListenerHelper.removeListener(arrayChangeListener);
    }

    public static <T extends ObservableArray<T>> void fireValueChangedEvent(ArrayListenerHelper<T> arrayListenerHelper, boolean bl, int n, int n2) {
        if (arrayListenerHelper != null && (n < n2 || bl)) {
            arrayListenerHelper.fireValueChangedEvent(bl, n, n2);
        }
    }

    public static <T extends ObservableArray<T>> boolean hasListeners(ArrayListenerHelper<T> arrayListenerHelper) {
        return arrayListenerHelper != null;
    }

    public ArrayListenerHelper(T t) {
        this.observable = t;
    }

    protected abstract ArrayListenerHelper<T> addListener(InvalidationListener var1);

    protected abstract ArrayListenerHelper<T> removeListener(InvalidationListener var1);

    protected abstract ArrayListenerHelper<T> addListener(ArrayChangeListener<T> var1);

    protected abstract ArrayListenerHelper<T> removeListener(ArrayChangeListener<T> var1);

    protected abstract void fireValueChangedEvent(boolean var1, int var2, int var3);

    private static class SingleInvalidation<T extends ObservableArray<T>>
    extends ArrayListenerHelper<T> {
        private final InvalidationListener listener;

        private SingleInvalidation(T t, InvalidationListener invalidationListener) {
            super(t);
            this.listener = invalidationListener;
        }

        @Override
        protected ArrayListenerHelper<T> addListener(InvalidationListener invalidationListener) {
            return new Generic<ObservableArray>(this.observable, this.listener, invalidationListener);
        }

        @Override
        protected ArrayListenerHelper<T> removeListener(InvalidationListener invalidationListener) {
            return invalidationListener.equals(this.listener) ? null : this;
        }

        @Override
        protected ArrayListenerHelper<T> addListener(ArrayChangeListener<T> arrayChangeListener) {
            return new Generic<ObservableArray>(this.observable, this.listener, arrayChangeListener);
        }

        @Override
        protected ArrayListenerHelper<T> removeListener(ArrayChangeListener<T> arrayChangeListener) {
            return this;
        }

        @Override
        protected void fireValueChangedEvent(boolean bl, int n, int n2) {
            try {
                this.listener.invalidated(this.observable);
            }
            catch (Exception exception) {
                Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), exception);
            }
        }
    }

    private static class SingleChange<T extends ObservableArray<T>>
    extends ArrayListenerHelper<T> {
        private final ArrayChangeListener<T> listener;

        private SingleChange(T t, ArrayChangeListener<T> arrayChangeListener) {
            super(t);
            this.listener = arrayChangeListener;
        }

        @Override
        protected ArrayListenerHelper<T> addListener(InvalidationListener invalidationListener) {
            return new Generic<ObservableArray>(this.observable, invalidationListener, this.listener);
        }

        @Override
        protected ArrayListenerHelper<T> removeListener(InvalidationListener invalidationListener) {
            return this;
        }

        @Override
        protected ArrayListenerHelper<T> addListener(ArrayChangeListener<T> arrayChangeListener) {
            return new Generic<ObservableArray>(this.observable, this.listener, arrayChangeListener);
        }

        @Override
        protected ArrayListenerHelper<T> removeListener(ArrayChangeListener<T> arrayChangeListener) {
            return arrayChangeListener.equals(this.listener) ? null : this;
        }

        @Override
        protected void fireValueChangedEvent(boolean bl, int n, int n2) {
            try {
                this.listener.onChanged(this.observable, bl, n, n2);
            }
            catch (Exception exception) {
                Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), exception);
            }
        }
    }

    private static class Generic<T extends ObservableArray<T>>
    extends ArrayListenerHelper<T> {
        private InvalidationListener[] invalidationListeners;
        private ArrayChangeListener<T>[] changeListeners;
        private int invalidationSize;
        private int changeSize;
        private boolean locked;

        private Generic(T t, InvalidationListener invalidationListener, InvalidationListener invalidationListener2) {
            super(t);
            this.invalidationListeners = new InvalidationListener[]{invalidationListener, invalidationListener2};
            this.invalidationSize = 2;
        }

        private Generic(T t, ArrayChangeListener<T> arrayChangeListener, ArrayChangeListener<T> arrayChangeListener2) {
            super(t);
            this.changeListeners = new ArrayChangeListener[]{arrayChangeListener, arrayChangeListener2};
            this.changeSize = 2;
        }

        private Generic(T t, InvalidationListener invalidationListener, ArrayChangeListener<T> arrayChangeListener) {
            super(t);
            this.invalidationListeners = new InvalidationListener[]{invalidationListener};
            this.invalidationSize = 1;
            this.changeListeners = new ArrayChangeListener[]{arrayChangeListener};
            this.changeSize = 1;
        }

        @Override
        protected Generic<T> addListener(InvalidationListener invalidationListener) {
            if (this.invalidationListeners == null) {
                this.invalidationListeners = new InvalidationListener[]{invalidationListener};
                this.invalidationSize = 1;
            } else {
                int n = this.invalidationListeners.length;
                if (this.locked) {
                    int n2 = this.invalidationSize < n ? n : n * 3 / 2 + 1;
                    this.invalidationListeners = Arrays.copyOf(this.invalidationListeners, n2);
                } else if (this.invalidationSize == n) {
                    this.invalidationSize = Generic.trim(this.invalidationSize, this.invalidationListeners);
                    if (this.invalidationSize == n) {
                        int n3 = n * 3 / 2 + 1;
                        this.invalidationListeners = Arrays.copyOf(this.invalidationListeners, n3);
                    }
                }
                this.invalidationListeners[this.invalidationSize++] = invalidationListener;
            }
            return this;
        }

        @Override
        protected ArrayListenerHelper<T> removeListener(InvalidationListener invalidationListener) {
            if (this.invalidationListeners != null) {
                for (int i = 0; i < this.invalidationSize; ++i) {
                    if (!invalidationListener.equals(this.invalidationListeners[i])) continue;
                    if (this.invalidationSize == 1) {
                        if (this.changeSize == 1) {
                            return new SingleChange<ObservableArray>(this.observable, this.changeListeners[0]);
                        }
                        this.invalidationListeners = null;
                        this.invalidationSize = 0;
                        break;
                    }
                    if (this.invalidationSize == 2 && this.changeSize == 0) {
                        return new SingleInvalidation<ObservableArray>(this.observable, this.invalidationListeners[1 - i]);
                    }
                    int n = this.invalidationSize - i - 1;
                    InvalidationListener[] invalidationListenerArray = this.invalidationListeners;
                    if (this.locked) {
                        this.invalidationListeners = new InvalidationListener[this.invalidationListeners.length];
                        System.arraycopy(invalidationListenerArray, 0, this.invalidationListeners, 0, i + 1);
                    }
                    if (n > 0) {
                        System.arraycopy(invalidationListenerArray, i + 1, this.invalidationListeners, i, n);
                    }
                    --this.invalidationSize;
                    if (this.locked) break;
                    this.invalidationListeners[this.invalidationSize] = null;
                    break;
                }
            }
            return this;
        }

        @Override
        protected ArrayListenerHelper<T> addListener(ArrayChangeListener<T> arrayChangeListener) {
            if (this.changeListeners == null) {
                this.changeListeners = new ArrayChangeListener[]{arrayChangeListener};
                this.changeSize = 1;
            } else {
                int n = this.changeListeners.length;
                if (this.locked) {
                    int n2 = this.changeSize < n ? n : n * 3 / 2 + 1;
                    this.changeListeners = Arrays.copyOf(this.changeListeners, n2);
                } else if (this.changeSize == n) {
                    this.changeSize = Generic.trim(this.changeSize, this.changeListeners);
                    if (this.changeSize == n) {
                        int n3 = n * 3 / 2 + 1;
                        this.changeListeners = Arrays.copyOf(this.changeListeners, n3);
                    }
                }
                this.changeListeners[this.changeSize++] = arrayChangeListener;
            }
            return this;
        }

        @Override
        protected ArrayListenerHelper<T> removeListener(ArrayChangeListener<T> arrayChangeListener) {
            if (this.changeListeners != null) {
                for (int i = 0; i < this.changeSize; ++i) {
                    if (!arrayChangeListener.equals(this.changeListeners[i])) continue;
                    if (this.changeSize == 1) {
                        if (this.invalidationSize == 1) {
                            return new SingleInvalidation<ObservableArray>(this.observable, this.invalidationListeners[0]);
                        }
                        this.changeListeners = null;
                        this.changeSize = 0;
                        break;
                    }
                    if (this.changeSize == 2 && this.invalidationSize == 0) {
                        return new SingleChange<ObservableArray>(this.observable, this.changeListeners[1 - i]);
                    }
                    int n = this.changeSize - i - 1;
                    ArrayChangeListener<T>[] arrayChangeListenerArray = this.changeListeners;
                    if (this.locked) {
                        this.changeListeners = new ArrayChangeListener[this.changeListeners.length];
                        System.arraycopy(arrayChangeListenerArray, 0, this.changeListeners, 0, i + 1);
                    }
                    if (n > 0) {
                        System.arraycopy(arrayChangeListenerArray, i + 1, this.changeListeners, i, n);
                    }
                    --this.changeSize;
                    if (this.locked) break;
                    this.changeListeners[this.changeSize] = null;
                    break;
                }
            }
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void fireValueChangedEvent(boolean bl, int n, int n2) {
            InvalidationListener[] invalidationListenerArray = this.invalidationListeners;
            int n3 = this.invalidationSize;
            ArrayChangeListener<T>[] arrayChangeListenerArray = this.changeListeners;
            int n4 = this.changeSize;
            try {
                int n5;
                this.locked = true;
                for (n5 = 0; n5 < n3; ++n5) {
                    try {
                        invalidationListenerArray[n5].invalidated(this.observable);
                        continue;
                    }
                    catch (Exception exception) {
                        Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), exception);
                    }
                }
                for (n5 = 0; n5 < n4; ++n5) {
                    try {
                        arrayChangeListenerArray[n5].onChanged(this.observable, bl, n, n2);
                        continue;
                    }
                    catch (Exception exception) {
                        Thread.currentThread().getUncaughtExceptionHandler().uncaughtException(Thread.currentThread(), exception);
                    }
                }
            }
            finally {
                this.locked = false;
            }
        }
    }
}

