/*
 * Decompiled with CFR 0.152.
 */
package sidplay.audio;

import com.xuggle.xuggler.ICodec;
import com.xuggle.xuggler.IStreamCoder;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import libsidplay.common.SamplingRate;
import libsidplay.config.IAudioSection;
import sidplay.audio.xuggle.XuggleAudioDriver;

public abstract class MP3Driver
extends XuggleAudioDriver {
    private static final int KBPS = 1000;
    private static final int DEFAULT_BITRATE = 128000;
    private static final int FF_QP2LAMBDA = 118;

    @Override
    protected void configureStreamCoder(IStreamCoder streamCoder, IAudioSection audioSection) {
        int bitRate = audioSection.getCbr() == -1 ? 128000 : audioSection.getCbr() * 1000;
        boolean isVbr = audioSection.isVbr();
        int vbrQuality = audioSection.getVbrQuality() * 118;
        streamCoder.setFlag(IStreamCoder.Flags.FLAG_QSCALE, isVbr);
        streamCoder.setBitRate(bitRate);
        streamCoder.setGlobalQuality(vbrQuality);
    }

    @Override
    protected List<SamplingRate> getSupportedSamplingRates() {
        return Arrays.asList(SamplingRate.LOW, SamplingRate.MEDIUM);
    }

    @Override
    protected SamplingRate getDefaultSamplingRate() {
        return SamplingRate.LOW;
    }

    @Override
    protected ICodec.ID getAudioCodec() {
        return ICodec.ID.CODEC_ID_MP3;
    }

    @Override
    protected String getOutputFormatName() {
        return "mp3";
    }

    @Override
    public String getExtension() {
        return ".mp3";
    }

    public static class MP3StreamDriver
    extends MP3Driver {
        public MP3StreamDriver(OutputStream out) {
            this.out = out;
        }

        @Override
        protected OutputStream getOut(String recordingFilename) {
            return this.out;
        }
    }

    public static class MP3FileDriver
    extends MP3Driver {
        @Override
        protected OutputStream getOut(String recordingFilename) throws IOException {
            System.out.println("Recording, file=" + recordingFilename);
            return new FileOutputStream(recordingFilename);
        }

        @Override
        public void close() {
            super.close();
            if (this.out != null) {
                try {
                    this.out.close();
                }
                catch (IOException e) {
                    throw new RuntimeException("Error closing MP3 audio stream", e);
                }
                finally {
                    this.out = null;
                }
            }
        }
    }
}

