/*
 * Decompiled with CFR 0.152.
 */
package server.restful.common.validator;

import com.beust.jcommander.IParameterValidator;
import com.beust.jcommander.ParameterException;

public class MaxResultsValidator
implements IParameterValidator {
    private static final int MAX_RESULTS = 10000;

    public void validate(String name, String value) throws ParameterException {
        try {
            int n = Integer.parseInt(value);
            if (n < 0 || n > 10000) {
                throw new ParameterException("Invalid " + name + " value, expected 0.." + 10000 + " (found " + value + ")");
            }
        }
        catch (NumberFormatException e) {
            throw new ParameterException("Parameter " + name + " should be an int (found " + value + ")");
        }
    }
}

