/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.persist;

import org.hsqldb.error.Error;
import org.hsqldb.lib.LongLookup;
import org.hsqldb.persist.DataFileCache;
import org.hsqldb.persist.TableSpaceManager;

public class TableSpaceManagerSimple
implements TableSpaceManager {
    DataFileCache cache;
    final int scale;

    public TableSpaceManagerSimple(DataFileCache dataFileCache) {
        this.cache = dataFileCache;
        this.scale = dataFileCache.getDataFileScale();
    }

    @Override
    public int getSpaceID() {
        return 7;
    }

    @Override
    public void release(long l, int n) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long getFilePosition(int n) {
        this.cache.writeLock.lock();
        try {
            long l = this.cache.getFileFreePos();
            long l2 = l / (long)this.scale;
            long l3 = l + (long)n;
            if (l3 > this.cache.maxDataFileSize) {
                this.cache.logSevereEvent("data file reached maximum size " + this.cache.dataFileName, null);
                throw Error.error(468);
            }
            this.cache.fileFreePosition = l3;
            long l4 = l2;
            return l4;
        }
        finally {
            this.cache.writeLock.unlock();
        }
    }

    @Override
    public boolean hasFileRoom(long l) {
        return true;
    }

    @Override
    public void addFileBlock(long l, long l2) {
    }

    @Override
    public void initialiseFileBlock(LongLookup longLookup, long l, long l2) {
    }

    @Override
    public void reset() {
    }

    @Override
    public long getLostBlocksSize() {
        return 0L;
    }

    @Override
    public boolean isDefaultSpace() {
        return true;
    }
}

