/*
 * Decompiled with CFR 0.152.
 */
package builder.jexsid;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum HardwareModel {
    XS_MD_STD(0),
    XS_MD_PLUS(1);

    private int hardwareModel;
    private static final Map<Integer, HardwareModel> lookup;

    private HardwareModel(int hardwareModel) {
        this.hardwareModel = hardwareModel;
    }

    public int getHardwareModel() {
        return this.hardwareModel;
    }

    public static HardwareModel get(int hardwareModel) {
        return lookup.get(hardwareModel);
    }

    static {
        lookup = Collections.unmodifiableMap(Arrays.asList(HardwareModel.values()).stream().collect(Collectors.toMap(HardwareModel::getHardwareModel, Function.identity())));
    }
}

