/*
 * Decompiled with CFR 0.152.
 */
package builder.jexsid;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidplay.config.IEmulationSection;
import libsidplay.config.ISidPlay2SystemProperties;
import libsidplay.sidtune.SidTune;

public class JExSIDMapping {
    public static Map<Integer, String> mapping(IEmulationSection emulationSection, SidTune tune) {
        CPUClock cpuClock = CPUClock.getCPUClock(emulationSection, tune);
        HashSet<ChipModel> alreadyInUse = new HashSet<ChipModel>();
        HashMap<Integer, String> result = new HashMap<Integer, String>();
        for (int sidNum = 0; sidNum < ISidPlay2SystemProperties.MAX_SIDS; ++sidNum) {
            if (!SidTune.isSIDUsed(emulationSection, tune, sidNum)) continue;
            int address = SidTune.getSIDAddress(emulationSection, tune, sidNum);
            ChipModel chipModel = ChipModel.getChipModel(emulationSection, tune, sidNum);
            if (sidNum == 1 && SidTune.isFakeStereoSid(emulationSection, tune, 1)) continue;
            if (sidNum == 1 && JExSIDMapping.isChipNumAlreadyUsed(alreadyInUse, chipModel)) {
                chipModel = chipModel == ChipModel.MOS6581 ? ChipModel.MOS8580 : ChipModel.MOS6581;
            }
            result.put(sidNum, String.valueOf((Object)chipModel));
            result.put(address, String.valueOf(sidNum));
            alreadyInUse.add(chipModel);
        }
        result.put(-1, String.valueOf(SidTune.isSIDUsed(emulationSection, tune, 1)));
        result.put(-2, String.valueOf(emulationSection.isExsidFakeStereo() && SidTune.isFakeStereoSid(emulationSection, tune, 1)));
        result.put(-3, cpuClock.name());
        return result;
    }

    private static boolean isChipNumAlreadyUsed(Set<ChipModel> alreadyInUse, ChipModel chipModel) {
        return alreadyInUse.contains((Object)chipModel);
    }
}

