/*
 * Decompiled with CFR 0.152.
 */
package builder.resid.residfp;

import builder.resid.residfp.EnvelopeGenerator;
import builder.resid.residfp.WaveformGenerator;
import libsidplay.common.ChipModel;

public final class Voice {
    public final WaveformGenerator wave = new WaveformGenerator();
    public final EnvelopeGenerator envelope = new EnvelopeGenerator();
    private float voiceOffset;
    public boolean muted;

    float output(WaveformGenerator ringModulator) {
        return this.wave.output(ringModulator) * this.envelope.output() + this.voiceOffset;
    }

    protected Voice() {
    }

    public void setChipModel(ChipModel model) {
        this.voiceOffset = model == ChipModel.MOS6581 ? 522240.0f : -65280.0f;
    }

    public void writeCONTROL_REG(WaveformGenerator ring_modulator, byte control) {
        this.wave.writeCONTROL_REG(ring_modulator, control);
        this.envelope.writeCONTROL_REG(control);
    }

    public void reset() {
        this.wave.reset();
        this.envelope.reset();
    }

    public void mute(boolean enable) {
        this.muted = enable;
        this.envelope.mute(enable);
    }
}

