/*
 * Decompiled with CFR 0.152.
 */
package client.teavm;

import client.teavm.common.IImportedApi;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import libsidplay.components.printer.IPaper;
import org.teavm.interop.Import;
import org.teavm.jso.JSBody;
import org.teavm.jso.JSByRef;

public class ImportedApi
implements IImportedApi {
    private static final String MODULE_NAME = "jsidplay2";
    protected FloatBuffer resultL;
    protected FloatBuffer resultR;

    @Override
    public void initControlBuffer() {
    }

    @Override
    public ByteBuffer initSampleBuffer(int chunkFrames, int channels) {
        ByteBuffer samples = ByteBuffer.allocateDirect(chunkFrames * 2 * channels).order(ByteOrder.LITTLE_ENDIAN);
        for (int i = 0; i < samples.capacity(); ++i) {
            samples.put((byte)0);
        }
        ((Buffer)samples).clear();
        this.resultL = FloatBuffer.wrap(new float[chunkFrames]);
        this.resultR = FloatBuffer.wrap(new float[chunkFrames]);
        return samples;
    }

    @Override
    public ByteBuffer initPixelBuffer(int maxWidth, int maxHeight) {
        return ByteBuffer.allocate(maxWidth * maxHeight << 2).order(ByteOrder.BIG_ENDIAN);
    }

    @Override
    public ByteBuffer initGaugeBuffer(String type, int chipNum, int pathLength) {
        return ByteBuffer.allocate(pathLength * 4).order(ByteOrder.LITTLE_ENDIAN);
    }

    @Override
    public void processSamples(ByteBuffer sampleBuffer, float[] lookupTable) {
        ((Buffer)sampleBuffer).flip();
        int remaining = sampleBuffer.remaining() >> 2;
        for (int i = 0; i < remaining; ++i) {
            this.resultL.put(lookupTable[sampleBuffer.getShort() - Short.MIN_VALUE]);
            this.resultR.put(lookupTable[sampleBuffer.getShort() - Short.MIN_VALUE]);
        }
        ImportedApi.processSamplesJS(this.resultL.array(), this.resultR.array(), this.resultL.position());
        ((Buffer)this.resultL).clear();
        ((Buffer)this.resultR).clear();
    }

    @Override
    public void processPixels(ByteBuffer pixels) {
        ImportedApi.processPixelsJS(pixels.array(), pixels.array().length);
    }

    @Override
    public void processOsc(int sidNum, ByteBuffer wav0, String wav0Txt, ByteBuffer wav1, String wav1Txt, ByteBuffer wav2, String wav2Txt, ByteBuffer env0, String env0Txt, ByteBuffer env1, String env1Txt, ByteBuffer env2, String env2Txt, ByteBuffer fre0, String frq0Txt, ByteBuffer frq1, String frq1Txt, ByteBuffer frq2, String frq2Txt, ByteBuffer vol, String volTxt, ByteBuffer res, String resTxt, ByteBuffer fil, String filTxt) {
        ImportedApi.processOscJS(sidNum, wav0.array(), wav0Txt, wav1.array(), wav1Txt, wav2.array(), wav2Txt, env0.array(), env0Txt, env1.array(), env1Txt, env2.array(), env2Txt, fre0.array(), frq0Txt, frq1.array(), frq1Txt, frq2.array(), frq2Txt, vol.array(), volTxt, res.array(), resTxt, fil.array(), filTxt);
    }

    @Override
    public void processSidWrite(long absTime, int relTime, int addr, int value) {
        ImportedApi.processSidWriteJS(absTime, relTime, addr, value);
    }

    @Override
    public void processTimerEnd(double end) {
        ImportedApi.processTimerEndJS(end);
    }

    @Override
    public void processPrinter(IPaper.Outputs output) {
        ImportedApi.processPrinterJS(output.name());
    }

    @Override
    public void whatsSid(byte[] array) {
        ImportedApi.whatsSidJS(array, array.length);
    }

    @Import(module="jsidplay2", name="processSamples")
    @JSBody(params={"lf", "ri", "le"}, script="processSamples(lf,ri,le)")
    public static native void processSamplesJS(@JSByRef(optional=true) float[] var0, @JSByRef(optional=true) float[] var1, int var2);

    @Import(module="jsidplay2", name="processPixels")
    @JSBody(params={"pi", "le"}, script="processPixels(pi,le)")
    public static native void processPixelsJS(@JSByRef(optional=true) byte[] var0, int var1);

    @Import(module="jsidplay2", name="processSidWrite")
    @JSBody(params={"at", "ti", "ad", "va"}, script="processSidWrite(at,ti,ad,va)")
    public static native void processSidWriteJS(double var0, int var2, int var3, int var4);

    @Import(module="jsidplay2", name="processOsc")
    @JSBody(params={"sidNum", "wav0", "wav0Txt", "wav1", "wav1Txt", "wav2", "wav2Txt", "env0", "env0Txt", "env1", "env1Txt", "env2", "env2Txt", "frq0", "frq0Txt", "frq1", "frq1Txt", "frq2", "frq2Txt", "vol", "volTxt", "res", "resTxt", "fil", "filTxt"}, script="processOsc(sidNum, wav0, wav0Txt, wav1, wav1Txt, wav2, wav2Txt, env0, env0Txt, env1, env1Txt, env2, env2Txt, frq0, frq0Txt, frq1, frq1Txt, frq2, frq2Txt, vol, volTxt, res, resTxt, fil, filTxt)")
    public static native void processOscJS(int var0, @JSByRef(optional=true) byte[] var1, String var2, @JSByRef(optional=true) byte[] var3, String var4, @JSByRef(optional=true) byte[] var5, String var6, @JSByRef(optional=true) byte[] var7, String var8, @JSByRef(optional=true) byte[] var9, String var10, @JSByRef(optional=true) byte[] var11, String var12, @JSByRef(optional=true) byte[] var13, String var14, @JSByRef(optional=true) byte[] var15, String var16, @JSByRef(optional=true) byte[] var17, String var18, @JSByRef(optional=true) byte[] var19, String var20, @JSByRef(optional=true) byte[] var21, String var22, @JSByRef(optional=true) byte[] var23, String var24);

    @Import(module="jsidplay2", name="timerEnd")
    @JSBody(params={"ed"}, script="timerEnd(ed)")
    public static native void processTimerEndJS(double var0);

    @Import(module="jsidplay2", name="processPrinter")
    @JSBody(params={"op"}, script="processPrinter(op)")
    public static native void processPrinterJS(String var0);

    @Import(module="jsidplay2", name="whatsSid")
    @JSBody(params={"ar", "le"}, script="whatsSid(ar,le)")
    public static native void whatsSidJS(@JSByRef(optional=true) byte[] var0, int var1);
}

