/*
 * Decompiled with CFR 0.152.
 */
package libsidplay.components.mos656x;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

class OctreeQuantization {
    private static final int MAX_DEPTH = 10;
    private static final int MAX_BUCKET_DEPTH = 2;
    private static final int COMPONENT_MASK = 1023;
    final List<List<Node>> buckets = new ArrayList<List<Node>>();
    final Node root = new Node(null);
    protected final Set<Node> leaves = new HashSet<Node>();
    private final int max;

    protected OctreeQuantization(int max) {
        this.max = max;
    }

    protected void addColor(int color, int weight) {
        this.root.add(color, weight, 10);
    }

    private void quantize() {
        if (this.leaves.size() <= this.max) {
            return;
        }
        TreeSet<Node> parentSet = new TreeSet<Node>((o1, o2) -> {
            int id2;
            if (o1.reference > o2.reference) {
                return 1;
            }
            if (o1.reference < o2.reference) {
                return -1;
            }
            int id1 = System.identityHashCode(o1);
            if (id1 > (id2 = System.identityHashCode(o2))) {
                return 1;
            }
            if (id1 < id2) {
                return -1;
            }
            return 0;
        });
        for (Node leaf : this.leaves) {
            parentSet.add(leaf.parent);
        }
        while (this.leaves.size() > this.max) {
            Node parent = (Node)parentSet.first();
            parentSet.remove(parent);
            parent.reduce();
            parentSet.add(parent.parent);
        }
    }

    protected int[] getPalette() {
        int i;
        this.quantize();
        this.buckets.clear();
        for (i = 0; i < 64; ++i) {
            this.buckets.add(new ArrayList());
        }
        i = 0;
        int[] finalPalette = new int[this.max];
        for (Node node : this.leaves) {
            finalPalette[i++] = node.toPacked();
            this.bucketStore(node);
        }
        return finalPalette;
    }

    private void bucketStore(Node node) {
        int color = node.toPacked();
        int r_ref = color >> 20 & 0x3FF;
        int g_ref = color >> 10 & 0x3FF;
        int b_ref = color >> 0 & 0x3FF;
        r_ref >>= 8;
        g_ref >>= 8;
        b_ref >>= 8;
        for (int dr = -1; dr <= 0; ++dr) {
            for (int dg = -1; dg <= 0; ++dg) {
                for (int db = -1; db <= 0; ++db) {
                    int r = r_ref + dr;
                    int g = g_ref + dg;
                    int b = b_ref + db;
                    if (r < 0 || g < 0 || b < 0 || r > 7 || g > 7 || b > 7) continue;
                    int bucketIdx = r << 4 | g << 2 | b << 0;
                    this.buckets.get(bucketIdx).add(node);
                }
            }
        }
    }

    public int lookup(int color) {
        int r_ref = color >> 20 & 0x3FF;
        int rb = r_ref >> 8;
        int g_ref = color >> 10 & 0x3FF;
        int gb = g_ref >> 8;
        int b_ref = color >> 0 & 0x3FF;
        int bb = b_ref >> 8;
        int bucketIdx = rb << 4 | gb << 2 | bb << 0;
        Set<Node> bucket = (Set<Node>)((Object)this.buckets.get(bucketIdx));
        if (!bucket.iterator().hasNext()) {
            bucket = this.leaves;
        }
        int bestDistance = Integer.MAX_VALUE;
        Node bestMatch = null;
        Node n = new Node(null);
        n.red = r_ref;
        n.green = g_ref;
        n.blue = b_ref;
        n.reference = 1;
        for (Node s : bucket) {
            int trialDistance = n.distance(s);
            if (trialDistance >= bestDistance) continue;
            bestDistance = trialDistance;
            bestMatch = s;
        }
        assert (bestMatch != null);
        return bestMatch.toPacked();
    }

    private class Node {
        private boolean leaf;
        protected int reference;
        protected int red;
        protected int green;
        protected int blue;
        protected final Node parent;
        private final Node[] children = new Node[8];

        protected Node(Node parent) {
            this.parent = parent;
        }

        private final int pickChild(int packed, int depth) {
            int r = packed >> 20 + depth - 1 & 1;
            int g = packed >> 10 + depth - 1 & 1;
            int b = packed >> 0 + depth - 1 & 1;
            return r << 2 | g << 1 | b;
        }

        protected void add(int packed, int weight, int depth) {
            this.reference += weight;
            if (this.leaf) {
                this.red += (packed >> 20 & 0x3FF) * weight;
                this.green += (packed >> 10 & 0x3FF) * weight;
                this.blue += (packed >> 0 & 0x3FF) * weight;
                return;
            }
            int i = this.pickChild(packed, depth);
            if (this.children[i] == null) {
                this.children[i] = new Node(this);
                if (depth == 1) {
                    OctreeQuantization.this.leaves.add(this.children[i]);
                    this.children[i].leaf = true;
                }
            }
            this.children[i].add(packed, weight, depth - 1);
        }

        protected Node find(int packed, int depth) {
            int i = this.pickChild(packed, depth);
            if (this.children[i] != null) {
                return this.children[i].find(packed, depth - 1);
            }
            return this;
        }

        protected void reduce() {
            for (Node c : this.children) {
                if (c == null) continue;
                this.red += c.red;
                this.green += c.green;
                this.blue += c.blue;
                OctreeQuantization.this.leaves.remove(c);
            }
            this.leaf = true;
            OctreeQuantization.this.leaves.add(this);
            Arrays.fill(this.children, null);
        }

        protected int toPacked() {
            int r = this.red / this.reference;
            int g = this.green / this.reference;
            int b = this.blue / this.reference;
            return r << 20 | g << 10 | b << 0;
        }

        protected int distance(Node a) {
            int dr = a.red / a.reference - this.red / this.reference;
            int dg = a.green / a.reference - this.green / this.reference;
            int db = a.blue / a.reference - this.blue / this.reference;
            return dr * dr + dg * dg + db * db;
        }
    }
}

