/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.directory;

import java.util.ArrayList;
import java.util.Collection;
import libsidutils.directory.DirEntry;

public abstract class Directory {
    protected boolean singleSided = true;
    protected byte[] title;
    protected byte[] id;
    protected Collection<DirEntry> dirEntries = new ArrayList<DirEntry>();
    protected String statusLine;

    public String getTitle() {
        StringBuilder header = new StringBuilder();
        header.append(this.singleSided ? "0 " : "1 ");
        header.append(DirEntry.toQuotedFilenameAndType(this.title, (byte)-1));
        if (this.id != null) {
            header.append(" ");
            for (byte element : this.id) {
                header.append((char)(element & 0xFF));
            }
        }
        return header.toString();
    }

    public Collection<DirEntry> getDirEntries() {
        return this.dirEntries;
    }

    public String getStatusLine() {
        return this.statusLine;
    }
}

