/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.fingerprinting.fingerprint;

import java.util.ArrayList;
import libsidutils.fingerprinting.fingerprint.FindPeaks;
import libsidutils.fingerprinting.fingerprint.Hash;
import libsidutils.fingerprinting.fingerprint.Link;
import libsidutils.fingerprinting.fingerprint.Peak;
import libsidutils.fingerprinting.ini.IFingerprintConfig;
import libsidutils.fingerprinting.ini.IFingerprintSection;
import libsidutils.fingerprinting.rest.beans.HashBean;
import libsidutils.fingerprinting.rest.beans.HashBeans;
import libsidutils.fingerprinting.rest.beans.IdBean;
import libsidutils.fingerprinting.spectrogram.Spectrogram;

public class Fingerprint {
    private static final float SAMPLE_RATE = 8000.0f;
    private int dataLen;
    private int nPeaks;
    private int fftSize;
    private int overlap;
    private int c;
    private int peakRange;
    private float[] range_time;
    private float[] range_freq;
    private int[] Band;
    private int minFreq;
    private int maxFreq;
    private int minPower;
    private final ArrayList<Peak> peakList = new ArrayList();
    private final ArrayList<Link> linkList = new ArrayList();
    private final float[] freq;
    private final float[] time;

    public Fingerprint(IFingerprintConfig config, short[] samples) {
        this.dataLen = samples.length;
        IFingerprintSection fingerPrintSection = config.getFingerPrintSection();
        this.nPeaks = fingerPrintSection.getNPeaks();
        this.fftSize = fingerPrintSection.getFftSize();
        this.overlap = fingerPrintSection.getOverlap();
        this.c = fingerPrintSection.getC();
        this.peakRange = fingerPrintSection.getPeakRange();
        this.range_time = fingerPrintSection.getRangeTime();
        this.range_freq = fingerPrintSection.getRangeFreq();
        this.Band = fingerPrintSection.getBand();
        this.minFreq = fingerPrintSection.getMinFreq();
        this.maxFreq = fingerPrintSection.getMaxFreq();
        this.minPower = fingerPrintSection.getMinPower();
        Spectrogram spectrogram = new Spectrogram(samples, 2, this.fftSize, this.overlap, 8000.0f);
        ArrayList<float[]> stft = spectrogram.stft;
        this.freq = spectrogram.freq;
        this.time = spectrogram.time;
        ArrayList<Peak> tmp = new ArrayList<Peak>(this.c * this.nPeaks);
        int size = stft.size();
        int bandNum = this.Band.length - 1;
        for (int b = 0; b < bandNum; ++b) {
            for (int i = 0; i < size; ++i) {
                if (i != 0 && (i % this.c == 0 || i == size - 1)) {
                    tmp.removeIf(peak -> {
                        float peakFreq = this.freq[peak.getIntFreq()];
                        return peakFreq < (float)this.minFreq || peakFreq > (float)this.maxFreq;
                    });
                    tmp.removeIf(peak -> peak.getPower() <= (float)this.minPower);
                    tmp.sort((o1, o2) -> Double.compare(o2.getPower(), o1.getPower()));
                    int end = tmp.size() < this.nPeaks ? tmp.size() : this.nPeaks;
                    this.peakList.addAll(tmp.subList(0, end));
                    tmp.clear();
                }
                float[] fft = stft.get(i);
                int len = this.Band[b + 1] - this.Band[b];
                int start = this.Band[b] * 2;
                float[] fft_band = new float[len *= 2];
                System.arraycopy(fft, start, fft_band, 0, len);
                FindPeaks find = new FindPeaks(this.nPeaks);
                find.findComplexPeaks(fft_band, this.peakRange);
                float[] power = find.getPower();
                int[] loc = find.getLocate();
                int j = 0;
                while (j < power.length) {
                    int n = j++;
                    loc[n] = loc[n] + this.Band[b];
                }
                for (j = 0; j < this.nPeaks; ++j) {
                    if (loc[j] == -1) continue;
                    Peak p = new Peak();
                    p.setIntFreq(loc[j]);
                    p.setIntTime(i);
                    p.setPower(power[j]);
                    tmp.add(p);
                }
            }
        }
        this.peakList.sort((o1, o2) -> o1.getIntTime() - o2.getIntTime());
        this.link(true);
    }

    private int inBand(int intFreq) {
        int size = this.Band.length;
        if (intFreq < this.Band[0] || intFreq > this.Band[size - 1]) {
            return -1;
        }
        for (int i = 0; i < size - 1; ++i) {
            if (this.Band[i + 1] <= intFreq) continue;
            return i;
        }
        return -1;
    }

    private void link(boolean band) {
        int n = this.peakList.size();
        for (int i = 0; i < n; ++i) {
            int k;
            Peak p1 = this.peakList.get(i);
            if (p1 == null) continue;
            for (k = i + 1; k < n; ++k) {
                float t = this.time[p1.getIntTime()];
                float t2 = this.time[this.peakList.get(k).getIntTime()];
                if (t2 - t >= this.range_time[0]) break;
            }
            int tStart = k;
            while (k < n) {
                float t = this.time[p1.getIntTime()];
                float t2 = this.time[this.peakList.get(k).getIntTime()];
                if (t2 - t >= this.range_time[1]) break;
                ++k;
            }
            int tEnd = k;
            float fstart = this.freq[p1.getIntFreq()] + this.range_freq[0];
            float fend = this.freq[p1.getIntFreq()] + this.range_freq[1];
            for (int i2 = tStart; i2 < tEnd; ++i2) {
                Peak p2 = this.peakList.get(i2);
                if (p2 == null) continue;
                if (band) {
                    int b2;
                    int b1 = this.inBand(p1.getIntFreq());
                    if (b1 != (b2 = this.inBand(p2.getIntFreq())) || b1 == -1) continue;
                    Link l = new Link(p1, p2);
                    this.linkList.add(l);
                    continue;
                }
                if (!(this.freq[p2.getIntFreq()] >= fstart) || !(this.freq[p2.getIntFreq()] <= fend)) continue;
                Link l = new Link(p1, p2);
                this.linkList.add(l);
            }
        }
    }

    public ArrayList<Link> getLinkList() {
        return this.linkList;
    }

    public ArrayList<Peak> getPeakList() {
        return this.peakList;
    }

    public HashBeans toHashBeans(IdBean id) {
        HashBeans result = new HashBeans();
        for (Link link : this.linkList) {
            HashBean hashBean = new HashBean();
            hashBean.setHash(Hash.hash(link));
            hashBean.setId(id.getId());
            hashBean.setTime(link.getStart().getIntTime());
            result.getHashes().add(hashBean);
        }
        return result;
    }

    public float getAudioLength() {
        return (float)this.dataLen / 8000.0f;
    }
}

