/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.fingerprinting.spectrogram;

public class Window {
    private static final int RECT = 1;
    public static final int HANN = 2;
    private final float[] window;
    private final int windowSize;

    public Window(int windowType, int windowSize) {
        this.windowSize = windowSize;
        this.window = new float[windowSize];
        switch (windowType) {
            case 1: {
                this.initRectWindow(windowSize);
                break;
            }
            case 2: {
                this.initHannWindow(windowSize);
            }
        }
    }

    public float[] window(short[] data, int pos) {
        int i;
        int size = this.windowSize;
        if (pos + size > data.length) {
            size = data.length - pos;
        }
        float[] win = new float[this.windowSize];
        for (i = 0; i < size; ++i) {
            win[i] = (float)data[pos + i] / 32768.0f;
        }
        for (i = 0; i < win.length; ++i) {
            win[i] = win[i] * this.window[i];
        }
        return win;
    }

    private void initRectWindow(int windowSize) {
        for (int i = 0; i < windowSize; ++i) {
            this.window[i] = 1.0f;
        }
    }

    private void initHannWindow(int windowSize) {
        for (int i = 0; i < windowSize; ++i) {
            this.window[i] = (float)(0.5 * (1.0 - Math.cos(Math.PI * 2 * (double)i / (double)(windowSize - 1))));
        }
    }

    public static float[] window(float[] data, int pos, int windowType, int windowSize) {
        int size = windowSize;
        if (pos + size > data.length) {
            size = data.length - pos;
        }
        float[] win = new float[windowSize];
        System.arraycopy(data, pos, win, 0, size);
        switch (windowType) {
            case 1: {
                Window.rect(win);
                break;
            }
            case 2: {
                Window.hann(win);
            }
        }
        return win;
    }

    private static float[] rect(float[] data) {
        int n = data.length;
        float w = 1.0f;
        for (int i = 0; i < n; ++i) {
            data[i] = data[i] * w;
        }
        return data;
    }

    private static float[] hann(float[] data) {
        int n = data.length;
        for (int i = 0; i < n; ++i) {
            float w = (float)(0.5 * (1.0 - Math.cos(Math.PI * 2 * (double)i / (double)(n - 1))));
            data[i] = data[i] * w;
        }
        return data;
    }
}

