/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.sidid;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Locale;
import java.util.StringTokenizer;
import libsidutils.sidid.SidIdBase;
import libsidutils.stringsearch.BNDMWildcards;

public final class SidIdV2
extends SidIdBase {
    private static final String SID_ID_PKG = "libsidutils/sidid/";
    private static final String FNAME = "sidid.cfg";
    private static final int HEX_RADIX = 16;
    private static final int MAX_KEY_LENGTH = 32;
    private final BNDMWildcards search;
    private ArrayList<PlayerSection> sections = new ArrayList();
    private boolean multiScan;

    public void setMultiScan(boolean m) {
        this.multiScan = m;
    }

    public SidIdV2() {
        this.search = new BNDMWildcards();
    }

    public ArrayList<String> identify(String filename) throws IOException {
        return this.identify(this.load(filename));
    }

    public ArrayList<String> identify(byte[] prg) {
        ArrayList<String> result = new ArrayList<String>();
        for (PlayerSection section : this.sections) {
            if (!this.matchOneOf(section.getOrList(), prg)) continue;
            result.add(section.getPlayerName());
            if (this.multiScan) continue;
            return result;
        }
        return result;
    }

    private boolean matchOneOf(ArrayList<ArrayList<Pattern>> orList, byte[] prg) {
        for (ArrayList<Pattern> andList : orList) {
            if (!this.matchAllOf(andList, prg)) continue;
            return true;
        }
        return false;
    }

    private boolean matchAllOf(ArrayList<Pattern> andList, byte[] prg) {
        int prgOffset = 0;
        for (Pattern pattern : andList) {
            int prgEnd = prg.length - prgOffset;
            if (pattern.isSubPattern() && (prgEnd = prgOffset + pattern.getPattern().length) > prg.length) {
                return false;
            }
            int index = this.search.searchBytes(prg, prgOffset, prgEnd, pattern.getPattern(), pattern.getPreProcessedPattern());
            if (index == -1) {
                return false;
            }
            prgOffset = index + pattern.getPattern().length;
        }
        return true;
    }

    public void readconfig() throws NumberFormatException, IOException {
        this.readconfig(this.readConfiguration(FNAME, SID_ID_PKG));
    }

    public void readconfig(byte[] sidIdCfgBin) throws NumberFormatException, IOException {
        String line;
        this.sections = new ArrayList();
        PlayerSection section = null;
        ArrayList<Byte> byteList = new ArrayList<Byte>();
        BufferedReader br = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(sidIdCfgBin), StandardCharsets.UTF_8.name()));
        block0: while ((line = br.readLine()) != null) {
            if (line == null || line.isEmpty()) continue;
            StringTokenizer stok = new StringTokenizer(line, " ");
            while (stok.hasMoreTokens()) {
                String origToken = stok.nextToken();
                String token = origToken.toLowerCase(Locale.ENGLISH);
                if (token.length() <= 0) continue;
                if ("??".equals(token)) {
                    byteList.add((byte)63);
                    continue;
                }
                if ("end".equals(token)) {
                    assert (section != null);
                    this.andBytes(section, byteList);
                    ArrayList orList = new ArrayList();
                    section.getOrList().add(orList);
                    continue block0;
                }
                if ("and".equals(token) || "&&".equals(token)) {
                    assert (section != null);
                    this.andBytes(section, byteList);
                    continue;
                }
                if (token.length() == 2) {
                    byteList.add(Integer.valueOf(token, 16).byteValue());
                    continue;
                }
                if (section != null) {
                    section.getOrList().remove(section.getOrList().size() - 1);
                }
                section = new PlayerSection(origToken);
                this.sections.add(section);
                continue block0;
            }
            this.andBytes(section, byteList);
            ArrayList orList = new ArrayList();
            section.getOrList().add(orList);
        }
        if (section != null) {
            section.getOrList().remove(section.getOrList().size() - 1);
        }
    }

    private void andBytes(PlayerSection section, ArrayList<Byte> byteList) {
        ArrayList<Pattern> lastOr = section.getOrList().get(section.getOrList().size() - 1);
        int byteListOffset = 0;
        int byteCount = byteList.size();
        boolean isSubPattern = false;
        while (byteCount > 32) {
            this.andBytesMaxPtnLength(lastOr, byteList, byteListOffset, 32, isSubPattern);
            byteCount -= 32;
            byteListOffset += 32;
            isSubPattern = true;
        }
        this.andBytesMaxPtnLength(lastOr, byteList, byteListOffset, byteCount, isSubPattern);
        byteList.clear();
    }

    private void andBytesMaxPtnLength(ArrayList<Pattern> ptnList, ArrayList<Byte> byteList, int byteListOffset, int byteCount, boolean isSubPattern) {
        assert (byteCount <= 32);
        byte[] and = new byte[byteCount];
        for (int i = 0; i < and.length; ++i) {
            and[i] = byteList.get(i + byteListOffset);
        }
        ptnList.add(new Pattern(and, this.search.processBytes(and, (byte)63), isSubPattern));
    }

    private static class PlayerSection {
        private final String playerName;
        private final ArrayList<ArrayList<Pattern>> orList;

        public PlayerSection(String name) {
            this.playerName = name;
            this.orList = new ArrayList();
            this.orList.add(new ArrayList());
        }

        public final String getPlayerName() {
            return this.playerName;
        }

        public final ArrayList<ArrayList<Pattern>> getOrList() {
            return this.orList;
        }
    }

    private static class Pattern {
        private final byte[] pattern;
        private final Object preProcessedPattern;
        private final boolean isSubPattern;

        public Pattern(byte[] p, Object pre, boolean subPattern) {
            this.pattern = p;
            this.preProcessedPattern = pre;
            this.isSubPattern = subPattern;
        }

        public byte[] getPattern() {
            return this.pattern;
        }

        public Object getPreProcessedPattern() {
            return this.preProcessedPattern;
        }

        public boolean isSubPattern() {
            return this.isSubPattern;
        }
    }
}

