/*
 * Decompiled with CFR 0.152.
 */
package libsidutils.status;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Optional;
import java.util.function.BooleanSupplier;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import libsidplay.HardwareEnsemble;
import libsidplay.common.CPUClock;
import libsidplay.common.ChipModel;
import libsidplay.common.Emulation;
import libsidplay.common.Event;
import libsidplay.common.EventScheduler;
import libsidplay.common.HardwareSIDBuilder;
import libsidplay.common.SIDBuilder;
import libsidplay.components.c1530.Datasette;
import libsidplay.components.c1541.C1541;
import libsidplay.components.cart.Cartridge;
import libsidplay.config.IEmulationSection;
import libsidplay.config.ISidPlay2SystemProperties;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneInfo;
import libsidutils.IOUtils;
import sidplay.audio.AudioDriver;

public class Status {
    private final HardwareEnsemble hardwareEnsemble;
    private final SidTune tune;
    private final SIDBuilder sidBuilder;
    private final AudioDriver audioDriver;
    private final Function<SidTune, String> recordingFilenameProvider;
    private final DoubleSupplier lengthFnct;
    private final BooleanSupplier psid64Function;
    private final Function<String, String> resourceBundle;

    public Status(HardwareEnsemble hardwareEnsemble, SidTune tune, SIDBuilder sidBuilder, AudioDriver audioDriver, Function<SidTune, String> recordingFilenameProvider, DoubleSupplier lengthFnct, BooleanSupplier psid64Function, Function<String, String> resourceBundle) {
        this.hardwareEnsemble = hardwareEnsemble;
        this.tune = tune;
        this.sidBuilder = sidBuilder;
        this.audioDriver = audioDriver;
        this.recordingFilenameProvider = recordingFilenameProvider;
        this.lengthFnct = lengthFnct;
        this.psid64Function = psid64Function;
        this.resourceBundle = resourceBundle;
    }

    public String determineVideoNorm() {
        return CPUClock.getCPUClock(this.hardwareEnsemble.getConfig().getEmulationSection(), this.tune).name();
    }

    public String determineChipModels() {
        IEmulationSection emulation = this.hardwareEnsemble.getConfig().getEmulationSection();
        StringBuilder result = new StringBuilder();
        this.determineChipModel(result, emulation, 0);
        if (SidTune.isSIDUsed(emulation, this.tune, 1)) {
            result.append("+");
            this.determineChipModel(result, emulation, 1);
            if (SidTune.isSIDUsed(emulation, this.tune, 2)) {
                result.append("+");
                this.determineChipModel(result, emulation, 2);
                this.andNMore(emulation, result);
            }
        }
        return result.toString();
    }

    private void determineChipModel(StringBuilder result, IEmulationSection emulationSection, int sidNum) {
        ChipModel chipModel = ChipModel.getChipModel(emulationSection, this.tune, sidNum);
        int sidBase = SidTune.getSIDAddress(emulationSection, this.tune, sidNum);
        if (sidBase != 54272) {
            result.append(String.format("%s(at 0x%04x)", new Object[]{chipModel, sidBase}));
        } else {
            result.append((Object)chipModel);
        }
    }

    public String determineEmulations() {
        IEmulationSection emulation = this.hardwareEnsemble.getConfig().getEmulationSection();
        StringBuilder result = new StringBuilder();
        switch (emulation.getEngine()) {
            case EMULATION: {
                result.append(Emulation.getEmulation(emulation, 0).name());
                if (!SidTune.isSIDUsed(emulation, this.tune, 1)) break;
                result.append("+");
                result.append(Emulation.getEmulation(emulation, 1).name());
                if (!SidTune.isSIDUsed(emulation, this.tune, 2)) break;
                result.append("+");
                result.append(Emulation.getEmulation(emulation, 2).name());
                this.andNMore(emulation, result);
                break;
            }
            case HARDSID: 
            case SIDBLASTER: 
            case EXSID: 
            case USBSID: 
            case HARDSID_DLL: {
                Integer deviceCount = this.getHardwareSIDBuilderInfo(sidBuilder -> sidBuilder.getDeviceCount(), null);
                if (deviceCount != null) {
                    this.determineEmulation(result, emulation, 0);
                    if (SidTune.isSIDUsed(emulation, this.tune, 1)) {
                        result.append("+");
                        this.determineEmulation(result, emulation, 1);
                        if (SidTune.isSIDUsed(emulation, this.tune, 2)) {
                            result.append("+");
                            this.determineEmulation(result, emulation, 2);
                        }
                    }
                    result.append(" ");
                    result.append(String.format(this.resourceBundle.apply("DEVICES"), deviceCount));
                    break;
                }
            }
            case NETSID: {
                result.append(emulation.getEngine().name());
                if (!SidTune.isSIDUsed(emulation, this.tune, 1)) break;
                result.append("+");
                result.append(emulation.getEngine().name());
                if (!SidTune.isSIDUsed(emulation, this.tune, 2)) break;
                result.append("+");
                result.append(emulation.getEngine().name());
                break;
            }
        }
        return result.toString();
    }

    private void andNMore(IEmulationSection emulation, StringBuilder result) {
        int sidNum;
        for (sidNum = 3; sidNum < ISidPlay2SystemProperties.MAX_SIDS && SidTune.isSIDUsed(emulation, this.tune, sidNum); ++sidNum) {
        }
        if (sidNum > 3) {
            result.append("+");
            result.append(sidNum - 3);
            result.append(" ");
            result.append(this.resourceBundle.apply("MORE"));
        }
    }

    private void determineEmulation(StringBuilder result, IEmulationSection emulationSection, int sidNum) {
        Integer deviceId = this.getHardwareSIDBuilderInfo(sidBuilder -> sidBuilder.getDeviceId(sidNum), null);
        String deviceName = this.getHardwareSIDBuilderInfo(sidBuilder -> sidBuilder.getDeviceName(sidNum), null);
        ChipModel deviceChipModel = this.getHardwareSIDBuilderInfo(sidBuilder -> sidBuilder.getDeviceChipModel(sidNum), null);
        if (deviceId != null) {
            result.append(String.format(this.resourceBundle.apply("DEVICE"), new Object[]{emulationSection.getEngine().name(), deviceId + 1, Optional.ofNullable(deviceChipModel).orElse(ChipModel.AUTO), Optional.ofNullable(deviceName).orElse("")}));
        } else {
            result.append(emulationSection.getEngine().name());
        }
    }

    public String determineTuneSpeed() {
        double tuneSpeed = this.hardwareEnsemble.getC64().determineTuneSpeed();
        if (tuneSpeed > 0.0) {
            return String.format("%s: %.1fx", this.resourceBundle.apply("SPEED"), tuneSpeed);
        }
        return "";
    }

    public String determineSong() {
        SidTuneInfo info;
        if (this.tune != SidTune.RESET && (info = this.tune.getInfo()).getSongs() > 1) {
            return String.format("%s: %d/%d", this.resourceBundle.apply("SONG"), info.getCurrentSong(), info.getSongs());
        }
        return "";
    }

    public String determineDiskActivity(boolean showTrack) {
        C1541 c1541 = this.hardwareEnsemble.getFloppies()[0];
        if (!c1541.isPowerOn()) {
            return "";
        }
        if (showTrack) {
            int halfTrack = c1541.getDiskController().getHalfTrack();
            if (c1541.getDiskController().isMotorOn()) {
                return String.format("%s: %02d", this.resourceBundle.apply("FLOPPY_TRACK"), halfTrack >> 1);
            }
        } else {
            return c1541.getDiskController().isMotorOn() ? "*" : "";
        }
        return "";
    }

    public String determineTapeActivity(boolean showCounter) {
        Datasette datasette = this.hardwareEnsemble.getDatasette();
        if (showCounter) {
            if (datasette.getMotor()) {
                return String.format("%s: %03d", this.resourceBundle.apply("DATASETTE_COUNTER"), datasette.getCounter());
            }
        } else {
            return datasette.getMotor() ? "+" : "";
        }
        return "";
    }

    public String determineCartridge() {
        Cartridge cartridge = this.hardwareEnsemble.getC64().getCartridge();
        if (cartridge != null) {
            return cartridge.toString();
        }
        return "";
    }

    public String determineHeap() {
        StringBuilder result = new StringBuilder();
        Runtime runtime = Runtime.getRuntime();
        result.append(this.resourceBundle.apply("MEMORY"));
        result.append(": ");
        result.append(IOUtils.getPhysicalSize(runtime.totalMemory() - runtime.freeMemory()));
        result.append("/");
        result.append(IOUtils.getPhysicalSize(runtime.maxMemory()));
        return result.toString();
    }

    public String determineTime(boolean showMillis) {
        double timeInSeconds = this.time();
        if (showMillis) {
            return String.format("%s: %s", this.resourceBundle.apply("TIME"), new SimpleDateFormat("mm:ss.SSS").format(new Date((long)(timeInSeconds * 1000.0))));
        }
        return new SimpleDateFormat("mm:ss").format(new Date((long)(timeInSeconds * 1000.0)));
    }

    public String determineSongLength(boolean showMillis) {
        double songLength;
        if (this.tune != SidTune.RESET && (songLength = this.lengthFnct.getAsDouble()) > 0.0) {
            if (showMillis) {
                return new SimpleDateFormat("mm:ss.SSS").format(new Date((long)(songLength * 1000.0)));
            }
            return new SimpleDateFormat("mm:ss").format(new Date((long)(songLength * 1000.0)));
        }
        return "";
    }

    public String determineRecording() {
        if (this.audioDriver.isRecording()) {
            return String.format("%s: %s (%s)", this.resourceBundle.apply("RECORDING_FILENAME"), this.recordingFilenameProvider.apply(this.tune), IOUtils.getPhysicalSize(new File(this.recordingFilenameProvider.apply(this.tune)).length()));
        }
        return "";
    }

    public String determinePSID64() {
        if (this.psid64Function.getAsBoolean()) {
            return "PSID64";
        }
        return "";
    }

    private final <T> T getHardwareSIDBuilderInfo(Function<HardwareSIDBuilder, T> function, T defaultValue) {
        return this.sidBuilder instanceof HardwareSIDBuilder ? function.apply((HardwareSIDBuilder)this.sidBuilder) : defaultValue;
    }

    private final double time() {
        EventScheduler c = this.hardwareEnsemble.getC64().getEventScheduler();
        long initDelay = SidTune.getInitDelay(this.tune);
        return (double)(c.getTime(Event.Phase.PHI2) - initDelay) / c.getCyclesPerSecond();
    }
}

