/*
 * Decompiled with CFR 0.152.
 */
package server.restful;

import com.beust.jcommander.JCommander;
import com.beust.jcommander.Parameter;
import com.beust.jcommander.ParameterException;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.Filter;
import jakarta.servlet.MultipartConfigElement;
import jakarta.servlet.Servlet;
import jakarta.servlet.annotation.MultipartConfig;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebFilter;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Timer;
import java.util.TimerTask;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import libsidutils.siddatabase.SidDatabase;
import libsidutils.stil.STIL;
import org.apache.catalina.Context;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.LifecycleState;
import org.apache.catalina.Realm;
import org.apache.catalina.Valve;
import org.apache.catalina.Wrapper;
import org.apache.catalina.authenticator.BasicAuthenticator;
import org.apache.catalina.connector.Connector;
import org.apache.catalina.realm.MemoryRealm;
import org.apache.catalina.startup.Tomcat;
import org.apache.coyote.UpgradeProtocol;
import org.apache.coyote.http11.Http11Nio2Protocol;
import org.apache.coyote.http2.Http2Protocol;
import org.apache.tomcat.util.descriptor.web.FilterDef;
import org.apache.tomcat.util.descriptor.web.FilterMap;
import org.apache.tomcat.util.descriptor.web.LoginConfig;
import org.apache.tomcat.util.descriptor.web.SecurityCollection;
import org.apache.tomcat.util.descriptor.web.SecurityConstraint;
import org.apache.tomcat.util.net.SSLHostConfig;
import org.apache.tomcat.util.net.SSLHostConfigCertificate;
import server.restful.common.Connectors;
import server.restful.common.IServletSystemProperties;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import server.restful.common.filters.RequestLogFilter;
import server.restful.common.log.DBAppender;
import server.restful.common.log.MonitoringThread;
import server.restful.common.rtmp.PlayerCleanupTimerTask;
import sidplay.Player;
import sidplay.player.DebugUtil;
import ui.entities.PersistenceProperties;
import ui.entities.config.Configuration;
import ui.entities.config.EmulationSection;
import ui.entities.config.service.ConfigService;

public final class JSIDPlay2Server {
    public static final String CONTEXT_ROOT = "";
    public static final String CONTEXT_ROOT_START_PAGE = "/";
    public static final String CONTEXT_ROOT_STATIC = "/static";
    public static final String CONTEXT_ROOT_WEBJARS = "/webjars";
    public static final String CONTEXT_ROOT_SERVLET = "/jsidplay2service/JSIDPlay2REST";
    public static final String ROLE_USER = "user";
    public static final String ROLE_ADMIN = "admin";
    public static final String SERVLET_UTIL_CONFIG_FILE = "directoryServlet.properties";
    public static final String REALM_NAME = "jsidplay2-realm";
    public static final String REALM_CONFIG = "tomcat-users.xml";
    private static final URL INTERNAL_REALM_CONFIG;
    private static final URL SERVLET_CLASSES_LIST;
    private static final URL FILTER_CLASSES_LIST;
    private static JSIDPlay2Server INSTANCE;
    private static EntityManagerFactory ENTITY_MANAGER_FACTORY;
    private static EntityManagerFactory DEBUG_ENTITY_MANAGER_FACTORY;
    private static final Map<Class<?>, Object> CDI;
    private static final ThreadLocal<EntityManager> THREAD_LOCAL_ENTITY_MANAGER;
    private static final ThreadLocal<EntityManager> THREAD_LOCAL_DEBUG_ENTITY_MANAGER;
    private static final ConfigService.ConfigurationType CONFIGURATION_TYPE;
    private JSIDPlay2ServerParameters parameters = new JSIDPlay2ServerParameters();
    private Tomcat tomcat;
    private Timer timer;

    private JSIDPlay2Server() {
    }

    public static synchronized JSIDPlay2Server getInstance(Configuration configuration) {
        if (INSTANCE == null) {
            INSTANCE = JSIDPlay2Server.create(configuration);
        }
        return INSTANCE;
    }

    private static JSIDPlay2Server create(Configuration configuration) {
        JSIDPlay2Server result = new JSIDPlay2Server();
        result.parameters.configuration = configuration;
        CDI.put(MonitoringThread.class, new MonitoringThread(IServletSystemProperties.JSIDPlay2Server.MONITORING_THREAD_REFRESH_INTERVAL));
        CDI.put(Configuration.class, configuration);
        CDI.put(Properties.class, result.getServletUtilProperties());
        File hvsc = configuration.getSidplay2Section().getHvsc();
        if (hvsc != null) {
            try {
                CDI.put(SidDatabase.class, new SidDatabase(hvsc));
                CDI.put(STIL.class, new STIL(hvsc));
            }
            catch (IOException | IllegalAccessException | NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        Player.initializeTmpDir(configuration);
        return result;
    }

    public synchronized void start() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, LifecycleException, ClassNotFoundException, IOException {
        if (this.tomcat == null) {
            this.tomcat = this.createTomcat();
            this.tomcat.start();
        }
    }

    public synchronized void stop() throws LifecycleException, InterruptedException {
        Optional.ofNullable(this.timer).ifPresent(Timer::cancel);
        Optional.ofNullable((MonitoringThread)CDI.get(MonitoringThread.class)).ifPresent(MonitoringThread::stopMonitor);
        if (this.tomcat != null && this.tomcat.getServer().getState() != LifecycleState.STOPPING_PREP && this.tomcat.getServer().getState() != LifecycleState.STOPPING && this.tomcat.getServer().getState() != LifecycleState.STOPPED && this.tomcat.getServer().getState() != LifecycleState.DESTROYING && this.tomcat.getServer().getState() != LifecycleState.DESTROYED) {
            try {
                this.tomcat.stop();
                this.tomcat.getServer().await();
                this.tomcat.getServer().destroy();
            }
            finally {
                this.tomcat = null;
                this.timer = null;
            }
        }
    }

    private Properties getServletUtilProperties() {
        Properties result = new Properties();
        for (String dir : new String[]{System.getProperty("user.dir"), System.getProperty("user.home")}) {
            try (FileInputStream is = new FileInputStream(new File(dir, SERVLET_UTIL_CONFIG_FILE));){
                result.load(is);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return result;
    }

    private Tomcat createTomcat() throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, ClassNotFoundException, IOException {
        Tomcat tomcat = new Tomcat();
        tomcat.setBaseDir(this.parameters.configuration.getSidplay2Section().getTmpDir().getAbsolutePath());
        this.setRealm(tomcat);
        this.setConnectors(tomcat);
        Context context = this.addContext(tomcat);
        List<Servlet> servlets = this.addServlets(context);
        this.addServletFilters(context, servlets);
        this.addServletSecurity(context, servlets);
        this.timer = new Timer();
        this.timer.schedule((TimerTask)new PlayerCleanupTimerTask(context), 0L, 1000L);
        return tomcat;
    }

    private void setRealm(Tomcat tomcat) throws MalformedURLException {
        MemoryRealm realm = new MemoryRealm();
        realm.setPathname(this.getRealmConfigURL().toExternalForm());
        tomcat.getEngine().setRealm((Realm)realm);
    }

    private URL getRealmConfigURL() throws MalformedURLException {
        for (String dir : new String[]{System.getProperty("user.dir"), System.getProperty("user.home")}) {
            File configPlace = new File(dir, REALM_CONFIG);
            if (!configPlace.exists()) continue;
            return configPlace.toURI().toURL();
        }
        return INTERNAL_REALM_CONFIG;
    }

    private void setConnectors(Tomcat tomcat) {
        EmulationSection emulationSection = this.parameters.configuration.getEmulationSection();
        switch (emulationSection.getAppServerConnectors()) {
            case HTTP_HTTPS: {
                tomcat.setConnector(this.createHttpConnector(emulationSection));
                tomcat.setConnector(this.createHttpsConnector(emulationSection));
                break;
            }
            case HTTPS: {
                tomcat.setConnector(this.createHttpsConnector(emulationSection));
                break;
            }
            default: {
                tomcat.setConnector(this.createHttpConnector(emulationSection));
            }
        }
    }

    private Connector createHttpConnector(EmulationSection emulationSection) {
        Connector httpConnector = new Connector(Http11Nio2Protocol.class.getName());
        httpConnector.setURIEncoding(StandardCharsets.UTF_8.name());
        httpConnector.setScheme(Connectors.HTTP.getPreferredProtocol());
        httpConnector.setPort(emulationSection.getAppServerPort());
        Http11Nio2Protocol protocol = (Http11Nio2Protocol)httpConnector.getProtocolHandler();
        protocol.setConnectionTimeout(IServletSystemProperties.JSIDPlay2Server.CONNECTION_TIMEOUT);
        protocol.setCompression(IServletSystemProperties.JSIDPlay2Server.COMPRESSION);
        return httpConnector;
    }

    private Connector createHttpsConnector(EmulationSection emulationSection) {
        Connector httpsConnector = new Connector(Http11Nio2Protocol.class.getName());
        httpsConnector.setURIEncoding(StandardCharsets.UTF_8.name());
        httpsConnector.setScheme(Connectors.HTTPS.getPreferredProtocol());
        httpsConnector.setPort(emulationSection.getAppServerSecurePort());
        httpsConnector.setSecure(true);
        if (IServletSystemProperties.JSIDPlay2Server.USE_HTTP2) {
            Http2Protocol h2 = new Http2Protocol();
            h2.setReadTimeout((long)IServletSystemProperties.JSIDPlay2Server.HTTP2_READ_TIMEOUT);
            h2.setWriteTimeout((long)IServletSystemProperties.JSIDPlay2Server.HTTP2_WRITE_TIMEOUT);
            h2.setKeepAliveTimeout((long)IServletSystemProperties.JSIDPlay2Server.HTTP2_KEEP_ALIVE_TIMEOUT);
            h2.setUseSendfile(IServletSystemProperties.JSIDPlay2Server.HTTP2_USE_SENDFILE);
            h2.setOverheadCountFactor(IServletSystemProperties.JSIDPlay2Server.HTTP2_OVERHEAD_COUNT_FACTOR);
            h2.setOverheadDataThreshold(IServletSystemProperties.JSIDPlay2Server.HTTP2_OVERHEAD_DATA_THRESHOLD);
            h2.setOverheadWindowUpdateThreshold(IServletSystemProperties.JSIDPlay2Server.HTTP2_OVERHEAD_WINDOW_UPDATE_THRESHOLD);
            httpsConnector.addUpgradeProtocol((UpgradeProtocol)h2);
        }
        Http11Nio2Protocol protocol = (Http11Nio2Protocol)httpsConnector.getProtocolHandler();
        protocol.setConnectionTimeout(IServletSystemProperties.JSIDPlay2Server.CONNECTION_TIMEOUT);
        protocol.setCompression(IServletSystemProperties.JSIDPlay2Server.COMPRESSION);
        protocol.setSSLEnabled(true);
        SSLHostConfig sslHostConfig = new SSLHostConfig();
        SSLHostConfigCertificate certificate = new SSLHostConfigCertificate(sslHostConfig, SSLHostConfigCertificate.Type.RSA);
        certificate.setCertificateKeystoreType(KeyStore.getDefaultType());
        certificate.setCertificateKeystoreFile(emulationSection.getAppServerKeystoreFile().getAbsolutePath());
        certificate.setCertificateKeystorePassword(emulationSection.getAppServerKeystorePassword());
        certificate.setCertificateKeyAlias(emulationSection.getAppServerKeyAlias());
        certificate.setCertificateKeyPassword(emulationSection.getAppServerKeyPassword());
        sslHostConfig.addCertificate(certificate);
        httpsConnector.addSslHostConfig(sslHostConfig);
        return httpsConnector;
    }

    private Context addContext(Tomcat tomcat) {
        return tomcat.addContext(tomcat.getHost(), CONTEXT_ROOT, tomcat.getServer().getCatalinaBase().getAbsolutePath());
    }

    private List<Servlet> addServlets(Context context) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, IOException, ClassNotFoundException {
        ArrayList<Servlet> result = new ArrayList<Servlet>();
        try (InputStream is = SERVLET_CLASSES_LIST.openStream();){
            List classNames = (List)new ObjectMapper().readerForListOf(String.class).with((FormatFeature)JsonReadFeature.ALLOW_JAVA_COMMENTS).readValue(is);
            for (String clzName : classNames) {
                Class<?> servletCls = Class.forName(clzName);
                WebServlet webServlet = servletCls.getAnnotation(WebServlet.class);
                MultipartConfig multipartConfig = servletCls.getAnnotation(MultipartConfig.class);
                Servlet servlet = (Servlet)servletCls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                this.inject(servletCls, servlet);
                Wrapper wrapper = Tomcat.addServlet((Context)context, (String)webServlet.name(), (Servlet)servlet);
                wrapper.setMultipartConfigElement(multipartConfig != null ? this.createMultipartConfigElement(webServlet, multipartConfig) : null);
                Stream.of(webServlet.urlPatterns()).forEach(arg_0 -> ((Wrapper)wrapper).addMapping(arg_0));
                result.add(servlet);
            }
        }
        return result;
    }

    private void inject(Class<?> cls, Object obj) throws IllegalAccessException {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Class<?> clazz = cls; clazz != Object.class; clazz = clazz.getSuperclass()) {
            fields.addAll(Arrays.asList(clazz.getDeclaredFields()));
        }
        for (Field field : fields) {
            if (field.getAnnotation(Inject.class) == null) continue;
            field.setAccessible(true);
            field.set(obj, CDI.get(field.getType()));
        }
    }

    private MultipartConfigElement createMultipartConfigElement(WebServlet webServlet, MultipartConfig multipartConfig) {
        String servletName = webServlet.name().toLowerCase(Locale.US);
        long maxRequestSize = Long.parseLong(System.getProperty("jsidplay2." + servletName + ".max.request.size", String.valueOf(multipartConfig.maxRequestSize())));
        long maxFileSize = Long.parseLong(System.getProperty("jsidplay2." + servletName + ".max.file.size", String.valueOf(multipartConfig.maxFileSize())));
        int fileSizeThreshold = Integer.parseInt(System.getProperty("jsidplay2." + servletName + ".file.size.threshold", String.valueOf(multipartConfig.fileSizeThreshold())));
        return new MultipartConfigElement(multipartConfig.location(), maxFileSize, maxRequestSize, fileSizeThreshold);
    }

    private void addServletFilters(Context context, List<Servlet> servlets) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException, IOException, ClassNotFoundException {
        try (InputStream is = FILTER_CLASSES_LIST.openStream();){
            List classNames = (List)new ObjectMapper().readerForListOf(String.class).with((FormatFeature)JsonReadFeature.ALLOW_JAVA_COMMENTS).readValue(is);
            for (String clzName : classNames) {
                Class<?> servletFilterCls = Class.forName(clzName);
                WebFilter webFilter = servletFilterCls.getAnnotation(WebFilter.class);
                for (Servlet servlet : servlets) {
                    WebServlet webServlet = servlet.getClass().getAnnotation(WebServlet.class);
                    if (!Arrays.asList(webFilter.servletNames()).contains(webServlet.name())) continue;
                    HttpFilter servletFilter = (HttpFilter)servletFilterCls.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    this.inject(servletFilterCls, servletFilter);
                    String filterName = webFilter.filterName() + "_" + webServlet.name();
                    FilterDef filterDefinition = new FilterDef();
                    filterDefinition.setFilterClass(servletFilterCls.getName());
                    filterDefinition.setFilterName(filterName);
                    filterDefinition.setFilter((Filter)servletFilter);
                    filterDefinition.getParameterMap().putAll(this.getFilterParameters(servletFilter, servlet));
                    context.addFilterDef(filterDefinition);
                    FilterMap filterMapping = new FilterMap();
                    filterMapping.setFilterName(filterName);
                    filterMapping.addServletName(webServlet.name());
                    context.addFilterMap(filterMapping);
                }
                if (Arrays.asList(webFilter.servletNames()).stream().allMatch(servletName -> Arrays.asList(context.findFilterMaps()).stream().anyMatch(map -> Arrays.asList(map.getServletNames()).contains(servletName)))) continue;
                throw new RuntimeException(String.format("Unknown servlet name in filter! filterName=%s, servletNames=%s", webFilter.filterName(), Arrays.asList(webFilter.servletNames()).stream().collect(Collectors.joining(","))));
            }
        }
    }

    private Map<String, String> getFilterParameters(HttpFilter servletFilter, Servlet servlet) {
        HashMap<String, String> result = new HashMap<String, String>();
        Class<?> servletFilterClz = servletFilter.getClass();
        if (servlet instanceof JSIDPlay2Servlet) {
            Optional.ofNullable(((JSIDPlay2Servlet)servlet).getServletFiltersParameterMap().get(servletFilterClz)).ifPresent(result::putAll);
        }
        if (RequestLogFilter.class.equals(servletFilterClz)) {
            result.put("servletName", servlet.getClass().getSimpleName());
        }
        return result;
    }

    private void addServletSecurity(Context context, List<Servlet> servlets) {
        context.addSecurityRole(ROLE_ADMIN);
        context.addSecurityRole(ROLE_USER);
        servlets.forEach(servlet -> {
            WebServlet webServlet = servlet.getClass().getAnnotation(WebServlet.class);
            ServletSecurity servletSecurity = servlet.getClass().getAnnotation(ServletSecurity.class);
            if (ServletUtil.isSecured(servletSecurity)) {
                SecurityCollection securityCollection = new SecurityCollection();
                Stream.of(webServlet.urlPatterns()).forEach(arg_0 -> ((SecurityCollection)securityCollection).addPattern(arg_0));
                SecurityConstraint securityConstraint = new SecurityConstraint();
                Stream.of(servletSecurity.value().rolesAllowed()).forEach(arg_0 -> ((SecurityConstraint)securityConstraint).addAuthRole(arg_0));
                securityConstraint.setAuthConstraint(true);
                securityConstraint.addCollection(securityCollection);
                context.addConstraint(securityConstraint);
                if (!Arrays.asList(servletSecurity.value().rolesAllowed()).stream().allMatch(arg_0 -> ((Context)context).findSecurityRole(arg_0))) {
                    throw new RuntimeException(String.format("Unknown role name in servlet! servletName=%s, roleNames=%s", webServlet.name(), Arrays.asList(servletSecurity.value().rolesAllowed()).stream().collect(Collectors.joining(","))));
                }
            }
        });
        context.getPipeline().addValve((Valve)new BasicAuthenticator());
        context.setLoginConfig(new LoginConfig("BASIC", REALM_NAME, null, null));
    }

    private static void exit(int rc) {
        try {
            if (ENTITY_MANAGER_FACTORY != null && ENTITY_MANAGER_FACTORY.isOpen()) {
                ENTITY_MANAGER_FACTORY.close();
            }
            if (DEBUG_ENTITY_MANAGER_FACTORY != null && DEBUG_ENTITY_MANAGER_FACTORY.isOpen()) {
                DEBUG_ENTITY_MANAGER_FACTORY.close();
            }
            System.out.println("Press <enter> to exit the player!");
            System.in.read();
            System.exit(rc);
        }
        catch (IOException | IllegalStateException e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static void main(String[] args) {
        try {
            JSIDPlay2Server jsidplay2Server = JSIDPlay2Server.getInstance(new ConfigService(CONFIGURATION_TYPE).load());
            JCommander commander = JCommander.newBuilder().addObject((Object)jsidplay2Server.parameters).programName(JSIDPlay2Server.class.getName()).build();
            commander.parse(args);
            if (jsidplay2Server.parameters.help.booleanValue()) {
                commander.usage();
                JSIDPlay2Server.exit(0);
            }
            if (jsidplay2Server.parameters.whatsSidDatabaseDriver != null) {
                PersistenceProperties persistenceProperties = new PersistenceProperties(jsidplay2Server.parameters.whatsSidDatabaseDriver, jsidplay2Server.parameters.whatsSidDatabaseUrl, jsidplay2Server.parameters.whatsSidDatabaseUsername, jsidplay2Server.parameters.whatsSidDatabasePassword, jsidplay2Server.parameters.whatsSidDatabaseDialect);
                ENTITY_MANAGER_FACTORY = Persistence.createEntityManagerFactory((String)"whatssid-ds", (Map)persistenceProperties);
                DEBUG_ENTITY_MANAGER_FACTORY = Persistence.createEntityManagerFactory((String)"debug-ds", (Map)persistenceProperties);
                JSIDPlay2Server.addDatabaseAppender();
            }
            jsidplay2Server.start();
        }
        catch (ParameterException | IOException | ClassNotFoundException | IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException | LifecycleException e) {
            e.printStackTrace();
            JSIDPlay2Server.exit(1);
        }
    }

    private static void addDatabaseAppender() {
        Logger rootLogger = LogManager.getLogManager().getLogger(CONTEXT_ROOT);
        rootLogger.addHandler(new DBAppender());
        Arrays.asList(rootLogger.getHandlers()).stream().filter(handler -> handler.getClass().isAssignableFrom(ConsoleHandler.class) || handler.getClass().isAssignableFrom(FileHandler.class)).forEach(rootLogger::removeHandler);
    }

    public static EntityManager getEntityManager() throws IOException {
        return JSIDPlay2Server.getEntityManager(ENTITY_MANAGER_FACTORY, THREAD_LOCAL_ENTITY_MANAGER);
    }

    public static void freeEntityManager() {
        JSIDPlay2Server.freeEntityManager(THREAD_LOCAL_ENTITY_MANAGER);
    }

    public static EntityManager getDebugEntityManager() throws IOException {
        return JSIDPlay2Server.getEntityManager(DEBUG_ENTITY_MANAGER_FACTORY, THREAD_LOCAL_DEBUG_ENTITY_MANAGER);
    }

    public static void freeDebugEntityManager() {
        JSIDPlay2Server.freeEntityManager(THREAD_LOCAL_DEBUG_ENTITY_MANAGER);
    }

    private static EntityManager getEntityManager(EntityManagerFactory entityManagerFactory, ThreadLocal<EntityManager> threadLocalEntityManager) throws IOException {
        if (entityManagerFactory == null) {
            throw new IOException("Database required, please specify command line parameters!");
        }
        EntityManager em = threadLocalEntityManager.get();
        if (em == null) {
            em = entityManagerFactory.createEntityManager();
            threadLocalEntityManager.set(em);
        }
        return em;
    }

    private static void freeEntityManager(ThreadLocal<EntityManager> threadLocalEntityManager) {
        EntityManager em = threadLocalEntityManager.get();
        if (em != null) {
            em.clear();
        }
    }

    static {
        DebugUtil.init();
        INTERNAL_REALM_CONFIG = JSIDPlay2Server.class.getResource("/tomcat-users.xml");
        SERVLET_CLASSES_LIST = JSIDPlay2Server.class.getResource("/tomcat-servlets.list");
        FILTER_CLASSES_LIST = JSIDPlay2Server.class.getResource("/tomcat-filters.list");
        CDI = new HashMap();
        THREAD_LOCAL_ENTITY_MANAGER = new ThreadLocal();
        THREAD_LOCAL_DEBUG_ENTITY_MANAGER = new ThreadLocal();
        CONFIGURATION_TYPE = ConfigService.ConfigurationType.XML;
    }

    @Parameters(resourceBundle="server.restful.JSIDPlay2ServerParameters")
    public static class JSIDPlay2ServerParameters {
        @Parameter(names={"--help", "-h"}, descriptionKey="USAGE", help=true, order=10000)
        private Boolean help = Boolean.FALSE;
        @Parameter(names={"--whatsSIDDatabaseDriver"}, descriptionKey="WHATSSID_DATABASE_DRIVER", order=10001)
        private String whatsSidDatabaseDriver;
        @Parameter(names={"--whatsSIDDatabaseUrl"}, descriptionKey="WHATSSID_DATABASE_URL", order=10002)
        private String whatsSidDatabaseUrl;
        @Parameter(names={"--whatsSIDDatabaseUsername"}, descriptionKey="WHATSSID_DATABASE_USERNAME", order=10003)
        private String whatsSidDatabaseUsername;
        @Parameter(names={"--whatsSIDDatabasePassword"}, descriptionKey="WHATSSID_DATABASE_PASSWORD", order=10004)
        private String whatsSidDatabasePassword;
        @Parameter(names={"--whatsSIDDatabaseDialect"}, descriptionKey="WHATSSID_DATABASE_DIALECT", order=10005)
        private String whatsSidDatabaseDialect;
        @ParametersDelegate
        private Configuration configuration;
    }
}

