/*
 * Decompiled with CFR 0.152.
 */
package server.restful.common.speech2text;

import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Optional;
import libsidutils.IOUtils;

public class AudioBuffer
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String ATTR_AUDIO_BUFFER = "AUDIO_BUFFER";
    private static final String HEADER_X_AUDIO_SEQ = "X-Audio-Seq";
    private transient ByteArrayOutputStream stream = new ByteArrayOutputStream();
    private byte[] serializedAudio;
    private Integer lastSequenceNumber;

    private AudioBuffer() {
    }

    public static AudioBuffer getOrCreateAudioBuffer(HttpSession session) {
        AudioBuffer buffer = (AudioBuffer)session.getAttribute(ATTR_AUDIO_BUFFER);
        if (buffer == null) {
            buffer = new AudioBuffer();
            session.setAttribute(ATTR_AUDIO_BUFFER, (Object)buffer);
        }
        return buffer;
    }

    public void append(HttpServletRequest request) throws IOException {
        Integer sequenceNumber = Optional.ofNullable(request.getHeader(HEADER_X_AUDIO_SEQ)).map(Integer::valueOf).orElse(null);
        if (sequenceNumber != null && this.lastSequenceNumber != null && sequenceNumber.compareTo(this.lastSequenceNumber) <= 0) {
            this.clear();
            throw new IllegalArgumentException("Incoming requests in wrong order? Command is ignored!");
        }
        try (ServletInputStream input = request.getInputStream();){
            IOUtils.copy((InputStream)input, this.stream);
        }
        this.lastSequenceNumber = sequenceNumber;
    }

    public void sliceEnd(int maxSize) throws IOException {
        if (this.size() > maxSize) {
            byte[] bytes = this.getBytesAt(this.size() - maxSize);
            this.stream = new ByteArrayOutputStream();
            this.stream.write(bytes);
        }
    }

    public byte[] getBytesAt(int startOffset) {
        return Arrays.copyOfRange(this.stream.toByteArray(), startOffset, this.size());
    }

    public int size() {
        return this.stream.size();
    }

    public void clear() {
        this.stream = new ByteArrayOutputStream();
        this.lastSequenceNumber = null;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.serializedAudio = this.stream.toByteArray();
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.stream = new ByteArrayOutputStream();
        if (this.serializedAudio != null) {
            this.stream.write(this.serializedAudio);
        }
    }
}

