/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.beust.jcommander.ParametersDelegate;
import com.google.zxing.WriterException;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.imageio.ImageIO;
import javax.xml.bind.DatatypeConverter;
import libsidplay.common.Engine;
import libsidplay.components.cart.CartridgeType;
import libsidplay.components.mos656x.PALEmulation;
import libsidplay.config.IC1541Section;
import libsidplay.config.IEmulationSection;
import libsidplay.config.ISidPlay2Section;
import libsidplay.sidtune.SidTune;
import libsidplay.sidtune.SidTuneError;
import libsidutils.IOUtils;
import libsidutils.ZipFileUtils;
import server.restful.common.ContentTypeAndFileExtensions;
import server.restful.common.IServletSystemProperties;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.QrCode;
import server.restful.common.ServletUtil;
import server.restful.common.async.DefaultThreadFactory;
import server.restful.common.async.HttpAsyncContextRunnable;
import server.restful.common.converter.LocaleConverter;
import server.restful.common.converter.WebResourceConverter;
import server.restful.common.filters.HeadRequestFilter;
import server.restful.common.filters.RTMPBasedRateLimiterFilter;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.requestpath.FileRequestPathServletParameters;
import server.restful.common.rtmp.HlsType;
import server.restful.common.rtmp.PlayerCleanupTimerTask;
import server.restful.common.text2speech.TextToSpeech;
import server.restful.common.text2speech.TextToSpeechBean;
import server.restful.common.text2speech.TextToSpeechType;
import sidplay.Player;
import sidplay.audio.AACDriver;
import sidplay.audio.AVIDriver;
import sidplay.audio.Audio;
import sidplay.audio.AudioDriver;
import sidplay.audio.FLACDriver;
import sidplay.audio.FLVDriver;
import sidplay.audio.JWAVDriver;
import sidplay.audio.MP3Driver;
import sidplay.audio.MP4Driver;
import sidplay.audio.ProxyDriver;
import sidplay.audio.SIDDumpDriver;
import sidplay.audio.SIDRegDriver;
import sidplay.audio.ThrottlingDriver;
import sidplay.ini.IniConfig;
import ui.common.Convenience;
import ui.common.ConvenienceResult;
import ui.common.util.InternetUtil;

@WebServlet(name="ConvertServlet", displayName="ConvertServlet", asyncSupported=true, urlPatterns={"/jsidplay2service/JSIDPlay2REST/convert/*"}, description="Stream e.g. SID as MP3 or D64 as MP3 or RTMP video stream")
@ServletSecurity(value=@HttpConstraint(rolesAllowed={}))
public class ConvertServlet
extends JSIDPlay2Servlet {
    private ExecutorService executorService;

    public void init() throws ServletException {
        this.executorService = Executors.newFixedThreadPool(IServletSystemProperties.ConvertServlet.MAX_CONVERT_IN_PARALLEL, new DefaultThreadFactory("/convert"));
    }

    public void destroy() {
        this.executorService.shutdown();
    }

    @Override
    public Map<Class<? extends HttpFilter>, Map<String, String>> getServletFiltersParameterMap() {
        HashMap<Class<? extends HttpFilter>, Map<String, String>> result = new HashMap<Class<? extends HttpFilter>, Map<String, String>>();
        HashMap<String, String> headRequestFilterParameters = new HashMap<String, String>();
        headRequestFilterParameters.put("contentType", ContentTypeAndFileExtensions.MIME_TYPE_MPEG.getMimeType());
        result.put(HeadRequestFilter.class, headRequestFilterParameters);
        HashMap<String, String> rtmpBasedRateLimiterFilterParameters = new HashMap<String, String>();
        rtmpBasedRateLimiterFilterParameters.put("maxRtmpPerServlet", String.valueOf(IServletSystemProperties.ConvertServlet.MAX_CONVERT_RTMP_IN_PARALLEL));
        result.put(RTMPBasedRateLimiterFilter.class, rtmpBasedRateLimiterFilterParameters);
        return result;
    }

    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        asyncContext.setTimeout((long)IServletSystemProperties.ConvertServlet.CONVERT_ASYNC_TIMEOUT);
        this.executorService.execute(new HttpAsyncContextRunnable(asyncContext, this.getServletContext()){

            @Override
            public void run(HttpServletRequest request, HttpServletResponse response) throws IOException {
                block17: {
                    try {
                        ConvertServletParameters servletParameters = new ConvertServletParameters();
                        ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
                        File file = servletParameters.fetchFile(ConvertServlet.this.configuration, ConvertServlet.this.directoryProperties, parser, ConvertServlet.this.hasAdminAccess(request));
                        if (file == null || servletParameters.getHelp().booleanValue() || parser.hasException()) {
                            parser.usage();
                            return;
                        }
                        if ((JSIDPlay2Servlet.AUDIO_TUNE_FILE_FILTER.accept(file) || servletParameters.getVideoTuneAsAudio().booleanValue() && JSIDPlay2Servlet.VIDEO_TUNE_FILE_FILTER.accept(file)) && !servletParameters.getAudioTuneAsVideo().booleanValue()) {
                            AudioDriver driver = this.getAudioDriverOfAudioFormat(response, servletParameters);
                            if (Boolean.TRUE.equals(servletParameters.getDownload())) {
                                response.addHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode(this.getAttachmentFilename(file, driver), StandardCharsets.UTF_8.name()));
                            }
                            response.setContentType(ContentTypeAndFileExtensions.getMimeType(driver.getExtension()).toString());
                            this.convert2audio(file, driver, servletParameters);
                            break block17;
                        }
                        if (JSIDPlay2Servlet.VIDEO_TUNE_FILE_FILTER.accept(file) || JSIDPlay2Servlet.DISK_FILE_FILTER.accept(file) || JSIDPlay2Servlet.TAPE_FILE_FILTER.accept(file) || JSIDPlay2Servlet.CART_FILE_FILTER.accept(file) || JSIDPlay2Servlet.AUDIO_TUNE_FILE_FILTER.accept(file)) {
                            UUID uuid = UUID.randomUUID();
                            AudioDriver driver = this.getAudioDriverOfVideoFormat(uuid, servletParameters);
                            if (Boolean.FALSE.equals(servletParameters.getDownload()) && driver.lookup(FLVDriver.FLVStreamDriver.class).isPresent()) {
                                Thread poolThread = Thread.currentThread();
                                new Thread(() -> {
                                    try {
                                        this.convert2video(file, driver, servletParameters, uuid, this.parentThread, poolThread);
                                    }
                                    catch (IOException | SidTuneError e) {
                                        ServletUtil.error(ConvertServlet.this.getServletContext(), e, this.parentThread);
                                    }
                                }, "RTMP").start();
                                this.waitUntilVideoIsAvailable(servletParameters, uuid);
                                response.setHeader("Cache-Control", IServletSystemProperties.JSIDPlay2Server.CACHE_CONTROL_RESPONSE_HEADER_UNCACHED);
                                try (InputStream is = new WebResourceConverter("<ServletPath>").convert("/convert.html");){
                                    if (!this.isComplete()) {
                                        ConvertServlet.this.setOutput(ContentTypeAndFileExtensions.MIME_TYPE_HTML, response, IOUtils.convertStreamToString(is, StandardCharsets.UTF_8, this.getReplacements(servletParameters, request, uuid)));
                                    }
                                    break block17;
                                }
                            }
                            if (Boolean.TRUE.equals(servletParameters.getDownload())) {
                                response.addHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode(this.getAttachmentFilename(file, driver), StandardCharsets.UTF_8.name()));
                            }
                            File videoFile = this.convert2video(file, driver, servletParameters, null, this.parentThread);
                            ContentTypeAndFileExtensions mimeType = ContentTypeAndFileExtensions.getMimeType(driver.getExtension());
                            if (!this.isComplete()) {
                                response.setContentLength((int)videoFile.length());
                                ConvertServlet.this.setOutput(mimeType, response, ZipFileUtils.newFileInputStream(videoFile));
                            }
                            videoFile.delete();
                            break block17;
                        }
                        if (!this.isComplete()) {
                            response.addHeader("Content-disposition", "attachment; filename=" + URLEncoder.encode(file.getName(), StandardCharsets.UTF_8.name()));
                            response.setContentLength((int)file.length());
                            ConvertServlet.this.setOutput(ContentTypeAndFileExtensions.getMimeType(IOUtils.getFilenameSuffix(file.getName())), response, ZipFileUtils.newFileInputStream(file));
                        }
                    }
                    catch (Throwable t) {
                        ServletUtil.error(ConvertServlet.this.getServletContext(), t, this.parentThread);
                        if (this.isComplete()) break block17;
                        response.setStatus(500);
                        ConvertServlet.this.setOutput(response, t);
                    }
                }
            }

            private String getAttachmentFilename(File file, AudioDriver driver) {
                return IOUtils.getFilenameWithoutSuffix(file.getName()) + driver.getExtension();
            }

            private AudioDriver getAudioDriverOfAudioFormat(HttpServletResponse response, ConvertServletParameters servletParameters) throws IOException {
                switch (Optional.ofNullable(servletParameters.getConfig().getAudioSection().getAudio()).orElse(Audio.MP3)) {
                    case WAV: {
                        return this.wrapThrottlingDriver(new JWAVDriver.JWAVStreamDriver((OutputStream)response.getOutputStream()), servletParameters);
                    }
                    case FLAC: {
                        return this.wrapThrottlingDriver(new FLACDriver.FLACStreamDriver((OutputStream)response.getOutputStream()), servletParameters);
                    }
                    case AAC: {
                        return this.wrapThrottlingDriver(new AACDriver.AACStreamDriver((OutputStream)response.getOutputStream()), servletParameters);
                    }
                    default: {
                        return this.wrapThrottlingDriver(new MP3Driver.MP3StreamDriver((OutputStream)response.getOutputStream()), servletParameters);
                    }
                    case SID_DUMP: {
                        return this.wrapThrottlingDriver(new SIDDumpDriver.SIDDumpStreamDriver((OutputStream)response.getOutputStream()), servletParameters);
                    }
                    case SID_REG: 
                }
                return this.wrapThrottlingDriver(new SIDRegDriver.SIDRegStreamDriver((OutputStream)response.getOutputStream(), servletParameters.getSidRegFormat()), servletParameters);
            }

            private void convert2audio(File file, AudioDriver driver, ConvertServletParameters servletParameters) throws IOException, SidTuneError {
                ServletUtil.info(ConvertServlet.this.getServletContext(), String.format("START file=%s", file.getAbsolutePath()), this.parentThread);
                ISidPlay2Section sidplay2Section = servletParameters.getConfig().getSidplay2Section();
                IEmulationSection emulationSection = servletParameters.getConfig().getEmulationSection();
                sidplay2Section.setHvsc(ConvertServlet.this.configuration.getSidplay2Section().getHvsc());
                emulationSection.setEngine(Engine.EMULATION);
                Player player = new Player(servletParameters.getConfig());
                player.getC64().getVIC().setPalEmulation(PALEmulation.NONE);
                player.setSidDatabase(ConvertServlet.this.sidDatabase);
                player.setSTIL(ConvertServlet.this.stil);
                if (Boolean.TRUE.equals(servletParameters.getDownload())) {
                    sidplay2Section.setDefaultPlayLength(Math.min(sidplay2Section.getDefaultPlayLength(), (double)IServletSystemProperties.ConvertServlet.MAX_AUD_DOWNLOAD_LENGTH));
                }
                if (IServletSystemProperties.ConvertServlet.TEXT_TO_SPEECH && servletParameters.getTextToSpeechType() != TextToSpeechType.NONE) {
                    player.setMenuHook(new TextToSpeech(servletParameters.getTextToSpeechType(), new TextToSpeechBean(file, player, this.getTextToSpeechLocale(servletParameters))));
                }
                Thread poolThread = Thread.currentThread();
                player.setAudioDriver(driver);
                player.setUncaughtExceptionHandler((thread, throwable) -> ServletUtil.uncaughtExceptionHandler(ConvertServlet.this.getServletContext(), throwable, thread, this.parentThread, poolThread));
                player.setCheckDefaultLengthInRecordMode(Boolean.TRUE.equals(servletParameters.getDownload()));
                player.setCheckLoopOffInRecordMode(Boolean.TRUE.equals(servletParameters.getDownload()));
                player.setForceCheckSongLength(Boolean.TRUE.equals(servletParameters.getDownload()));
                this.insertCartridge(servletParameters, player);
                SidTune tune = SidTune.load(file);
                tune.getInfo().setSelectedSong(servletParameters.getStartSong());
                player.play(tune);
                player.stopC64(false);
                ServletUtil.info(ConvertServlet.this.getServletContext(), String.format("END file=%s", file.getAbsolutePath()), this.parentThread);
            }

            private AudioDriver getAudioDriverOfVideoFormat(UUID uuid, ConvertServletParameters servletParameters) {
                switch (Optional.ofNullable(servletParameters.getConfig().getAudioSection().getAudio()).orElse(Audio.FLV)) {
                    default: {
                        if (Boolean.TRUE.equals(servletParameters.getDownload())) {
                            return new FLVDriver.FLVFileDriver();
                        }
                        return this.wrapThrottlingDriver(new FLVDriver.FLVStreamDriver(IServletSystemProperties.ConvertServlet.RTMP_UPLOAD_URL + "/" + uuid), servletParameters);
                    }
                    case AVI: {
                        return new AVIDriver.AVIFileDriver();
                    }
                    case MP4: 
                }
                return new MP4Driver.MP4FileDriver();
            }

            private File convert2video(File file, AudioDriver driver, ConvertServletParameters servletParameters, UUID uuid, Thread ... parentThreads) throws IOException, SidTuneError {
                ServletUtil.info(ConvertServlet.this.getServletContext(), String.format("START file=%s, uuid=%s", file.getAbsolutePath(), uuid), parentThreads);
                File videoFile = null;
                ISidPlay2Section sidplay2Section = servletParameters.getConfig().getSidplay2Section();
                IEmulationSection emulationSection = servletParameters.getConfig().getEmulationSection();
                IC1541Section c1541Section = servletParameters.getConfig().getC1541Section();
                emulationSection.setEngine(Engine.EMULATION);
                if (JSIDPlay2Servlet.TAPE_FILE_FILTER.accept(file)) {
                    c1541Section.setJiffyDosInstalled(false);
                }
                Player player = new Player(servletParameters.getConfig());
                if (Boolean.TRUE.equals(servletParameters.getDownload())) {
                    sidplay2Section.setDefaultPlayLength(Math.min(sidplay2Section.getDefaultPlayLength(), (double)IServletSystemProperties.ConvertServlet.MAX_VID_DOWNLOAD_LENGTH));
                    videoFile = this.createVideoFile(player, driver);
                } else {
                    sidplay2Section.setDefaultPlayLength(IServletSystemProperties.ConvertServlet.RTMP_EXCEEDS_MAXIMUM_DURATION);
                }
                player.setAudioDriver(driver);
                player.setUncaughtExceptionHandler((thread, throwable) -> ServletUtil.uncaughtExceptionHandler(ConvertServlet.this.getServletContext(), throwable, thread, parentThreads));
                player.setCheckDefaultLengthInRecordMode(Boolean.TRUE.equals(servletParameters.getDownload()));
                player.setCheckLoopOffInRecordMode(Boolean.TRUE.equals(servletParameters.getDownload()));
                player.setForceCheckSongLength(Boolean.TRUE.equals(servletParameters.getDownload()));
                ConvenienceResult convenienceResult = new Convenience(player).autostart(file, Convenience.LEXICALLY_FIRST_MEDIA, servletParameters.getAutostart(), true);
                if (!player.getC64().isCartridge()) {
                    this.insertCartridge(servletParameters, player);
                }
                if (uuid != null) {
                    PlayerCleanupTimerTask.create(uuid, player, file, convenienceResult, servletParameters);
                }
                player.stopC64(false);
                ServletUtil.info(ConvertServlet.this.getServletContext(), String.format("END file=%s, uuid=%s", file.getAbsolutePath(), uuid), parentThreads);
                return videoFile;
            }

            private AudioDriver wrapThrottlingDriver(AudioDriver audioDriver, ConvertServletParameters servletParameters) {
                if (Boolean.TRUE.equals(servletParameters.getDownload())) {
                    return audioDriver;
                }
                return new ProxyDriver(new ThrottlingDriver(), audioDriver);
            }

            private Locale getTextToSpeechLocale(ConvertServletParameters servletParameters) {
                return servletParameters.getTextToSpeechLocale() != null ? servletParameters.getTextToSpeechLocale() : servletParameters.getLocale();
            }

            private void insertCartridge(ConvertServletParameters servletParameters, Player player) throws IOException {
                if (servletParameters.getSfxSoundExpander().booleanValue()) {
                    player.insertCartridge(CartridgeType.SOUNDEXPANDER, servletParameters.getSfxSoundExpanderType());
                } else if (servletParameters.isREU() || servletParameters.getReuSize() != null) {
                    if (servletParameters.isREU()) {
                        player.insertCartridge(CartridgeType.REU, servletParameters.getReuSize() != null ? servletParameters.getReuSize() : 0);
                    } else if (servletParameters.getReuSize() > 0) {
                        player.insertCartridge(CartridgeType.REU, servletParameters.getReuSize());
                    }
                }
            }

            private File createVideoFile(Player player, AudioDriver driver) throws IOException {
                ISidPlay2Section sidplay2Section = player.getConfig().getSidplay2Section();
                File tmpDir = new File(sidplay2Section.getTmpDir(), UUID.randomUUID().toString());
                tmpDir.mkdir();
                File videoFile = File.createTempFile("jsidplay2video", driver.getExtension(), tmpDir);
                player.setRecordingFilenameProvider(tune -> IOUtils.getFilenameWithoutSuffix(videoFile.getAbsolutePath()));
                return videoFile;
            }

            private Map<String, String> getReplacements(ConvertServletParameters servletParameters, HttpServletRequest request, UUID uuid) throws IOException, WriterException, URISyntaxException {
                URI videoURI = this.getVideoURI(Boolean.TRUE.equals(servletParameters.getUseHls()), uuid);
                String qrCodeImgTag = this.createQrCodeImgTag(this.createShareWithURL(request), "UTF-8", "png", 320, 320);
                Map<String, String> replacements = ServletUtil.createReplacements(servletParameters.getUseDevTools());
                replacements.put("uuid", uuid.toString());
                replacements.put("qrCodeImgTag", qrCodeImgTag);
                replacements.put("videoUrl", videoURI.toString());
                replacements.put("hls", String.valueOf(Boolean.TRUE.equals(servletParameters.getUseHls())));
                replacements.put("hlsType", servletParameters.getHlsType().name());
                replacements.put("hlsScript", servletParameters.getHlsType().getScript());
                replacements.put("hlsStyle", servletParameters.getHlsType().getStyle());
                replacements.put("notYetPlayedTimeout", String.valueOf(IServletSystemProperties.ConvertServlet.RTMP_NOT_YET_PLAYED_TIMEOUT));
                replacements.put("notifyForHLS", String.valueOf(IServletSystemProperties.ConvertServlet.NOTIFY_FOR_HLS));
                return replacements;
            }

            private String createQrCodeImgTag(String data, String charset, String imgFormat, int width, int height) throws IOException, WriterException {
                try {
                    ByteArrayOutputStream qrCodeImgData = new ByteArrayOutputStream();
                    ImageIO.write((RenderedImage)QrCode.createBarCodeImage(data, charset, width, height), imgFormat, qrCodeImgData);
                    return String.format("<img src='data:image/%s;base64,%s'>", imgFormat, DatatypeConverter.printBase64Binary((byte[])qrCodeImgData.toByteArray()));
                }
                catch (WriterException e) {
                    return String.format("<img src='data:image/%s;base64,%s'>", imgFormat, DatatypeConverter.printBase64Binary((byte[])new byte[0]));
                }
            }

            private URI getVideoURI(boolean useHls, UUID uuid) throws URISyntaxException {
                if (useHls) {
                    return new URI(IServletSystemProperties.ConvertServlet.HLS_DOWNLOAD_URL + "/" + uuid + ".m3u8");
                }
                return new URI(IServletSystemProperties.ConvertServlet.RTMP_DOWNLOAD_URL + "/" + uuid);
            }

            private String createShareWithURL(HttpServletRequest request) {
                StringBuilder result = new StringBuilder(request.getRequestURL());
                if (request.getQueryString() != null) {
                    result.append("?").append(request.getQueryString());
                }
                return result.toString();
            }

            private void waitUntilVideoIsAvailable(ConvertServletParameters servletParameters, UUID uuid) throws InterruptedException, URISyntaxException, IOException {
                URL url = this.getVideoURI(true, uuid).toURL();
                int retryCount = 0;
                while (retryCount++ < IServletSystemProperties.ConvertServlet.WAIT_FOR_VIDEO_AVAILABLE_RETRY_COUNT) {
                    try {
                        InternetUtil.openConnection(url, ConvertServlet.this.configuration.getSidplay2Section());
                        Thread.sleep(1000L);
                        return;
                    }
                    catch (InterruptedException | SocketTimeoutException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        Thread.sleep(500L);
                    }
                }
                throw new IOException("Video is still not available, please retry later!");
            }
        });
    }

    @Parameters(resourceBundle="server.restful.servlets.ConvertServletParameters")
    public static class ConvertServletParameters
    extends FileRequestPathServletParameters {
        private Boolean useDevTools = Boolean.FALSE;
        private Integer startSong;
        private Locale locale = Locale.ROOT;
        private TextToSpeechType textToSpeechType = TextToSpeechType.PICO2WAVE;
        private Locale textToSpeechLocale;
        private Boolean download = Boolean.FALSE;
        private Integer reuSize = 0;
        private Boolean sfxSoundExpander = Boolean.FALSE;
        private Integer sfxSoundExpanderType = 0;
        private Integer pressSpaceInterval = IServletSystemProperties.ConvertServlet.PRESS_SPACE_INTERVALL;
        private Boolean showStatus = Boolean.TRUE;
        private Boolean useHls = Boolean.FALSE;
        private HlsType hlsType = HlsType.HLS_JS;
        private SIDRegDriver.Format sidRegFormat = SIDRegDriver.Format.APP;
        private String autostart;
        private Boolean videoTuneAsAudio = Boolean.FALSE;
        private Boolean audioTuneAsVideo = Boolean.FALSE;
        @ParametersDelegate
        private IniConfig config = new IniConfig();

        public Boolean getUseDevTools() {
            return this.useDevTools;
        }

        @Parameter(names={"--devtools"}, arity=1, descriptionKey="USE_DEV_TOOLS", hidden=true, order=-2147483645)
        public void setUseDevTools(Boolean useDevTools) {
            this.useDevTools = useDevTools;
        }

        public Integer getStartSong() {
            return this.startSong;
        }

        @Parameter(names={"--startSong"}, descriptionKey="START_SONG", order=-2147483644)
        public void setStartSong(Integer startSong) {
            this.startSong = startSong;
        }

        public Locale getLocale() {
            return this.locale;
        }

        @Parameter(names={"--locale"}, descriptionKey="LOCALE", converter=LocaleConverter.class, order=-2147483643)
        public void setLocale(Locale locale) {
            this.locale = locale;
        }

        public TextToSpeechType getTextToSpeechType() {
            return this.textToSpeechType;
        }

        @Parameter(names={"--textToSpeechType"}, arity=1, descriptionKey="TEXT_TO_SPEECH_TYPE", order=-2147483642)
        public void setTextToSpeechType(TextToSpeechType textToSpeechType) {
            this.textToSpeechType = textToSpeechType;
        }

        public Locale getTextToSpeechLocale() {
            return this.textToSpeechLocale;
        }

        @Parameter(names={"--textToSpeechLocale"}, descriptionKey="TEXT_TO_SPEECH_LOCALE", converter=LocaleConverter.class, order=-2147483641)
        public void setTextToSpeechLocale(Locale textToSpeechLocale) {
            this.textToSpeechLocale = textToSpeechLocale;
        }

        public Boolean getDownload() {
            return this.download;
        }

        @Parameter(names={"--download"}, arity=1, descriptionKey="DOWNLOAD", order=-2147483640)
        public void setDownload(Boolean download) {
            this.download = download;
        }

        public Integer getReuSize() {
            return this.reuSize;
        }

        @Parameter(names={"--reuSize"}, descriptionKey="REU_SIZE", order=-2147483639)
        public void setReuSize(Integer reuSize) {
            this.reuSize = reuSize;
        }

        public Boolean getSfxSoundExpander() {
            return this.sfxSoundExpander;
        }

        @Parameter(names={"--sfxSoundExpander"}, arity=1, descriptionKey="SFX_SOUND_EXPANDER", order=-2147483638)
        public void setSfxSoundExpander(Boolean sfxSoundExpander) {
            this.sfxSoundExpander = sfxSoundExpander;
        }

        public Integer getSfxSoundExpanderType() {
            return this.sfxSoundExpanderType;
        }

        @Parameter(names={"--sfxSoundExpanderType"}, descriptionKey="SFX_SOUND_EXPANDER_TYPE", order=-2147483637)
        public void setSfxSoundExpanderType(Integer sfxSoundExpanderType) {
            this.sfxSoundExpanderType = sfxSoundExpanderType;
        }

        public Integer getPressSpaceInterval() {
            return this.pressSpaceInterval;
        }

        @Parameter(names={"--pressSpaceInterval"}, descriptionKey="PRESS_SPACE_INTERVAL", order=-2147483636)
        public void setPressSpaceInterval(Integer pressSpaceInterval) {
            this.pressSpaceInterval = pressSpaceInterval;
        }

        public Boolean getShowStatus() {
            return this.showStatus;
        }

        @Parameter(names={"--status"}, arity=1, descriptionKey="STATUS", order=-2147483635)
        public void setShowStatus(Boolean showStatus) {
            this.showStatus = showStatus;
        }

        public Boolean getUseHls() {
            return this.useHls;
        }

        @Parameter(names={"--hls"}, arity=1, descriptionKey="HLS", order=-2147483634)
        public void setUseHls(Boolean useHls) {
            this.useHls = useHls;
        }

        public HlsType getHlsType() {
            return this.hlsType;
        }

        @Parameter(names={"--hlsType"}, descriptionKey="HLS_TYPE", order=-2147483633)
        public void setHlsType(HlsType hlsType) {
            this.hlsType = hlsType;
        }

        public SIDRegDriver.Format getSidRegFormat() {
            return this.sidRegFormat;
        }

        @Parameter(names={"--sidRegFormat"}, descriptionKey="SID_REG_FORMAT", order=-2147483632)
        public void setSidRegFormat(SIDRegDriver.Format sidRegFormat) {
            this.sidRegFormat = sidRegFormat;
        }

        public String getAutostart() {
            return this.autostart;
        }

        @Parameter(names={"--autostart"}, descriptionKey="AUTOSTART", order=-2147483631)
        public void setAutostart(String autostart) {
            this.autostart = autostart;
        }

        public Boolean getVideoTuneAsAudio() {
            return this.videoTuneAsAudio;
        }

        @Parameter(names={"--videoTuneAsAudio"}, arity=1, descriptionKey="VIDEO_TUNE_AS_AUDIO", order=-2147483630)
        public void setVideoTuneAsAudio(Boolean videoTuneAsAudio) {
            this.videoTuneAsAudio = videoTuneAsAudio;
        }

        public Boolean getAudioTuneAsVideo() {
            return this.audioTuneAsVideo;
        }

        @Parameter(names={"--audioTuneAsVideo"}, arity=1, descriptionKey="AUDIO_TUNE_AS_VIDEO", order=-2147483629)
        public void setAudioTuneAsVideo(Boolean audioTuneAsVideo) {
            this.audioTuneAsVideo = audioTuneAsVideo;
        }

        public IniConfig getConfig() {
            return this.config;
        }

        public void setConfig(IniConfig config) {
            this.config = config;
        }
    }
}

