/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.List;
import server.restful.JSIDPlay2Server;
import server.restful.common.ContentTypeAndFileExtensions;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.Order;
import server.restful.common.ServletUtil;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.requestparam.LogRequestParamServletParameters;
import server.restful.common.validator.MaxResultsValidator;
import ui.entities.debug.DebugEntry;
import ui.entities.debug.service.DebugService;

@WebServlet(name="LogsServlet", displayName="LogsServlet", urlPatterns={"/jsidplay2service/JSIDPlay2REST/logs"}, description="Get log message list")
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"admin"}))
public class LogsServlet
extends JSIDPlay2Servlet {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            LogsServletParameters servletParameters = new LogsServletParameters();
            ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
            if (servletParameters.getHelp().booleanValue() || parser.hasException()) {
                parser.usage();
                return;
            }
            Long instant = servletParameters.getInstant();
            String sourceClassName = servletParameters.getSourceClassName();
            String sourceMethodName = servletParameters.getSourceMethodName();
            String level = servletParameters.getLevel();
            String message = servletParameters.getMessage();
            Integer maxResults = servletParameters.getMaxResults();
            Order order = servletParameters.getOrder();
            Boolean tooMuchLogging = servletParameters.getTooMuchLogging();
            DebugService debugService = new DebugService(JSIDPlay2Server.getDebugEntityManager());
            List<DebugEntry> result = debugService.findDebugEntries(instant, sourceClassName, sourceMethodName, level, message, maxResults, order, tooMuchLogging);
            this.setOutput(ContentTypeAndFileExtensions.MIME_TYPE_JSON, response, result);
        }
        catch (Throwable t) {
            response.setStatus(500);
            ServletUtil.error(this.getServletContext(), t, new Thread[0]);
            this.setOutput(response, t);
        }
        finally {
            JSIDPlay2Server.freeDebugEntityManager();
        }
    }

    @Parameters(resourceBundle="server.restful.servlets.LogsServletParameters")
    public static class LogsServletParameters
    extends LogRequestParamServletParameters {
        private Integer maxResults = 100;

        public Integer getMaxResults() {
            return this.maxResults;
        }

        @Parameter(names={"--maxResults"}, descriptionKey="MAX_RESULTS", required=true, validateWith={MaxResultsValidator.class}, order=-2147483640)
        public void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }
    }
}

