/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.servlet.AsyncContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpFilter;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import libsidutils.IOUtils;
import org.vosk.LibVosk;
import org.vosk.LogLevel;
import org.vosk.Model;
import org.vosk.Recognizer;
import server.restful.common.IServletSystemProperties;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import server.restful.common.SessionLockManager;
import server.restful.common.async.DefaultThreadFactory;
import server.restful.common.async.HttpAsyncContextRunnable;
import server.restful.common.converter.LocaleConverter;
import server.restful.common.filters.CounterBasedRateLimiterFilter;
import server.restful.common.parameter.RequestResponseBodyParameter;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.UsageParameter;
import server.restful.common.processor.ExternalProcess;
import server.restful.common.speech2text.AudioBuffer;
import server.restful.common.speech2text.DeepFilterParameters;
import sidplay.audio.wav.WAVHeader;
import ui.entities.config.SidPlay2Section;

@WebServlet(name="SpeechToTextServlet", displayName="SpeechToTextServlet", asyncSupported=true, urlPatterns={"/jsidplay2service/JSIDPlay2REST/speech2text"}, description="Speech recognition")
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"user", "admin"}))
public class SpeechToTextServlet
extends JSIDPlay2Servlet {
    private ExecutorService executorService;
    private Model modelDe;
    private Model modelEn;
    private File deepFilterOutputDir;

    public void init() throws ServletException {
        this.executorService = new ThreadPoolExecutor(IServletSystemProperties.SpeechToTextServlet.MAX_SPEECHTOTEXT_IN_PARALLEL_CORE, IServletSystemProperties.SpeechToTextServlet.MAX_SPEECHTOTEXT_IN_PARALLEL, IServletSystemProperties.SpeechToTextServlet.SPEECHTOTEXT_KEEPALIVE_TIME, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(IServletSystemProperties.SpeechToTextServlet.SPEECHTOTEXT_QUEUE_SIZE), new DefaultThreadFactory("/speechtotext"), new ThreadPoolExecutor.AbortPolicy());
        try {
            LibVosk.setLogLevel((LogLevel)LogLevel.WARNINGS);
            this.modelDe = new Model(IServletSystemProperties.SpeechToTextServlet.SPEECHTOTEXT_MODEL_DE);
            this.modelEn = new Model(IServletSystemProperties.SpeechToTextServlet.SPEECHTOTEXT_MODEL_EN);
            SidPlay2Section sidplay2Section = this.configuration.getSidplay2Section();
            this.deepFilterOutputDir = new File(sidplay2Section.getTmpDir(), UUID.randomUUID().toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void destroy() {
        this.executorService.shutdown();
    }

    @Override
    public Map<Class<? extends HttpFilter>, Map<String, String>> getServletFiltersParameterMap() {
        HashMap<Class<? extends HttpFilter>, Map<String, String>> result = new HashMap<Class<? extends HttpFilter>, Map<String, String>>();
        HashMap<String, String> counterBasedRateLimiterFilterParameters = new HashMap<String, String>();
        counterBasedRateLimiterFilterParameters.put("maxRequestsPerServlet", String.valueOf(IServletSystemProperties.SpeechToTextServlet.MAX_SPEECH_TO_TEXT));
        result.put(CounterBasedRateLimiterFilter.class, counterBasedRateLimiterFilterParameters);
        return result;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        final HttpSession session = request.getSession(true);
        session.setMaxInactiveInterval(IServletSystemProperties.SpeechToTextServlet.SPEECHTOTEXT_SESSION_MAX_INACTIVE_INTERVAL);
        final Object sessionLock = SessionLockManager.getSessionLock(session);
        AsyncContext asyncContext = request.startAsync((ServletRequest)request, (ServletResponse)response);
        asyncContext.setTimeout((long)IServletSystemProperties.SpeechToTextServlet.SPEECHTOTEXT_ASYNC_TIMEOUT);
        try {
            this.executorService.execute(new HttpAsyncContextRunnable(asyncContext, this.getServletContext()){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run(HttpServletRequest request, HttpServletResponse response) throws IOException {
                    Object object = sessionLock;
                    synchronized (object) {
                        block17: {
                            try {
                                AudioBuffer audioBuffer = AudioBuffer.getOrCreateAudioBuffer(session);
                                audioBuffer.append(request);
                                SpeechToTextServletParameters servletParameters = new SpeechToTextServletParameters();
                                ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
                                if (servletParameters.getHelp().booleanValue() || parser.hasException()) {
                                    parser.usage();
                                    return;
                                }
                                Locale speechToTextLocale = this.getSpeechToTextLocale(servletParameters);
                                int samplingRate = servletParameters.getSamplingRate();
                                int requestSize = request.getContentLength();
                                int passesCnt = 1;
                                int startOffset = passesCnt == 2 ? audioBuffer.size() - requestSize : 0;
                                String result = "";
                                for (int pass = passesCnt; pass >= 1; --pass) {
                                    byte[] bytesToRecognize = this.deepFilter(samplingRate, audioBuffer.getBytesAt(startOffset));
                                    try (Recognizer recognizer = new Recognizer(this.getModel(speechToTextLocale), (float)samplingRate);){
                                        recognizer.acceptWaveForm(bytesToRecognize, bytesToRecognize.length);
                                        result = this.parseJsonResult(recognizer.getFinalResult());
                                    }
                                    if (pass == 2 && result.isEmpty()) {
                                        audioBuffer.clear();
                                        break;
                                    }
                                    startOffset = 0;
                                }
                                audioBuffer.sliceEnd(IServletSystemProperties.SpeechToTextServlet.SPEECHTOTEXT_MAX_RECORDING_TIME * samplingRate * 2);
                                if (!this.isComplete()) {
                                    SpeechToTextServlet.this.setOutput(request, response, result);
                                }
                            }
                            catch (IllegalArgumentException e) {
                                ServletUtil.error(SpeechToTextServlet.this.getServletContext(), e, this.parentThread);
                                if (!this.isComplete()) {
                                    response.setStatus(409);
                                }
                            }
                            catch (Throwable t) {
                                ServletUtil.error(SpeechToTextServlet.this.getServletContext(), t, this.parentThread);
                                if (this.isComplete()) break block17;
                                response.setStatus(500);
                                SpeechToTextServlet.this.setOutput(response, t);
                            }
                        }
                    }
                }

                private Locale getSpeechToTextLocale(SpeechToTextServletParameters servletParameters) {
                    return servletParameters.getSpeechToTextLocale() != null ? servletParameters.getSpeechToTextLocale() : servletParameters.getLocale();
                }

                private Model getModel(Locale speechToTextLocale) throws IOException {
                    Model model;
                    Model model2 = model = speechToTextLocale == Locale.GERMAN ? SpeechToTextServlet.this.modelDe : SpeechToTextServlet.this.modelEn;
                    if (model == null) {
                        throw new IOException(String.format("Vosk model not available: %s", speechToTextLocale == Locale.GERMAN ? IServletSystemProperties.SpeechToTextServlet.SPEECHTOTEXT_MODEL_DE : IServletSystemProperties.SpeechToTextServlet.SPEECHTOTEXT_MODEL_EN));
                    }
                    return model;
                }

                private byte[] deepFilter(int samplingRate, byte[] bytesToRecognize) throws IOException, FileNotFoundException {
                    if (!IServletSystemProperties.SpeechToTextServlet.SPEECHTOTEXT_DEEPFILTER || samplingRate != 48000) {
                        return bytesToRecognize;
                    }
                    SidPlay2Section sidplay2Section = SpeechToTextServlet.this.configuration.getSidplay2Section();
                    File wavFile = File.createTempFile("speech2text", ".wav", sidplay2Section.getTmpDir());
                    WAVHeader wavHeader = new WAVHeader(1, samplingRate);
                    wavHeader.advance(bytesToRecognize.length);
                    try (ByteArrayInputStream is = new ByteArrayInputStream(bytesToRecognize);
                         FileOutputStream os = new FileOutputStream(wavFile);){
                        ((OutputStream)os).write(wavHeader.getBytes());
                        IOUtils.copy(is, os);
                    }
                    new ExternalProcess().execute(new DeepFilterParameters(wavFile, SpeechToTextServlet.this.deepFilterOutputDir));
                    File filteredWav = new File(SpeechToTextServlet.this.deepFilterOutputDir, wavFile.getName());
                    ByteArrayOutputStream bos = new ByteArrayOutputStream();
                    try (FileInputStream is = new FileInputStream(filteredWav);){
                        ((InputStream)is).read(new byte[44]);
                        IOUtils.copy(is, bos);
                    }
                    byte[] byteArray = bos.toByteArray();
                    wavFile.delete();
                    filteredWav.delete();
                    return Arrays.copyOf(byteArray, byteArray.length);
                }

                private String parseJsonResult(String jsonResult) throws JsonProcessingException, JsonMappingException {
                    JsonNode root = new ObjectMapper().readTree(jsonResult);
                    JsonNode textNode = root.get("text");
                    return textNode != null ? textNode.asText() : "";
                }
            });
        }
        catch (RejectedExecutionException e) {
            ServletUtil.error(this.getServletContext(), e, new Thread[0]);
            response.sendError(429, "Too Many Requests");
        }
    }

    @Parameters(resourceBundle="server.restful.servlets.SpeechToTextServletParameters")
    public static class SpeechToTextServletParameters
    extends UsageParameter
    implements RequestResponseBodyParameter<RequestResponseBodyParameter.Blob, String> {
        private Locale locale = Locale.ROOT;
        private Locale speechToTextLocale;
        private int samplingRate = 48000;

        public Locale getLocale() {
            return this.locale;
        }

        @Parameter(names={"--locale"}, descriptionKey="LOCALE", converter=LocaleConverter.class, order=-2147483647)
        public void setLocale(Locale locale) {
            this.locale = locale;
        }

        public Locale getSpeechToTextLocale() {
            return this.speechToTextLocale;
        }

        @Parameter(names={"--speechToTextLocale"}, descriptionKey="SPEECH_TO_TEXT_LOCALE", converter=LocaleConverter.class, order=-2147483646)
        public void setSpeechToTextLocale(Locale speechToTextLocale) {
            this.speechToTextLocale = speechToTextLocale;
        }

        public int getSamplingRate() {
            return this.samplingRate;
        }

        @Parameter(names={"--samplingRate"}, descriptionKey="FREQUENCY", order=-2147483645)
        public void setSamplingRate(int samplingRate) {
            this.samplingRate = samplingRate;
        }

        @Override
        public RequestResponseBodyParameter.Blob getRequestBodyExample() {
            return new RequestResponseBodyParameter.Blob();
        }

        @Override
        public String getResponseBodyExample() {
            return "Hello World";
        }
    }
}

