/*
 * Decompiled with CFR 0.152.
 */
package server.restful.servlets.rtmp;

import com.beust.jcommander.Parameters;
import jakarta.servlet.ServletException;
import jakarta.servlet.annotation.HttpConstraint;
import jakarta.servlet.annotation.ServletSecurity;
import jakarta.servlet.annotation.WebServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.UUID;
import server.restful.common.ContentTypeAndFileExtensions;
import server.restful.common.JSIDPlay2Servlet;
import server.restful.common.ServletUtil;
import server.restful.common.parameter.ServletParameterParser;
import server.restful.common.parameter.requestparam.VideoRequestParamServletParameters;
import server.restful.common.rtmp.PlayerCleanupTimerTask;
import server.restful.common.rtmp.PlayerWithStatus;

@WebServlet(name="InsertNextCartServlet", displayName="InsertNextCartServlet", urlPatterns={"/static/insert_next_cart"}, description="Insert next cart for emulator running as a RTMP live video stream")
@ServletSecurity(value=@HttpConstraint(rolesAllowed={"user", "admin"}))
public class InsertNextCartServlet
extends JSIDPlay2Servlet {
    @Override
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            InsertNextCartServletParameters servletParameters = new InsertNextCartServletParameters();
            ServletParameterParser parser = new ServletParameterParser(request, response, servletParameters);
            if (servletParameters.getHelp().booleanValue() || parser.hasException()) {
                parser.usage();
                return;
            }
            UUID uuid = servletParameters.getUuid();
            StringBuilder cartImageName = new StringBuilder();
            ServletUtil.info(this.getServletContext(), String.format("insertNextCart: RTMP stream of: %s", uuid), new Thread[0]);
            PlayerCleanupTimerTask.update(uuid, rtmpPlayerWithStatus -> this.insertNextCart((PlayerWithStatus)rtmpPlayerWithStatus, cartImageName));
            this.setOutput(ContentTypeAndFileExtensions.MIME_TYPE_JSON, response, (Object)cartImageName);
        }
        catch (Throwable t) {
            response.setStatus(500);
            ServletUtil.error(this.getServletContext(), t, new Thread[0]);
            this.setOutput(response, t);
        }
    }

    private void insertNextCart(PlayerWithStatus rtmpPlayerWithStatus, StringBuilder cartImageName) {
        try {
            cartImageName.append((String)Optional.ofNullable(rtmpPlayerWithStatus.insertNextCart()).map(File::getName).orElse(null));
        }
        catch (IOException e) {
            ServletUtil.error(this.getServletContext(), e, new Thread[0]);
        }
    }

    @Parameters(resourceBundle="server.restful.servlets.rtmp.InsertNextCartServletParameters")
    public static class InsertNextCartServletParameters
    extends VideoRequestParamServletParameters {
    }
}

