/*
 * Decompiled with CFR 0.152.
 */
package ui.entities.config;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import java.io.File;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.FloatProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleFloatProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javax.persistence.Convert;
import javax.persistence.Embeddable;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import libsidplay.common.SamplingMethod;
import libsidplay.common.SamplingRate;
import libsidplay.common.VideoCoderPreset;
import libsidplay.config.IAudioSection;
import sidplay.audio.Audio;
import sidplay.ini.IniDefaults;
import sidplay.ini.converter.BeanToStringConverter;
import ui.common.converter.FileAttributeConverter;
import ui.common.converter.FileToStringDeserializer;
import ui.common.converter.FileToStringSerializer;
import ui.common.converter.FileXmlAdapter;
import ui.common.properties.ShadowField;

@Embeddable
public class AudioSection
implements IAudioSection {
    private ShadowField<ObjectProperty<Audio>, Audio> audio = new ShadowField<ObjectProperty, Audio>(SimpleObjectProperty::new, IniDefaults.DEFAULT_AUDIO);
    private ShadowField<IntegerProperty, Number> device = new ShadowField<IntegerProperty, Integer>(number -> new SimpleIntegerProperty(number.intValue()), IniDefaults.DEFAULT_DEVICE);
    private ShadowField<ObjectProperty<SamplingRate>, SamplingRate> samplingRate = new ShadowField<ObjectProperty, SamplingRate>(SimpleObjectProperty::new, IniDefaults.DEFAULT_SAMPLING_RATE);
    private ShadowField<ObjectProperty<SamplingMethod>, SamplingMethod> sampling = new ShadowField<ObjectProperty, SamplingMethod>(SimpleObjectProperty::new, IniDefaults.DEFAULT_SAMPLING);
    private ShadowField<FloatProperty, Number> mainVolume = new ShadowField<FloatProperty, Float>(number -> new SimpleFloatProperty(number.floatValue()), Float.valueOf(IniDefaults.DEFAULT_MAIN_VOLUME));
    private ShadowField<FloatProperty, Number> secondVolume = new ShadowField<FloatProperty, Float>(number -> new SimpleFloatProperty(number.floatValue()), Float.valueOf(IniDefaults.DEFAULT_SECOND_VOLUME));
    private ShadowField<FloatProperty, Number> thirdVolume = new ShadowField<FloatProperty, Float>(number -> new SimpleFloatProperty(number.floatValue()), Float.valueOf(IniDefaults.DEFAULT_THIRD_VOLUME));
    private ShadowField<FloatProperty, Number> mainBalance = new ShadowField<FloatProperty, Float>(number -> new SimpleFloatProperty(number.floatValue()), Float.valueOf(IniDefaults.DEFAULT_MAIN_BALANCE));
    private ShadowField<FloatProperty, Number> secondBalance = new ShadowField<FloatProperty, Float>(number -> new SimpleFloatProperty(number.floatValue()), Float.valueOf(IniDefaults.DEFAULT_SECOND_BALANCE));
    private ShadowField<FloatProperty, Number> thirdBalance = new ShadowField<FloatProperty, Float>(number -> new SimpleFloatProperty(number.floatValue()), Float.valueOf(IniDefaults.DEFAULT_THIRD_BALANCE));
    private ShadowField<IntegerProperty, Number> mainDelay = new ShadowField<IntegerProperty, Integer>(number -> new SimpleIntegerProperty(number.intValue()), IniDefaults.DEFAULT_MAIN_DELAY);
    private ShadowField<IntegerProperty, Number> secondDelay = new ShadowField<IntegerProperty, Integer>(number -> new SimpleIntegerProperty(number.intValue()), IniDefaults.DEFAULT_SECOND_DELAY);
    private ShadowField<IntegerProperty, Number> thirdDelay = new ShadowField<IntegerProperty, Integer>(number -> new SimpleIntegerProperty(number.intValue()), IniDefaults.DEFAULT_THIRD_DELAY);
    private ShadowField<IntegerProperty, Number> bufferSize = new ShadowField<IntegerProperty, Integer>(number -> new SimpleIntegerProperty(number.intValue()), IniDefaults.DEFAULT_BUFFER_SIZE);
    private ShadowField<ObjectProperty<Integer>, Integer> audioBufferSize = new ShadowField<ObjectProperty, Integer>(SimpleObjectProperty::new, IniDefaults.DEFAULT_AUDIO_BUFFER_SIZE);
    private ShadowField<BooleanProperty, Boolean> playOriginal = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_PLAY_ORIGINAL);
    private ShadowField<ObjectProperty<File>, File> mp3 = new ShadowField<ObjectProperty, Object>(SimpleObjectProperty::new, null);
    private ShadowField<ObjectProperty<Integer>, Integer> cbr = new ShadowField<ObjectProperty, Integer>(SimpleObjectProperty::new, IniDefaults.DEFAULT_CBR);
    private ShadowField<BooleanProperty, Boolean> vbr = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_VBR);
    private ShadowField<ObjectProperty<Integer>, Integer> vbrQuality = new ShadowField<ObjectProperty, Integer>(SimpleObjectProperty::new, IniDefaults.DEFAULT_VBR_QUALITY);
    private ShadowField<BooleanProperty, Boolean> delayBypass = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_DELAY_BYPASS);
    private ShadowField<IntegerProperty, Number> audioCoderBitRate = new ShadowField<IntegerProperty, Integer>(number -> new SimpleIntegerProperty(number.intValue()), IniDefaults.DEFAULT_AUDIO_CODER_BIT_RATE);
    private ShadowField<IntegerProperty, Number> audioCoderBitRateTolerance = new ShadowField<IntegerProperty, Integer>(number -> new SimpleIntegerProperty(number.intValue()), IniDefaults.DEFAULT_AUDIO_CODER_BIT_RATE_TOLERANCE);
    private ShadowField<StringProperty, String> videoStreamingUrl = new ShadowField<StringProperty, String>(SimpleStringProperty::new, IniDefaults.DEFAULT_VIDEO_STREAMING_URL);
    private ShadowField<IntegerProperty, Number> videoCoderNumPicturesInGroupOfPictures = new ShadowField<IntegerProperty, Integer>(number -> new SimpleIntegerProperty(number.intValue()), IniDefaults.DEFAULT_VIDEO_CODER_GOP);
    private ShadowField<IntegerProperty, Number> videoCoderBitRate = new ShadowField<IntegerProperty, Integer>(number -> new SimpleIntegerProperty(number.intValue()), IniDefaults.DEFAULT_VIDEO_CODER_BIT_RATE);
    private ShadowField<IntegerProperty, Number> videoCoderBitRateTolerance = new ShadowField<IntegerProperty, Integer>(number -> new SimpleIntegerProperty(number.intValue()), IniDefaults.DEFAULT_VIDEO_CODER_BIT_RATE_TOLERANCE);
    private ShadowField<IntegerProperty, Number> videoCoderGlobalQuality = new ShadowField<IntegerProperty, Integer>(number -> new SimpleIntegerProperty(number.intValue()), IniDefaults.DEFAULT_VIDEO_CODER_GLOBAL_QUALITY);
    private ShadowField<ObjectProperty<VideoCoderPreset>, VideoCoderPreset> videoCoderPreset = new ShadowField<ObjectProperty, VideoCoderPreset>(SimpleObjectProperty::new, IniDefaults.DEFAULT_VIDEO_CODER_PRESET);
    private ShadowField<IntegerProperty, Number> videoCoderAudioDelay = new ShadowField<IntegerProperty, Integer>(number -> new SimpleIntegerProperty(number.intValue()), IniDefaults.DEFAULT_VIDEO_CODER_AUDIO_DELAY);
    private ShadowField<IntegerProperty, Number> delay = new ShadowField<IntegerProperty, Integer>(number -> new SimpleIntegerProperty(number.intValue()), IniDefaults.DEFAULT_DELAY);
    private ShadowField<IntegerProperty, Number> delayDryLevel = new ShadowField<IntegerProperty, Integer>(number -> new SimpleIntegerProperty(number.intValue()), IniDefaults.DEFAULT_DELAY_DRY_LEVEL);
    private ShadowField<IntegerProperty, Number> delayWetLevel = new ShadowField<IntegerProperty, Integer>(number -> new SimpleIntegerProperty(number.intValue()), IniDefaults.DEFAULT_DELAY_WET_LEVEL);
    private ShadowField<IntegerProperty, Number> delayFeedbackLevel = new ShadowField<IntegerProperty, Integer>(number -> new SimpleIntegerProperty(number.intValue()), IniDefaults.DEFAULT_DELAY_FEEDBACK_LEVEL);
    private ShadowField<BooleanProperty, Boolean> reverbBypass = new ShadowField<BooleanProperty, Boolean>(SimpleBooleanProperty::new, IniDefaults.DEFAULT_REVERB_BYPASS);
    private ShadowField<FloatProperty, Number> reverbComb1Delay = new ShadowField<FloatProperty, Float>(number -> new SimpleFloatProperty(number.floatValue()), Float.valueOf(IniDefaults.DEFAULT_REVERB_COMB1_DELAY));
    private ShadowField<FloatProperty, Number> reverbComb2Delay = new ShadowField<FloatProperty, Float>(number -> new SimpleFloatProperty(number.floatValue()), Float.valueOf(IniDefaults.DEFAULT_REVERB_COMB2_DELAY));
    private ShadowField<FloatProperty, Number> reverbComb3Delay = new ShadowField<FloatProperty, Float>(number -> new SimpleFloatProperty(number.floatValue()), Float.valueOf(IniDefaults.DEFAULT_REVERB_COMB3_DELAY));
    private ShadowField<FloatProperty, Number> reverbComb4Delay = new ShadowField<FloatProperty, Float>(number -> new SimpleFloatProperty(number.floatValue()), Float.valueOf(IniDefaults.DEFAULT_REVERB_COMB4_DELAY));
    private ShadowField<FloatProperty, Number> reverbAllPass1Delay = new ShadowField<FloatProperty, Float>(number -> new SimpleFloatProperty(number.floatValue()), Float.valueOf(IniDefaults.DEFAULT_REVERB_ALL_PASS1_DELAY));
    private ShadowField<FloatProperty, Number> reverbAllPass2Delay = new ShadowField<FloatProperty, Float>(number -> new SimpleFloatProperty(number.floatValue()), Float.valueOf(IniDefaults.DEFAULT_REVERB_ALL_PASS2_DELAY));
    private ShadowField<FloatProperty, Number> reverbSustainDelay = new ShadowField<FloatProperty, Float>(number -> new SimpleFloatProperty(number.floatValue()), Float.valueOf(IniDefaults.DEFAULT_REVERB_SUSTAIN_DELAY));
    private ShadowField<FloatProperty, Number> reverbDryWetMix = new ShadowField<FloatProperty, Float>(number -> new SimpleFloatProperty(number.floatValue()), Float.valueOf(IniDefaults.DEFAULT_REVERB_DRY_WET_MIX));

    @Override
    @Enumerated(value=EnumType.STRING)
    public Audio getAudio() {
        return this.audio.get();
    }

    @Override
    public void setAudio(Audio audio) {
        this.audio.set(audio);
    }

    public final ObjectProperty<Audio> audioProperty() {
        return this.audio.property();
    }

    @Override
    public int getDevice() {
        return this.device.get().intValue();
    }

    @Override
    public void setDevice(int device) {
        this.device.set(device);
    }

    public final IntegerProperty deviceProperty() {
        return this.device.property();
    }

    @Override
    @Enumerated(value=EnumType.STRING)
    public SamplingRate getSamplingRate() {
        return this.samplingRate.get();
    }

    @Override
    public void setSamplingRate(SamplingRate samplingRate) {
        this.samplingRate.set(samplingRate);
    }

    public final ObjectProperty<SamplingRate> samplingRateProperty() {
        return this.samplingRate.property();
    }

    @Override
    @Enumerated(value=EnumType.STRING)
    public SamplingMethod getSampling() {
        return this.sampling.get();
    }

    @Override
    public void setSampling(SamplingMethod method) {
        this.sampling.set(method);
    }

    public final ObjectProperty<SamplingMethod> samplingProperty() {
        return this.sampling.property();
    }

    @Override
    public float getMainVolume() {
        return this.mainVolume.get().floatValue();
    }

    @Override
    public void setMainVolume(float volume) {
        this.mainVolume.set(Float.valueOf(volume));
    }

    public final FloatProperty mainVolumeProperty() {
        return this.mainVolume.property();
    }

    @Override
    public float getSecondVolume() {
        return this.secondVolume.get().floatValue();
    }

    @Override
    public void setSecondVolume(float volume) {
        this.secondVolume.set(Float.valueOf(volume));
    }

    public final FloatProperty secondVolumeProperty() {
        return this.secondVolume.property();
    }

    @Override
    public float getThirdVolume() {
        return this.thirdVolume.get().floatValue();
    }

    @Override
    public void setThirdVolume(float volume) {
        this.thirdVolume.set(Float.valueOf(volume));
    }

    public final FloatProperty thirdVolumeProperty() {
        return this.thirdVolume.property();
    }

    @Override
    public float getMainBalance() {
        return this.mainBalance.get().floatValue();
    }

    @Override
    public void setMainBalance(float balance) {
        this.mainBalance.set(Float.valueOf(balance));
    }

    public final FloatProperty mainBalanceProperty() {
        return this.mainBalance.property();
    }

    @Override
    public float getSecondBalance() {
        return this.secondBalance.get().floatValue();
    }

    @Override
    public void setSecondBalance(float right) {
        this.secondBalance.set(Float.valueOf(right));
    }

    public final FloatProperty secondBalanceProperty() {
        return this.secondBalance.property();
    }

    @Override
    public float getThirdBalance() {
        return this.thirdBalance.get().floatValue();
    }

    @Override
    public void setThirdBalance(float third) {
        this.thirdBalance.set(Float.valueOf(third));
    }

    public final FloatProperty thirdBalanceProperty() {
        return this.thirdBalance.property();
    }

    @Override
    public int getMainDelay() {
        return this.mainDelay.get().intValue();
    }

    @Override
    public void setMainDelay(int delay) {
        this.mainDelay.set(delay);
    }

    public final IntegerProperty mainDelayProperty() {
        return this.mainDelay.property();
    }

    @Override
    public int getSecondDelay() {
        return this.secondDelay.get().intValue();
    }

    @Override
    public void setSecondDelay(int delay) {
        this.secondDelay.set(delay);
    }

    public final IntegerProperty secondDelayProperty() {
        return this.secondDelay.property();
    }

    @Override
    public int getThirdDelay() {
        return this.thirdDelay.get().intValue();
    }

    @Override
    public void setThirdDelay(int delay) {
        this.thirdDelay.set(delay);
    }

    public final IntegerProperty thirdDelayProperty() {
        return this.thirdDelay.property();
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize.get().intValue();
    }

    @Override
    public void setBufferSize(int bufferSize) {
        this.bufferSize.set(bufferSize);
    }

    public final IntegerProperty bufferSizeProperty() {
        return this.bufferSize.property();
    }

    @Override
    public int getAudioBufferSize() {
        return this.audioBufferSize.get();
    }

    @Override
    public void setAudioBufferSize(int audioBufferSize) {
        this.audioBufferSize.set(audioBufferSize);
    }

    public final ObjectProperty<Integer> audioBufferSizeProperty() {
        return this.audioBufferSize.property();
    }

    @Override
    public boolean isPlayOriginal() {
        return this.playOriginal.get();
    }

    @Override
    public void setPlayOriginal(boolean original) {
        this.playOriginal.set(original);
    }

    public final BooleanProperty playOriginalProperty() {
        return this.playOriginal.property();
    }

    @Override
    @Convert(converter=FileAttributeConverter.class)
    @XmlJavaTypeAdapter(value=FileXmlAdapter.class)
    @JsonSerialize(using=FileToStringSerializer.class)
    @JsonDeserialize(using=FileToStringDeserializer.class)
    public File getMp3() {
        return this.mp3.get();
    }

    @Override
    public void setMp3(File recording) {
        this.mp3.set(recording);
    }

    public final ObjectProperty<File> mp3Property() {
        return this.mp3.property();
    }

    @Override
    public int getCbr() {
        return this.cbr.get();
    }

    @Override
    public void setCbr(int cbr) {
        this.cbr.set(cbr);
    }

    public final ObjectProperty<Integer> cbrProperty() {
        return this.cbr.property();
    }

    @Override
    public boolean isVbr() {
        return this.vbr.get();
    }

    @Override
    public void setVbr(boolean vbr) {
        this.vbr.set(vbr);
    }

    public final BooleanProperty vbrProperty() {
        return this.vbr.property();
    }

    @Override
    public int getVbrQuality() {
        return this.vbrQuality.get();
    }

    @Override
    public void setVbrQuality(int vbrQuality) {
        this.vbrQuality.set(vbrQuality);
    }

    public final ObjectProperty<Integer> vbrQualityProperty() {
        return this.vbrQuality.property();
    }

    @Override
    public boolean getDelayBypass() {
        return this.delayBypass.get();
    }

    @Override
    public void setDelayBypass(boolean delayBypass) {
        this.delayBypass.set(delayBypass);
    }

    public final BooleanProperty delayBypassProperty() {
        return this.delayBypass.property();
    }

    @Override
    public int getAudioCoderBitRate() {
        return this.audioCoderBitRate.get().intValue();
    }

    @Override
    public void setAudioCoderBitRate(int bitRate) {
        this.audioCoderBitRate.set(bitRate);
    }

    public final IntegerProperty audioCoderBitRateProperty() {
        return this.audioCoderBitRate.property();
    }

    @Override
    public int getAudioCoderBitRateTolerance() {
        return this.audioCoderBitRateTolerance.get().intValue();
    }

    @Override
    public void setAudioCoderBitRateTolerance(int bitRateTolerance) {
        this.audioCoderBitRateTolerance.set(bitRateTolerance);
    }

    public final IntegerProperty audioCoderBitRateToleranceProperty() {
        return this.audioCoderBitRateTolerance.property();
    }

    @Override
    public String getVideoStreamingUrl() {
        return this.videoStreamingUrl.get();
    }

    @Override
    public void setVideoStreamingUrl(String videoStreamingUrl) {
        this.videoStreamingUrl.set(videoStreamingUrl);
    }

    public final StringProperty videoStreamingUrlProperty() {
        return this.videoStreamingUrl.property();
    }

    @Override
    public int getVideoCoderNumPicturesInGroupOfPictures() {
        return this.videoCoderNumPicturesInGroupOfPictures.get().intValue();
    }

    @Override
    public void setVideoCoderNumPicturesInGroupOfPictures(int numPicturesInGroupOfPictures) {
        this.videoCoderNumPicturesInGroupOfPictures.set(numPicturesInGroupOfPictures);
    }

    public final IntegerProperty videoCoderNumPicturesInGroupOfPicturesProperty() {
        return this.videoCoderNumPicturesInGroupOfPictures.property();
    }

    @Override
    public int getVideoCoderBitRate() {
        return this.videoCoderBitRate.get().intValue();
    }

    @Override
    public void setVideoCoderBitRate(int bitRate) {
        this.videoCoderBitRate.set(bitRate);
    }

    public final IntegerProperty videoCoderBitRateProperty() {
        return this.videoCoderBitRate.property();
    }

    @Override
    public int getVideoCoderBitRateTolerance() {
        return this.videoCoderBitRateTolerance.get().intValue();
    }

    @Override
    public void setVideoCoderBitRateTolerance(int bitRateTolerance) {
        this.videoCoderBitRateTolerance.set(bitRateTolerance);
    }

    public final IntegerProperty videoCoderBitRateToleranceProperty() {
        return this.videoCoderBitRateTolerance.property();
    }

    @Override
    public int getVideoCoderGlobalQuality() {
        return this.videoCoderGlobalQuality.get().intValue();
    }

    @Override
    public void setVideoCoderGlobalQuality(int globalQuality) {
        this.videoCoderGlobalQuality.set(globalQuality);
    }

    public final IntegerProperty videoCoderGlobalQualityProperty() {
        return this.videoCoderGlobalQuality.property();
    }

    @Override
    @Enumerated(value=EnumType.STRING)
    public VideoCoderPreset getVideoCoderPreset() {
        return this.videoCoderPreset.get();
    }

    @Override
    public void setVideoCoderPreset(VideoCoderPreset videoEncoderPreset) {
        this.videoCoderPreset.set(videoEncoderPreset);
    }

    @Override
    public int getVideoCoderAudioDelay() {
        return this.videoCoderAudioDelay.get().intValue();
    }

    @Override
    public void setVideoCoderAudioDelay(int audioDelay) {
        this.videoCoderAudioDelay.set(audioDelay);
    }

    public final IntegerProperty videoCoderAudioDelayProperty() {
        return this.videoCoderAudioDelay.property();
    }

    public final ObjectProperty<VideoCoderPreset> sidVideoEncoderPresetProperty() {
        return this.videoCoderPreset.property();
    }

    @Override
    public int getDelay() {
        return this.delay.get().intValue();
    }

    @Override
    public void setDelay(int delay) {
        this.delay.set(delay);
    }

    public final IntegerProperty delayProperty() {
        return this.delay.property();
    }

    @Override
    public int getDelayDryLevel() {
        return this.delayDryLevel.get().intValue();
    }

    @Override
    public void setDelayDryLevel(int delayDryLevel) {
        this.delayDryLevel.set(delayDryLevel);
    }

    public final IntegerProperty delayDryLevelProperty() {
        return this.delayDryLevel.property();
    }

    @Override
    public int getDelayWetLevel() {
        return this.delayWetLevel.get().intValue();
    }

    @Override
    public void setDelayWetLevel(int delayWetLevel) {
        this.delayWetLevel.set(delayWetLevel);
    }

    public final IntegerProperty delayWetLevelProperty() {
        return this.delayWetLevel.property();
    }

    @Override
    public int getDelayFeedbackLevel() {
        return this.delayFeedbackLevel.get().intValue();
    }

    @Override
    public void setDelayFeedbackLevel(int delayFeedbackLevel) {
        this.delayFeedbackLevel.set(delayFeedbackLevel);
    }

    public final IntegerProperty delayFeedbackLevelProperty() {
        return this.delayFeedbackLevel.property();
    }

    @Override
    public boolean getReverbBypass() {
        return this.reverbBypass.get();
    }

    @Override
    public void setReverbBypass(boolean reverbBypass) {
        this.reverbBypass.set(reverbBypass);
    }

    public final BooleanProperty reverbBypassProperty() {
        return this.reverbBypass.property();
    }

    @Override
    public float getReverbComb1Delay() {
        return this.reverbComb1Delay.get().floatValue();
    }

    @Override
    public void setReverbComb1Delay(float reverbComb1Delay) {
        this.reverbComb1Delay.set(Float.valueOf(reverbComb1Delay));
    }

    public final FloatProperty reverbComb1DelayProperty() {
        return this.reverbComb1Delay.property();
    }

    @Override
    public float getReverbComb2Delay() {
        return this.reverbComb2Delay.get().floatValue();
    }

    @Override
    public void setReverbComb2Delay(float reverbComb2Delay) {
        this.reverbComb2Delay.set(Float.valueOf(reverbComb2Delay));
    }

    public final FloatProperty reverbComb2DelayProperty() {
        return this.reverbComb2Delay.property();
    }

    @Override
    public float getReverbComb3Delay() {
        return this.reverbComb3Delay.get().floatValue();
    }

    @Override
    public void setReverbComb3Delay(float reverbComb3Delay) {
        this.reverbComb3Delay.set(Float.valueOf(reverbComb3Delay));
    }

    public final FloatProperty reverbComb3DelayProperty() {
        return this.reverbComb3Delay.property();
    }

    @Override
    public float getReverbComb4Delay() {
        return this.reverbComb4Delay.get().floatValue();
    }

    @Override
    public void setReverbComb4Delay(float reverbComb4Delay) {
        this.reverbComb4Delay.set(Float.valueOf(reverbComb4Delay));
    }

    public final FloatProperty reverbComb4DelayProperty() {
        return this.reverbComb4Delay.property();
    }

    @Override
    public float getReverbAllPass1Delay() {
        return this.reverbAllPass1Delay.get().floatValue();
    }

    @Override
    public void setReverbAllPass1Delay(float reverbAllPass1Delay) {
        this.reverbAllPass1Delay.set(Float.valueOf(reverbAllPass1Delay));
    }

    public final FloatProperty reverbAllPass1DelayProperty() {
        return this.reverbAllPass1Delay.property();
    }

    @Override
    public float getReverbAllPass2Delay() {
        return this.reverbAllPass2Delay.get().floatValue();
    }

    @Override
    public void setReverbAllPass2Delay(float reverbAllPass2Delay) {
        this.reverbAllPass2Delay.set(Float.valueOf(reverbAllPass2Delay));
    }

    public final FloatProperty reverbAllPass2DelayProperty() {
        return this.reverbAllPass2Delay.property();
    }

    @Override
    public float getReverbSustainDelay() {
        return this.reverbSustainDelay.get().floatValue();
    }

    @Override
    public void setReverbSustainDelay(float reverbSustainDelay) {
        this.reverbSustainDelay.set(Float.valueOf(reverbSustainDelay));
    }

    public final FloatProperty reverbSustainDelayProperty() {
        return this.reverbSustainDelay.property();
    }

    @Override
    public float getReverbDryWetMix() {
        return this.reverbDryWetMix.get().floatValue();
    }

    @Override
    public void setReverbDryWetMix(float reverbDryWetMix) {
        this.reverbDryWetMix.set(Float.valueOf(reverbDryWetMix));
    }

    public final FloatProperty reverbDryWetMixProperty() {
        return this.reverbDryWetMix.property();
    }

    public final String toString() {
        return BeanToStringConverter.toString(this);
    }
}

