/*
 * Decompiled with CFR 0.152.
 */
package ui.printer;

import java.util.Arrays;
import javafx.application.Platform;
import javafx.fxml.FXML;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.control.ScrollPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import libsidplay.components.printer.IPaper;
import libsidplay.components.printer.paper.ConsolePaper;
import sidplay.Player;
import ui.common.C64VBox;
import ui.common.C64Window;
import ui.common.UIPart;

public class Printer
extends C64VBox
implements UIPart,
IPaper {
    public static final String ID = "PRINTER";
    @FXML
    private ScrollPane scroll;
    @FXML
    protected Canvas paper;
    private boolean[] currentPixelRow = new boolean[480];
    private int x;
    private int y;

    public Printer() {
    }

    public Printer(C64Window window, Player player) {
        super(window, player);
    }

    @Override
    @FXML
    protected void initialize() {
        this.paper.setWidth(480.0);
        this.util.getPlayer().getPrinter().setPaper(this);
    }

    @Override
    public void doClose() {
        this.util.getPlayer().getPrinter().setPaper(new ConsolePaper());
    }

    @FXML
    private void clearPaper() {
        this.paper.getGraphicsContext2D().clearRect(0.0, 0.0, this.paper.getWidth(), this.paper.getHeight());
        this.y = 0;
    }

    @Override
    public void put(IPaper.Outputs out) {
        switch (out) {
            case OUTPUT_NEWLINE: {
                boolean[] toPrint = Arrays.copyOf(this.currentPixelRow, 480);
                Arrays.fill(this.currentPixelRow, false);
                this.x = 0;
                int paperY = this.y++;
                Platform.runLater(() -> {
                    GraphicsContext g = this.paper.getGraphicsContext2D();
                    if ((double)paperY >= this.paper.getHeight()) {
                        this.paper.setTranslateY((double)paperY - this.paper.getHeight());
                        this.paper.setHeight((double)paperY);
                        this.scroll.setVvalue(1.0);
                    }
                    for (int paperX = 0; paperX < toPrint.length; ++paperX) {
                        g.setStroke((Paint)(toPrint[paperX] ? Color.BLACK : Color.WHITE));
                        g.strokeLine((double)paperX, (double)paperY, (double)paperX, (double)paperY);
                    }
                });
                break;
            }
            default: {
                if (this.x < 480) {
                    this.currentPixelRow[this.x] = out == IPaper.Outputs.OUTPUT_PIXEL_BLACK;
                }
                ++this.x;
            }
        }
    }
}

