/*
 * Decompiled with CFR 0.152.
 */
package ui.siddump;

import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;
import sidplay.audio.siddump.SidDumpOutput;

public class SidDumpCellFactory
implements Callback<TableColumn<SidDumpOutput, String>, TableCell<SidDumpOutput, String>> {
    public TableCell<SidDumpOutput, String> call(final TableColumn<SidDumpOutput, String> column) {
        TableCell<SidDumpOutput, String> cell = new TableCell<SidDumpOutput, String>(){

            public void updateItem(String value, boolean empty) {
                super.updateItem((Object)value, empty);
                int columnIndex = column.getTableView().getColumns().indexOf((Object)column);
                if (!empty) {
                    this.setText(value);
                } else {
                    this.setText("");
                }
                if (columnIndex == 0 || columnIndex > 15) {
                    this.getStyleClass().add((Object)"normalCellValue");
                } else if (value != null && value.trim().startsWith(".")) {
                    this.getStyleClass().add((Object)"unchangedCellValue");
                } else {
                    switch ((columnIndex - 1) / 5) {
                        case 0: {
                            this.getStyleClass().add((Object)"voice1CellValue");
                            break;
                        }
                        case 1: {
                            this.getStyleClass().add((Object)"voice2CellValue");
                            break;
                        }
                        case 2: {
                            this.getStyleClass().add((Object)"voice3CellValue");
                            break;
                        }
                    }
                }
            }
        };
        return cell;
    }
}

