/*
 * Decompiled with CFR 0.152.
 */
package ui.sidreg;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javafx.application.Platform;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.SortedList;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.TableView;
import javafx.scene.control.ToggleButton;
import javafx.stage.FileChooser;
import libsidutils.IOUtils;
import sidplay.Player;
import sidplay.audio.SIDRegDriver;
import sidplay.audio.sidreg.SidRegWrite;
import sidplay.player.State;
import ui.common.C64VBox;
import ui.common.C64Window;
import ui.common.UIPart;
import ui.sidreg.SidRegExtension;

public class SidReg
extends C64VBox
implements UIPart {
    public static final String ID = "SIDREGISTERS";
    final SidRegExtension sidRegExtension = new SidRegExtension(){

        @Override
        public void sidWrite(SidRegWrite output) {
            Platform.runLater(() -> {
                SidReg.this.allSidRegWrites.add((Object)output);
                if (SidReg.this.allSidRegWrites.size() % 1000 == 0) {
                    SidReg.this.doUpdateFilter();
                }
            });
        }

        @Override
        public void clear() {
            Platform.runLater(() -> SidReg.this.allSidRegWrites.clear());
        }
    };
    private static final int REFRESH_RATE = 1000;
    @FXML
    private ToggleButton startStop;
    @FXML
    private CheckBox startStopPlayer;
    @FXML
    private CheckBox freq1;
    @FXML
    private CheckBox freq2;
    @FXML
    private CheckBox freq3;
    @FXML
    private CheckBox pulse1;
    @FXML
    private CheckBox pulse2;
    @FXML
    private CheckBox pulse3;
    @FXML
    private CheckBox ctrl1;
    @FXML
    private CheckBox ctrl2;
    @FXML
    private CheckBox ctrl3;
    @FXML
    private CheckBox ad1;
    @FXML
    private CheckBox ad2;
    @FXML
    private CheckBox ad3;
    @FXML
    private CheckBox sr1;
    @FXML
    private CheckBox sr2;
    @FXML
    private CheckBox sr3;
    @FXML
    private CheckBox filter;
    @FXML
    private CheckBox vol;
    @FXML
    private CheckBox paddles;
    @FXML
    private CheckBox osc3;
    @FXML
    private CheckBox env3;
    @FXML
    private Button selectAll;
    @FXML
    private Button deselectAll;
    @FXML
    private Button saveRegs;
    @FXML
    private TableView<SidRegWrite> regTable;
    private ObservableList<SidRegWrite> filteredSidRegWrites;
    private ObservableList<SidRegWrite> allSidRegWrites;
    private Set<String> filters;
    private PropertyChangeListener sidRegStop;

    public SidReg() {
    }

    public SidReg(C64Window window, Player player) {
        super(window, player);
    }

    @Override
    @FXML
    protected void initialize() {
        this.filteredSidRegWrites = FXCollections.observableArrayList();
        SortedList sortedList = new SortedList(this.filteredSidRegWrites);
        sortedList.comparatorProperty().bind((ObservableValue)this.regTable.comparatorProperty());
        this.regTable.setItems((ObservableList)sortedList);
        this.allSidRegWrites = FXCollections.observableArrayList();
        this.filters = new HashSet<String>();
        this.doUpdateFilter();
        this.sidRegStop = event -> {
            if (event.getNewValue() == State.END) {
                Platform.runLater(() -> {
                    this.recordSidWrites(false);
                    this.doUpdateFilter();
                });
            }
        };
        this.util.getPlayer().stateProperty().addListener(this.sidRegStop);
    }

    @Override
    public void doClose() {
        this.util.getPlayer().removeSidListener(this.sidRegExtension);
        this.util.getPlayer().stateProperty().removeListener(this.sidRegStop);
    }

    @FXML
    private void doStartStop() {
        this.recordSidWrites(this.startStop.isSelected());
        this.doUpdateFilter();
        if (this.startStopPlayer.isSelected()) {
            if (this.startStop.isSelected()) {
                this.util.getPlayer().play(this.util.getPlayer().getTune());
            } else {
                this.util.getPlayer().stopC64();
            }
        }
    }

    @FXML
    protected void doUpdateFilter() {
        this.filters.clear();
        if (this.freq1.isSelected()) {
            this.filters.add(this.util.getBundle().getString("VOICE_1_FREQ_L"));
            this.filters.add(this.util.getBundle().getString("VOICE_1_FREQ_H"));
        }
        if (this.freq2.isSelected()) {
            this.filters.add(this.util.getBundle().getString("VOICE_2_FREQ_L"));
            this.filters.add(this.util.getBundle().getString("VOICE_2_FREQ_H"));
        }
        if (this.freq3.isSelected()) {
            this.filters.add(this.util.getBundle().getString("VOICE_3_FREQ_L"));
            this.filters.add(this.util.getBundle().getString("VOICE_3_FREQ_H"));
        }
        if (this.pulse1.isSelected()) {
            this.filters.add(this.util.getBundle().getString("VOICE_1_PULSE_L"));
            this.filters.add(this.util.getBundle().getString("VOICE_1_PULSE_H"));
        }
        if (this.pulse2.isSelected()) {
            this.filters.add(this.util.getBundle().getString("VOICE_2_PULSE_L"));
            this.filters.add(this.util.getBundle().getString("VOICE_2_PULSE_H"));
        }
        if (this.pulse3.isSelected()) {
            this.filters.add(this.util.getBundle().getString("VOICE_3_PULSE_L"));
            this.filters.add(this.util.getBundle().getString("VOICE_3_PULSE_H"));
        }
        if (this.ctrl1.isSelected()) {
            this.filters.add(this.util.getBundle().getString("VOICE_1_CTRL"));
        }
        if (this.ctrl2.isSelected()) {
            this.filters.add(this.util.getBundle().getString("VOICE_2_CTRL"));
        }
        if (this.ctrl3.isSelected()) {
            this.filters.add(this.util.getBundle().getString("VOICE_3_CTRL"));
        }
        if (this.ad1.isSelected()) {
            this.filters.add(this.util.getBundle().getString("VOICE_1_AD"));
        }
        if (this.ad2.isSelected()) {
            this.filters.add(this.util.getBundle().getString("VOICE_2_AD"));
        }
        if (this.ad3.isSelected()) {
            this.filters.add(this.util.getBundle().getString("VOICE_3_AD"));
        }
        if (this.sr1.isSelected()) {
            this.filters.add(this.util.getBundle().getString("VOICE_1_SR"));
        }
        if (this.sr2.isSelected()) {
            this.filters.add(this.util.getBundle().getString("VOICE_2_SR"));
        }
        if (this.sr3.isSelected()) {
            this.filters.add(this.util.getBundle().getString("VOICE_3_SR"));
        }
        if (this.filter.isSelected()) {
            this.filters.add(this.util.getBundle().getString("FCUT_L"));
            this.filters.add(this.util.getBundle().getString("FCUT_H"));
            this.filters.add(this.util.getBundle().getString("FRES"));
        }
        if (this.vol.isSelected()) {
            this.filters.add(this.util.getBundle().getString("FVOL"));
        }
        if (this.paddles.isSelected()) {
            this.filters.add(this.util.getBundle().getString("PADDLE1"));
            this.filters.add(this.util.getBundle().getString("PADDLE2"));
        }
        if (this.osc3.isSelected()) {
            this.filters.add(this.util.getBundle().getString("OSC3"));
        }
        if (this.env3.isSelected()) {
            this.filters.add(this.util.getBundle().getString("ENV3"));
        }
        this.filteredSidRegWrites.clear();
        for (SidRegWrite sidRegWrite : this.allSidRegWrites) {
            if (!this.filters.contains(sidRegWrite.getDescription())) continue;
            this.filteredSidRegWrites.add((Object)sidRegWrite);
        }
    }

    @FXML
    private void doSelectAll() {
        for (CheckBox checkBox : Arrays.asList(this.freq1, this.freq2, this.freq3, this.pulse1, this.pulse2, this.pulse3, this.ctrl1, this.ctrl2, this.ctrl3, this.ad1, this.ad2, this.ad3, this.sr1, this.sr2, this.sr3, this.filter, this.vol, this.paddles, this.osc3, this.env3)) {
            checkBox.setSelected(true);
        }
        this.doUpdateFilter();
    }

    @FXML
    private void doDeselectAll() {
        for (CheckBox checkBox : Arrays.asList(this.freq1, this.freq2, this.freq3, this.pulse1, this.pulse2, this.pulse3, this.ctrl1, this.ctrl2, this.ctrl3, this.ad1, this.ad2, this.ad3, this.sr1, this.sr2, this.sr3, this.filter, this.vol, this.paddles, this.osc3, this.env3)) {
            checkBox.setSelected(false);
        }
        this.doUpdateFilter();
    }

    @FXML
    private void doSaveRegs() {
        FileChooser fileDialog = new FileChooser();
        fileDialog.setInitialDirectory(this.util.getConfig().getSidplay2Section().getLastDirectory());
        File file = fileDialog.showSaveDialog(this.saveRegs.getScene().getWindow());
        if (file != null) {
            this.util.getConfig().getSidplay2Section().setLastDirectory(file.getParentFile());
            File target = new File(file.getParentFile(), IOUtils.getFilenameWithoutSuffix(file.getName()) + ".csv");
            try (FileOutputStream ps = new FileOutputStream(target);){
                SIDRegDriver.writeHeader(ps);
                this.filteredSidRegWrites.stream().forEach(sidRegWrite -> {
                    try {
                        sidRegWrite.writeSidRegister(ps, SIDRegDriver.Format.NORMAL, false);
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Error writing SIDRegDriver stream", e);
                    }
                });
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected void recordSidWrites(boolean enable) {
        if (enable) {
            this.sidRegExtension.init(this.util.getPlayer().getC64().getEventScheduler());
            this.util.getPlayer().addSidListener(this.sidRegExtension);
        } else {
            this.util.getPlayer().removeSidListener(this.sidRegExtension);
        }
    }
}

