/*
 * Decompiled with CFR 0.152.
 */
package net.java.truevfs.kernel.spec;

import java.net.URI;
import net.java.truecommons.shed.Filter;
import net.java.truevfs.kernel.spec.FsMountPoint;

public final class FsPrefixMountPointFilter
implements Filter<FsMountPoint> {
    private final String prefixScheme;
    private final String prefixPath;
    private final int prefixPathLength;
    private final boolean prefixPathEndsWithSeparator;

    private FsPrefixMountPointFilter(FsMountPoint prefix) {
        URI prefixUri = prefix.toHierarchicalUri();
        this.prefixScheme = prefixUri.getScheme();
        this.prefixPath = prefixUri.getPath();
        this.prefixPathLength = this.prefixPath.length();
        this.prefixPathEndsWithSeparator = this.prefixPath.charAt(this.prefixPathLength - 1) == '/';
    }

    public static FsPrefixMountPointFilter forPrefix(FsMountPoint prefix) {
        return new FsPrefixMountPointFilter(prefix);
    }

    public boolean accept(FsMountPoint mountPoint) {
        String uriPath;
        URI uri = mountPoint.toHierarchicalUri();
        return uri.getScheme().equals(this.prefixScheme) && (uriPath = uri.getPath()).startsWith(this.prefixPath) && (this.prefixPathEndsWithSeparator || uriPath.length() == this.prefixPathLength || uriPath.charAt(this.prefixPathLength) == '/');
    }
}

