/*
 * Decompiled with CFR 0.152.
 */
package mpg;

import mpg.Common;
import mpg.Decode;
import mpg.Frame;
import mpg.MPGLib;

public class Layer1 {
    private Common common;
    private Decode decode;

    public Layer1(Common c, Decode d) {
        this.common = c;
        this.decode = d;
    }

    private void I_step_one(MPGLib.mpstr_tag mp, int[] balloc, int[] scale_index, Frame fr) {
        int ba = 0;
        int sca = 0;
        assert (fr.stereo == 1 || fr.stereo == 2);
        if (fr.stereo == 2) {
            int i;
            int jsbound = fr.jsbound;
            for (i = 0; i < jsbound; ++i) {
                balloc[ba++] = this.common.getbits(mp, 4);
                balloc[ba++] = this.common.getbits(mp, 4);
            }
            for (i = jsbound; i < 32; ++i) {
                balloc[ba++] = this.common.getbits(mp, 4);
            }
            ba = 0;
            for (i = 0; i < jsbound; ++i) {
                int n = ba;
                int n2 = balloc[n];
                balloc[n] = n2 + 1;
                if (n2 != 0) {
                    scale_index[sca++] = this.common.getbits(mp, 6);
                }
                if (balloc[ba++] == 0) continue;
                scale_index[sca++] = this.common.getbits(mp, 6);
            }
            for (i = jsbound; i < 32; ++i) {
                if (balloc[ba++] == 0) continue;
                scale_index[sca++] = this.common.getbits(mp, 6);
                scale_index[sca++] = this.common.getbits(mp, 6);
            }
        } else {
            int i;
            for (i = 0; i < 32; ++i) {
                balloc[ba++] = this.common.getbits(mp, 4);
            }
            ba = 0;
            for (i = 0; i < 32; ++i) {
                if (balloc[ba++] == 0) continue;
                scale_index[sca++] = this.common.getbits(mp, 6);
            }
        }
    }

    private void I_step_two(MPGLib.mpstr_tag mp, float[][] fraction, int[] balloc, int[] scale_index, Frame fr) {
        int[] smpb = new int[64];
        int ba = 0;
        int sca = 0;
        assert (fr.stereo == 1 || fr.stereo == 2);
        if (fr.stereo == 2) {
            int n;
            int i;
            int jsbound = fr.jsbound;
            int f0 = 0;
            int f1 = 0;
            ba = 0;
            int sample = 0;
            for (i = 0; i < jsbound; ++i) {
                if ((n = balloc[ba++]) != 0) {
                    smpb[sample++] = this.common.getbits(mp, n + 1);
                }
                if ((n = balloc[ba++]) == 0) continue;
                smpb[sample++] = this.common.getbits(mp, n + 1);
            }
            for (i = jsbound; i < 32; ++i) {
                if ((n = balloc[ba++]) == 0) continue;
                smpb[sample++] = this.common.getbits(mp, n + 1);
            }
            ba = 0;
            sample = 0;
            for (i = 0; i < jsbound; ++i) {
                fraction[0][f0++] = (n = balloc[ba++]) != 0 ? (float)((-1 << n) + smpb[sample++] + 1) * this.common.muls[n + 1][scale_index[sca++]] : 0.0f;
                n = balloc[ba++];
                fraction[1][f1++] = n != 0 ? (float)((-1 << n) + smpb[sample++] + 1) * this.common.muls[n + 1][scale_index[sca++]] : 0.0f;
            }
            for (i = jsbound; i < 32; ++i) {
                if ((n = balloc[ba++]) != 0) {
                    float samp = (-1 << n) + smpb[sample++] + 1;
                    fraction[0][f0++] = samp * this.common.muls[n + 1][scale_index[sca++]];
                    fraction[1][f1++] = samp * this.common.muls[n + 1][scale_index[sca++]];
                    continue;
                }
                int n2 = f0++;
                fraction[1][f1++] = 0.0f;
                fraction[0][n2] = 0.0f;
            }
            for (i = fr.down_sample_sblimit; i < 32; ++i) {
                fraction[1][i] = 0.0f;
                fraction[0][i] = 0.0f;
            }
        } else {
            int n;
            int i;
            int f0 = 0;
            ba = 0;
            int sample = 0;
            for (i = 0; i < 32; ++i) {
                if ((n = balloc[ba++]) == 0) continue;
                smpb[sample++] = this.common.getbits(mp, n + 1);
            }
            ba = 0;
            sample = 0;
            for (i = 0; i < 32; ++i) {
                fraction[0][f0++] = (n = balloc[ba++]) != 0 ? (float)((-1 << n) + smpb[sample++] + 1) * this.common.muls[n + 1][scale_index[sca++]] : 0.0f;
            }
            for (i = fr.down_sample_sblimit; i < 32; ++i) {
                fraction[0][i] = 0.0f;
            }
        }
    }

    public int do_layer1(MPGLib.mpstr_tag mp, float[] pcm_sample, MPGLib.ProcessedBytes pcm_point) {
        int clip = 0;
        int[] balloc = new int[64];
        int[] scale_index = new int[64];
        float[][] fraction = new float[2][32];
        Frame fr = mp.fr;
        int stereo = fr.stereo;
        int single = fr.single;
        int n = fr.jsbound = fr.mode == 1 ? (fr.mode_ext << 2) + 4 : 32;
        if (stereo == 1 || single == 3) {
            single = 0;
        }
        this.I_step_one(mp, balloc, scale_index, fr);
        for (int i = 0; i < 12; ++i) {
            this.I_step_two(mp, fraction, balloc, scale_index, fr);
            if (single >= 0) {
                clip += this.decode.synth1to1mono(mp, fraction[single], 0, pcm_sample, pcm_point);
                continue;
            }
            MPGLib.ProcessedBytes p1 = new MPGLib.ProcessedBytes();
            p1.pb = pcm_point.pb;
            clip += this.decode.synth_1to1(mp, fraction[0], 0, 0, pcm_sample, p1);
            clip += this.decode.synth_1to1(mp, fraction[1], 0, 1, pcm_sample, pcm_point);
        }
        return clip;
    }
}

