/*
 * Decompiled with CFR 0.152.
 */
package sidblaster;

import sidblaster.CommandEnum;

public final class Command {
    private final CommandEnum command;
    private final int device;
    private final byte reg;
    private final byte data;
    private final long startTime;

    public Command(int device, CommandEnum commandEnum) {
        this(device, commandEnum, 0, 0, 0L);
    }

    public Command(int device, CommandEnum commandEnum, byte reg, byte data) {
        this(device, commandEnum, reg, data, 0L);
    }

    public Command(int device, CommandEnum commandEnum, byte reg, byte data, long startTime) {
        this.device = device;
        this.command = commandEnum;
        this.reg = reg;
        this.data = data;
        this.startTime = startTime;
    }

    public int getDevice() {
        return this.device;
    }

    public CommandEnum getCommand() {
        return this.command;
    }

    public byte getReg() {
        return this.reg;
    }

    public byte getData() {
        return this.data;
    }

    public long getDelay() {
        return this.startTime - System.nanoTime();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)this.command);
        builder.append(":");
        builder.append(this.reg);
        builder.append("=");
        builder.append(this.data);
        return builder.toString();
    }
}

