/*
 * Decompiled with CFR 0.152.
 */
package kickass.plugins.std.disk;

import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import kickass.common.output.D64Image;
import kickass.plugins.interf.diskwriter.DiskWriterDefinition;
import kickass.plugins.interf.diskwriter.IDiskData;
import kickass.plugins.interf.diskwriter.IDiskFileData;
import kickass.plugins.interf.diskwriter.IDiskWriter;
import kickass.plugins.interf.general.IEngine;
import kickass.plugins.interf.general.IMemoryBlock;
import kickass.plugins.interf.general.IParameterMap;
import kickass.plugins.interf.general.ISourceRange;
import kickass.plugins.std.disk.FileGenerationInfo;

public class C1541DiskWriter
implements IDiskWriter {
    private static final String diskparam_filename = "filename";
    private static final String diskparam_name = "name";
    private static final String diskparam_id = "id";
    private static final String diskparam_format = "format";
    private static final String diskparam_dontSplitFilesOverDir = "dontSplitFilesOverDir";
    private static final String diskparam_storeFilesInDir = "storeFilesInDir";
    private static final String diskparam_interleave = "interleave";
    private static final String diskparam_showInfo = "showInfo";
    private static final String fileparam_name = "name";
    private static final String fileparam_type = "type";
    private static final String fileparam_interleave = "interleave";
    private static final String fileparam_hide = "hide";
    private static final String fileparam_noStartAddr = "noStartAddr";
    private DiskWriterDefinition definition = new DiskWriterDefinition();

    public C1541DiskWriter() {
        this.definition.setName("cc1541");
        this.definition.setAllDiskParameters(new HashSet<String>(Arrays.asList(diskparam_filename, "name", diskparam_id, diskparam_format, diskparam_dontSplitFilesOverDir, diskparam_storeFilesInDir, "interleave", diskparam_showInfo)));
        this.definition.setNonOptionalDiskParameters(new HashSet<String>(Arrays.asList(diskparam_filename)));
        this.definition.setAllFileParameters(new HashSet<String>(Arrays.asList("name", fileparam_type, fileparam_hide, "interleave", fileparam_noStartAddr)));
        this.definition.setNonOptionalFileParameters(new HashSet<String>(Arrays.asList("name")));
    }

    @Override
    public DiskWriterDefinition getDefinition() {
        return this.definition;
    }

    @Override
    public void execute(IDiskData iDiskData, IEngine iEngine) {
        Object object;
        IParameterMap iParameterMap = iDiskData.getParameters();
        String string = iEngine.normalizeFileName(iParameterMap.getValue(diskparam_filename).getString());
        String string2 = iParameterMap.getStringValue("name", "UNNAMED");
        String string3 = iParameterMap.getStringValue(diskparam_id, "   2A");
        boolean bl = iParameterMap.getBoolValue(diskparam_dontSplitFilesOverDir, false);
        boolean bl2 = iParameterMap.getBoolValue(diskparam_storeFilesInDir, false);
        boolean bl3 = iParameterMap.getBoolValue(diskparam_showInfo, false);
        int n = iParameterMap.getIntValue("interleave", 10);
        D64Image.Format format = iParameterMap.getEnumValue(D64Image.Format.class, diskparam_format, D64Image.Format.COMMODORE);
        if (n < 0) {
            object = iParameterMap.getSourceRange("interleave");
            iEngine.error("Interleave can't be negative: " + n, (ISourceRange)object);
        }
        object = iEngine.stringToBytes(string3);
        byte[] byArray = iEngine.stringToBytes(string2);
        D64Image d64Image = new D64Image(format, !bl, bl2);
        d64Image.setID((byte[])object);
        d64Image.setName(byArray);
        ArrayList<FileGenerationInfo> arrayList = new ArrayList<FileGenerationInfo>();
        for (IDiskFileData object2 : iDiskData.getFiles()) {
            this.addFile(d64Image, object2, n, iEngine, arrayList);
        }
        iEngine.printNow("Writing d64 file: " + string);
        try {
            Iterator iterator = iEngine.openOutputStream(string);
            ((OutputStream)((Object)iterator)).write(d64Image.generateImage());
            ((OutputStream)((Object)iterator)).close();
        }
        catch (D64Image.D64ImageException d64ImageException) {
            iEngine.addError("Error while generating '" + string + "': " + d64ImageException.getMessage(), null);
        }
        catch (Exception exception) {
            iEngine.addError("Error while writing disk '" + string + "': " + exception.getMessage(), null);
        }
        if (bl3) {
            iEngine.printNow("Info for disk '" + string2 + "'");
            for (FileGenerationInfo fileGenerationInfo : arrayList) {
                D64Image.D64File d64File = fileGenerationInfo.d64file;
                iEngine.printNow("  \"" + fileGenerationInfo.name + "\", sectors=" + d64File.nrSectors + ", startTS=" + d64File.track + ":" + d64File.sector);
            }
        }
    }

    private void addFile(D64Image d64Image, IDiskFileData iDiskFileData, int n, IEngine iEngine, List<FileGenerationInfo> list) {
        D64Image.FileType fileType;
        Object object;
        IParameterMap iParameterMap = iDiskFileData.getParameters();
        String string = iParameterMap.getStringValue("name", "");
        byte[] byArray = iEngine.stringToBytes(string);
        boolean bl = !iParameterMap.getBoolValue(fileparam_hide, false);
        int n2 = iParameterMap.getIntValue("interleave", n);
        if (n2 < 0) {
            object = iParameterMap.getSourceRange("interleave");
            iEngine.error("Interleave can't be negative: " + n2, (ISourceRange)object);
        }
        object = iParameterMap.getStringValue(fileparam_type, D64Image.FileType.PRG.toString());
        boolean bl2 = false;
        if (((String)object).endsWith("<")) {
            bl2 = true;
            object = ((String)object).substring(0, ((String)object).length() - 1);
        }
        if ((fileType = C1541DiskWriter.getEnum(D64Image.FileType.class, (String)object)) == null) {
            iEngine.error("Unknown type: " + (String)object, iParameterMap.getSourceRange("name"));
        }
        boolean bl3 = fileType != D64Image.FileType.PRG;
        boolean bl4 = iParameterMap.getBoolValue(fileparam_noStartAddr, bl3);
        byte[] byArray2 = this.blocksToBytes(bl4, iDiskFileData.getMemoryBlocks());
        FileGenerationInfo fileGenerationInfo = new FileGenerationInfo();
        fileGenerationInfo.name = string;
        fileGenerationInfo.d64file = d64Image.addFile(byArray, fileType, n2, byArray2, bl2, bl);
        list.add(fileGenerationInfo);
    }

    private byte[] blocksToBytes(boolean bl, List<IMemoryBlock> list) {
        int n;
        if (list.isEmpty()) {
            return new byte[0];
        }
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        for (IMemoryBlock object2 : list) {
            n = object2.getBytes().length;
            if (n == 0) continue;
            n2 = Math.min(n2, object2.getStartAddress());
            n3 = Math.max(n3, object2.getStartAddress() + n);
        }
        int n4 = n3 - n2 + (bl ? 0 : 2);
        byte[] byArray = new byte[n4];
        n = 0;
        if (!bl) {
            byArray[0] = (byte)n2;
            byArray[1] = (byte)(n2 >>> 8);
            n = 2;
        }
        for (IMemoryBlock iMemoryBlock : list) {
            byte[] byArray2 = iMemoryBlock.getBytes();
            System.arraycopy(byArray2, 0, byArray, iMemoryBlock.getStartAddress() - n2 + n, byArray2.length);
        }
        return byArray;
    }

    private static <T extends Enum<?>> T getEnum(Class<T> clazz, String string) {
        for (Enum enum_ : (Enum[])clazz.getEnumConstants()) {
            if (enum_.name().compareToIgnoreCase(string) != 0) continue;
            return (T)enum_;
        }
        return null;
    }
}

