/*
 * Decompiled with CFR 0.152.
 */
package kickass.state;

import java.util.ArrayList;
import java.util.List;
import kickass.plugins.interf.IPlugin;
import kickass.plugins.interf.archive.IArchive;
import kickass.plugins.interf.autoincludefile.IAutoIncludeFile;
import kickass.plugins.interf.diskwriter.IDiskWriter;
import kickass.plugins.interf.macro.IMacro;
import kickass.plugins.interf.modifier.IModifier;
import kickass.plugins.interf.segmentmodifier.ISegmentModifier;
import kickass.state.EvaluationState;
import kickass.state.namespace.Namespace;

public class PluginManager {
    private EvaluationState state;
    private List<IAutoIncludeFile> autoIncludeFiles = new ArrayList<IAutoIncludeFile>();

    public PluginManager(EvaluationState evaluationState) {
        this.state = evaluationState;
    }

    public List<IAutoIncludeFile> getAutoIncludeFiles() {
        return this.autoIncludeFiles;
    }

    public void registerPlugin(Object object) {
        IPlugin iPlugin;
        boolean bl = false;
        Namespace namespace = this.state.namespaceMgr.getSystemNamespace();
        if (object instanceof IArchive) {
            iPlugin = (IArchive)object;
            for (IPlugin iPlugin2 : iPlugin.getPluginObjects()) {
                this.registerPlugin(iPlugin2);
            }
            bl = true;
        }
        if (object instanceof IMacro) {
            iPlugin = (IMacro)object;
            namespace.getMacroPlugins().put(iPlugin.getDefinition().getName(), (IMacro)iPlugin);
            bl = true;
        }
        if (object instanceof IModifier) {
            iPlugin = (IModifier)object;
            namespace.getModifierPlugins().put(iPlugin.getDefinition().getName(), (IModifier)iPlugin);
            bl = true;
        }
        if (object instanceof ISegmentModifier) {
            iPlugin = (ISegmentModifier)object;
            namespace.getSegmentModifierPlugins().put(iPlugin.getDefinition().getName(), (ISegmentModifier)iPlugin);
            bl = true;
        }
        if (object instanceof IDiskWriter) {
            iPlugin = (IDiskWriter)object;
            this.state.c64OutputMgr.addDiskWriter(iPlugin.getDefinition().getName(), (IDiskWriter)iPlugin);
            bl = true;
        }
        if (object instanceof IAutoIncludeFile) {
            iPlugin = (IAutoIncludeFile)object;
            this.autoIncludeFiles.add((IAutoIncludeFile)iPlugin);
            bl = true;
        }
        if (!bl) {
            this.state.log.println("Warning: The following object registered as a user-plugin but don't implements any plugin interfaces : " + object.getClass().getName());
        }
    }
}

