/*
 * Decompiled with CFR 0.152.
 */
package usbsid;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.logging.Logger;
import javax.usb.UsbConfiguration;
import javax.usb.UsbDevice;
import javax.usb.UsbDeviceDescriptor;
import javax.usb.UsbDisconnectedException;
import javax.usb.UsbEndpoint;
import javax.usb.UsbException;
import javax.usb.UsbHostManager;
import javax.usb.UsbHub;
import javax.usb.UsbInterface;
import javax.usb.UsbInterfacePolicy;
import javax.usb.UsbPipe;
import javax.usb.UsbPlatformException;
import org.usb4java.BufferUtils;
import org.usb4java.Context;
import org.usb4java.Device;
import org.usb4java.DeviceDescriptor;
import org.usb4java.DeviceHandle;
import org.usb4java.DeviceList;
import org.usb4java.LibUsb;
import org.usb4java.LibUsbException;
import org.usb4java.Transfer;
import org.usb4java.TransferCallback;
import usbsid.Cmd;

public class USBSIDDevice {
    private static Logger logger = null;
    private static byte US_CFG;
    private static byte US_ITF;
    private static byte US_EPOUT;
    private static byte US_EPIN;
    private static short VENDOR_ID;
    private static short PRODUCT_ID;
    public static Object device;
    public static boolean us_overrideDriver;
    private static boolean us_isUSBX;
    private static boolean us_isLIBUSB;
    private static boolean us_isAvailable;
    private static boolean us_isOpen;

    public static boolean isOpen() {
        return us_isOpen;
    }

    public static boolean isWinblows() {
        String OS = System.getProperty("os.name").toLowerCase();
        return OS.contains("win");
    }

    private static void setDriverType() {
        if (!USBSIDDevice.isWinblows()) {
            us_isUSBX = true;
        } else {
            us_isLIBUSB = true;
        }
    }

    public static void setdriver_USBSID(String driver) {
        switch (driver) {
            case "usbx": {
                us_isUSBX = true;
                break;
            }
            case "libusb": {
                us_isLIBUSB = true;
                break;
            }
            default: {
                us_isUSBX = true;
            }
        }
        us_overrideDriver = true;
    }

    public static void open_USBSID() {
        if (!us_overrideDriver) {
            USBSIDDevice.setDriverType();
        }
        if (us_isUSBX) {
            try {
                USBX.openUSBX();
            }
            catch (UsbException UE) {
                logger.warning("[USBSID] Exception occured: " + String.valueOf((Object)UE));
                UE.printStackTrace();
            }
        } else if (us_isLIBUSB) {
            try {
                USBL.openLIBUSB();
            }
            catch (LibUsbException LUE) {
                logger.warning("[USBSID] Exception occured: " + String.valueOf((Object)LUE));
                LUE.printStackTrace();
            }
        }
    }

    public static void close_USBSID() {
        USBSIDDevice.sendCommand(Cmd.RESET_SID.get(), (byte)0);
        if (us_isUSBX) {
            try {
                USBX.closeUSBX();
            }
            catch (UsbException UE) {
                logger.warning("[USBSID] Exception occured: " + String.valueOf((Object)UE));
                UE.printStackTrace();
            }
        } else if (us_isLIBUSB) {
            try {
                USBL.closeLIBUSB();
            }
            catch (LibUsbException LUE) {
                logger.warning("[USBSID] Exception occured: " + String.valueOf((Object)LUE));
                LUE.printStackTrace();
            }
        }
    }

    public static void asyncWrite(byte[] buffer) {
        if (us_isUSBX) {
            try {
                USBX.asyncWriteX(buffer);
            }
            catch (UsbException UE) {
                logger.warning("[USBSID] Exception occured: " + String.valueOf((Object)UE));
                UE.printStackTrace();
            }
        } else if (us_isLIBUSB) {
            try {
                USBL.asyncWriteL(buffer);
            }
            catch (LibUsbException LUE) {
                logger.warning("[USBSID] Exception occured: " + String.valueOf((Object)LUE));
                LUE.printStackTrace();
            }
        }
    }

    public static void syncWrite(byte[] buffer) {
        if (us_isUSBX) {
            try {
                USBX.syncWriteX(buffer);
            }
            catch (UsbException UE) {
                logger.warning("[USBSID] Exception occured: " + String.valueOf((Object)UE));
                UE.printStackTrace();
            }
        } else if (us_isLIBUSB) {
            try {
                USBL.syncWriteL(buffer);
            }
            catch (LibUsbException LUE) {
                logger.warning("[USBSID] Exception occured: " + String.valueOf((Object)LUE));
                LUE.printStackTrace();
            }
        }
    }

    public static byte[] syncRead(byte[] buffer, int len) {
        byte[] r = null;
        if (us_isUSBX) {
            try {
                r = USBX.syncReadX(buffer, len);
            }
            catch (UsbException UE) {
                logger.warning("[USBSID] Exception occured: " + String.valueOf((Object)UE));
                UE.printStackTrace();
            }
        } else if (us_isLIBUSB) {
            try {
                r = USBL.syncReadL(buffer, len);
            }
            catch (LibUsbException LUE) {
                logger.warning("[USBSID] Exception occured: " + String.valueOf((Object)LUE));
                LUE.printStackTrace();
            }
        }
        return r;
    }

    public static void sendCommand(byte command, Byte ... subcommands) {
        Byte subcommand = subcommands.length > 0 ? subcommands[0] : (byte)0;
        byte[] message = new byte[3];
        message[0] = (byte)(Cmd.COMMAND.get() << 6 | command);
        message[1] = subcommand;
        USBSIDDevice.syncWrite(message);
    }

    public static void sendConfigCommand(int command, Byte ... args) {
        Byte a = args.length > 0 ? args[0] : (byte)0;
        Byte b = args.length > 1 ? args[1] : (byte)0;
        Byte c = args.length > 2 ? args[2] : (byte)0;
        Byte d = args.length > 3 ? args[3] : (byte)0;
        byte[] message = new byte[]{(byte)(Cmd.COMMAND.get() << 6 | Cmd.CONFIG.get()), (byte)command, a, b, c, d};
        USBSIDDevice.syncWrite(message);
    }

    public static byte[] rwConfigCommand(int command, int len, Byte ... args) {
        Byte a = args.length > 0 ? args[0] : (byte)0;
        Byte b = args.length > 1 ? args[1] : (byte)0;
        Byte c = args.length > 2 ? args[2] : (byte)0;
        Byte d = args.length > 3 ? args[3] : (byte)0;
        byte[] message = new byte[]{(byte)(Cmd.COMMAND.get() << 6 | Cmd.CONFIG.get()), (byte)command, a, b, c, d};
        byte[] result = null;
        result = USBSIDDevice.syncRead(message, len);
        return result;
    }

    static {
        System.setProperty("java.util.logging.SimpleFormatter.format", "[%1$tF %1$tT] [USBSID] [%4$s] %5$s %n");
        logger = Logger.getLogger(USBSIDDevice.class.getName());
        US_CFG = 1;
        US_ITF = 1;
        US_EPOUT = (byte)2;
        US_EPIN = (byte)-126;
        VENDOR_ID = (short)-13570;
        PRODUCT_ID = (short)16401;
        device = null;
        us_overrideDriver = false;
        us_isUSBX = false;
        us_isLIBUSB = false;
        us_isAvailable = false;
        us_isOpen = false;
    }

    private class USBX {
        private static UsbPipe pipe_out = null;
        private static UsbPipe pipe_in = null;
        private static UsbDevice xdevice = null;
        private static UsbConfiguration config = null;
        private static UsbInterface iface = null;
        private static UsbEndpoint ep_out = null;
        private static UsbEndpoint ep_in = null;

        private USBX() {
        }

        private static void openUSBX() throws UsbException {
            xdevice = USBX.findUSBSIDX(UsbHostManager.getUsbServices().getRootUsbHub());
            if (xdevice == null) {
                logger.warning("USBSID-Pico not found");
                return;
            }
            device = xdevice;
            config = xdevice.getUsbConfiguration(US_CFG);
            iface = config.getUsbInterface(US_ITF);
            iface.claim(new UsbInterfacePolicy(){

                public boolean forceClaim(UsbInterface usbInterface) {
                    return true;
                }
            });
            ep_out = iface.getUsbEndpoint(US_EPOUT);
            pipe_out = ep_out.getUsbPipe();
            pipe_out.open();
            ep_in = iface.getUsbEndpoint(US_EPIN);
            pipe_in = ep_in.getUsbPipe();
            pipe_in.open();
            us_isOpen = true;
        }

        private static void closeUSBX() throws UsbException {
            if (pipe_in != null) {
                pipe_in.close();
            }
            if (pipe_out != null) {
                pipe_out.close();
            }
            try {
                if (iface.isClaimed()) {
                    iface.release();
                }
            }
            catch (UsbPlatformException uPE) {
                logger.info("Device not found for re-attaching kernel, skipping.");
            }
        }

        private static UsbDevice findUSBSIDX(UsbHub hub) throws UsbException {
            UsbDevice usbsidpico = null;
            for (UsbDevice xdevice : hub.getAttachedUsbDevices()) {
                if (xdevice.isUsbHub()) {
                    usbsidpico = USBX.findUSBSIDX((UsbHub)xdevice);
                    if (usbsidpico == null) continue;
                    return usbsidpico;
                }
                UsbDeviceDescriptor desc = xdevice.getUsbDeviceDescriptor();
                if (desc.idVendor() != VENDOR_ID || desc.idProduct() != PRODUCT_ID) continue;
                return xdevice;
            }
            return null;
        }

        private static void asyncWriteX(byte[] buffer) throws UsbException {
            try {
                pipe_out.asyncSubmit(buffer);
            }
            catch (UsbDisconnectedException UDE) {
                logger.info("[USBSID] was already disconnected");
            }
        }

        private static void syncWriteX(byte[] buffer) throws UsbException {
            try {
                pipe_out.syncSubmit(buffer);
            }
            catch (UsbDisconnectedException UDE) {
                logger.info("[USBSID] was already disconnected");
            }
        }

        private static byte[] syncReadX(byte[] buffer, int len) throws UsbException {
            byte[] data = new byte[len *= 2];
            try {
                pipe_out.syncSubmit(buffer);
                pipe_in.syncSubmit(data);
            }
            catch (UsbDisconnectedException UDE) {
                logger.info("[USBSID] was already disconnected");
            }
            byte[] b_in = Arrays.copyOfRange(data, 0, len / 2);
            return b_in;
        }
    }

    private class USBL {
        private static Context ctx = null;
        private static DeviceList devicelist = null;
        private static Device ldevice = null;
        private static DeviceHandle devh = null;
        private static Transfer transfer_out = null;
        private static ByteBuffer out_buffer = null;
        private static int len_out_buffer = 64;
        private static int timeout = 0;
        private static int LIBUSB_OPTION_LOG_LEVEL = 0;
        private static int LIBUSB_OPTION_USE_USBDK = 1;
        private static short ACM_CTRL_DTR = 1;
        private static short ACM_CTRL_RTS = (short)2;
        private static boolean kernel_isDetached = false;
        private static int result = -1;
        private static TransferCallback usb_out = new TransferCallback(){

            public void processTransfer(Transfer transfer) {
                if (transfer.status() != 0) {
                    int result = transfer.status();
                    if (result != 3) {
                        logger.severe(MessageFormat.format("[USBSID] Warning: transfer out interrupted with status {0}, {0}: {0}\r", result, LibUsb.errorName((int)result), LibUsb.strError((int)result)));
                    }
                    LibUsb.freeTransfer((Transfer)transfer);
                    return;
                }
                if (transfer.actualLength() != len_out_buffer) {
                    logger.warning(MessageFormat.format("[USBSID] Sent data length {0} is different from the defined buffer length: {0} or actual length {0}\r", transfer.length(), 64, transfer.actualLength()));
                }
            }
        };

        private USBL() {
        }

        private static void openLIBUSB() throws LibUsbException {
            ctx = new Context();
            result = LibUsb.init((Context)ctx);
            if (result != 0) {
                throw new LibUsbException("[USBSID] Unable to initialize libusb.", result);
            }
            LibUsb.setOption((Context)ctx, (int)LIBUSB_OPTION_LOG_LEVEL, (int)0);
            LibUsb.setOption((Context)ctx, (int)LIBUSB_OPTION_USE_USBDK, (int)1);
            result = USBL.findLUSBSID(VENDOR_ID, PRODUCT_ID);
            if (ldevice == null) {
                logger.warning("USBSID-Pico not found");
                return;
            }
            if (ldevice != null && us_isAvailable) {
                try {
                    devh = LibUsb.openDeviceWithVidPid((Context)ctx, (short)VENDOR_ID, (short)PRODUCT_ID);
                }
                catch (LibUsbException LUE) {
                    String error = "[USBSID] Opening device unsuccessful";
                    logger.severe(error);
                    throw new LibUsbException(error, result);
                }
            } else {
                device = null;
                us_isAvailable = false;
                return;
            }
            USBL.detachKernelDriver();
            USBL.configureDevice();
            USBL.initOutBuffer();
            us_isOpen = true;
            device = ldevice;
        }

        private static void closeLIBUSB() throws LibUsbException {
            us_isOpen = false;
            USBL.deinitOutBuffer();
            int result = LibUsb.releaseInterface((DeviceHandle)devh, (int)US_ITF);
            if (result != 0) {
                throw new LibUsbException("[USBSID] Unable to release interface", result);
            }
            if (kernel_isDetached) {
                USBL.releaseInterface();
            }
            LibUsb.exit((Context)ctx);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static int findLUSBSID(short vendorId, short productId) throws LibUsbException {
            devicelist = new DeviceList();
            int result = LibUsb.getDeviceList((Context)ctx, (DeviceList)devicelist);
            if (result < 0) {
                throw new LibUsbException("[USBSID] Unable to get device list", result);
            }
            try {
                for (Device dev : devicelist) {
                    DeviceDescriptor descriptor;
                    result = LibUsb.getDeviceDescriptor((Device)dev, (DeviceDescriptor)(descriptor = new DeviceDescriptor()));
                    if (result != 0) {
                        throw new LibUsbException("[USBSID] Unable to read device descriptor", result);
                    }
                    if (descriptor.idVendor() != vendorId || descriptor.idProduct() != productId) continue;
                    ldevice = dev;
                    us_isAvailable = true;
                    int n = 0;
                    return n;
                }
            }
            finally {
                LibUsb.freeDeviceList((DeviceList)devicelist, (boolean)true);
            }
            return -1;
        }

        private static void configureDevice() {
            try {
                ByteBuffer buffer = ByteBuffer.allocateDirect(0);
                result = LibUsb.controlTransfer((DeviceHandle)devh, (byte)33, (byte)34, (short)((short)(ACM_CTRL_DTR | ACM_CTRL_RTS)), (short)0, (ByteBuffer)buffer, (long)100L);
            }
            catch (LibUsbException LUE) {
                logger.info("CONFIG ERROR: " + result);
            }
        }

        private static void initOutBuffer() {
            try {
                out_buffer = LibUsb.devMemAlloc((DeviceHandle)devh, (int)len_out_buffer);
                if (out_buffer == null) {
                    throw new Exception("[USBSID] LibUsb.devMemAlloc failed", null);
                }
            }
            catch (Exception e) {
                logger.info("[USBSID] Unable to use devMemAlloc, allocating default");
                out_buffer = BufferUtils.allocateByteBuffer((int)len_out_buffer);
            }
            transfer_out = LibUsb.allocTransfer();
            LibUsb.fillBulkTransfer((Transfer)transfer_out, (DeviceHandle)devh, (byte)US_EPOUT, (ByteBuffer)out_buffer, (TransferCallback)usb_out, null, (long)timeout);
        }

        private static void deinitOutBuffer() {
            LibUsb.cancelTransfer((Transfer)transfer_out);
            LibUsb.freeTransfer((Transfer)transfer_out);
            try {
                LibUsb.devMemFree((DeviceHandle)devh, (ByteBuffer)out_buffer, (int)len_out_buffer);
            }
            catch (Exception e) {
                logger.info("[USBSID] Unable to use devMemFree, freeing default");
                out_buffer = null;
            }
        }

        private static void detachKernelDriver() {
            for (int itf = 0; itf < 2; ++itf) {
                if (LibUsb.kernelDriverActive((DeviceHandle)devh, (int)itf) == 1) {
                    try {
                        result = LibUsb.detachKernelDriver((DeviceHandle)devh, (int)itf);
                        if (result != 0 || result != -12) {
                            throw new LibUsbException("[USBSID] Unable to claim interface", result);
                        }
                    }
                    catch (LibUsbException LUE) {
                        logger.info(MessageFormat.format("[USBSID] Detaching kerneldriver for interface {0} result: {0}", itf, LUE.getMessage()));
                    }
                }
                try {
                    result = LibUsb.claimInterface((DeviceHandle)devh, (int)itf);
                    if (result == 0) continue;
                    throw new LibUsbException("[USBSID] Unable to claim interface", result);
                }
                catch (LibUsbException LUE) {
                    logger.info(MessageFormat.format("[USBSID] Claiming interface {0} result: {0}", itf, LUE.getMessage()));
                }
            }
            kernel_isDetached = true;
        }

        private static void releaseInterface() {
            for (int itf = 0; itf < 2; ++itf) {
                if (LibUsb.kernelDriverActive((DeviceHandle)devh, (int)itf) == 1) {
                    try {
                        result = LibUsb.detachKernelDriver((DeviceHandle)devh, (int)itf);
                        if (result != 0 || result != -12) {
                            throw new LibUsbException("[USBSID] Unable to claim interface", result);
                        }
                    }
                    catch (LibUsbException LUE) {
                        logger.info(MessageFormat.format("[USBSID] Detaching kerneldriver for interface {0} result: {0}", itf, LUE.getMessage()));
                    }
                }
                try {
                    result = LibUsb.releaseInterface((DeviceHandle)devh, (int)itf);
                    if (result == 0) continue;
                    throw new LibUsbException("[USBSID] Unable to release interface", result);
                }
                catch (LibUsbException LUE) {
                    logger.info(MessageFormat.format("[USBSID] Release interface {0} result: {0}", itf, LUE.getMessage()));
                }
            }
            kernel_isDetached = false;
        }

        private static void asyncWriteL(byte[] buffer) {
            try {
                out_buffer.put(buffer);
                int result = LibUsb.submitTransfer((Transfer)transfer_out);
                LibUsb.handleEventsCompleted((Context)ctx, null);
                if (result != 0) {
                    throw new LibUsbException("[USBSID] Transfer failed", result);
                }
            }
            catch (LibUsbException LUE) {
                throw new LibUsbException(LUE.getMessage(), LUE.getErrorCode());
            }
            finally {
                out_buffer.position(0);
            }
        }

        private static void syncWriteL(byte[] buffer) throws LibUsbException {
            try {
                ByteBuffer b = ByteBuffer.allocateDirect(buffer.length);
                b.put(buffer);
                IntBuffer transfered = IntBuffer.allocate(1);
                result = LibUsb.bulkTransfer((DeviceHandle)devh, (byte)US_EPOUT, (ByteBuffer)b, (IntBuffer)transfered, (long)timeout);
                if (result != 0) {
                    throw new LibUsbException("[USBSID] Transfer failed", result);
                }
                result = LibUsb.handleEventsTimeout(null, (long)timeout);
                if (result != 0) {
                    throw new LibUsbException("[USBSID] Unable to handle events", result);
                }
            }
            catch (LibUsbException LUE) {
                throw new LibUsbException(LUE.getMessage(), LUE.getErrorCode());
            }
        }

        private static byte[] syncReadL(byte[] buffer, int len) throws LibUsbException {
            len *= 2;
            try {
                ByteBuffer b_out = ByteBuffer.allocateDirect(buffer.length);
                b_out.put(buffer);
                IntBuffer t_out = IntBuffer.allocate(1);
                result = LibUsb.bulkTransfer((DeviceHandle)devh, (byte)US_EPOUT, (ByteBuffer)b_out, (IntBuffer)t_out, (long)timeout);
                ByteBuffer data = ByteBuffer.allocateDirect(len);
                IntBuffer t_in = IntBuffer.allocate(1);
                int result = LibUsb.bulkTransfer((DeviceHandle)devh, (byte)US_EPIN, (ByteBuffer)data, (IntBuffer)t_in, (long)timeout);
                if (result != 0) {
                    throw new LibUsbException("[USBSID] Transfer failed", result);
                }
                result = LibUsb.handleEventsTimeout(null, (long)timeout);
                if (result != 0) {
                    throw new LibUsbException("[USBSID] Unable to handle events", result);
                }
                byte[] b_temp = new byte[data.remaining()];
                data.get(b_temp);
                byte[] b_in = Arrays.copyOfRange(b_temp, 0, len / 2);
                return b_in;
            }
            catch (LibUsbException LUE) {
                throw new LibUsbException(LUE.getMessage(), LUE.getErrorCode());
            }
        }
    }
}

